/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;

public final class MappingScope
implements Serializable {
    private Mapping singleMapping = null;
    private ArrayList mappings = null;
    private MappingScope parent = null;
    private boolean readOnly = false;
    private Object owner = null;

    public Object clone() {
        MappingScope mappingScope = new MappingScope();
        if (this.mappings != null) {
            mappingScope.mappings = (ArrayList)this.mappings.clone();
        }
        mappingScope.singleMapping = this.singleMapping;
        mappingScope.setParent(this.parent);
        return mappingScope;
    }

    public String getOrCreatePrefix(String namespaceURI, String preferPrefix, boolean noDefault) {
        if (namespaceURI.length() != 0) {
            if (preferPrefix != null && preferPrefix.length() == 0 && noDefault) {
                preferPrefix = null;
            }
            Mapping mapping = this.getOrCreateMappingForNamespaceURI(namespaceURI, false, noDefault, preferPrefix);
            return mapping.getPrefix();
        }
        if (noDefault) {
            return "";
        }
        if (this.getMappingForPrefix("", false) != null) {
            this.addMapping("", "");
        }
        return "";
    }

    public Mapping getMappingForPrefix(String prefix, boolean local) {
        MappingScope ms = this;
        while (ms != null) {
            if (ms.singleMapping != null && ms.singleMapping.getPrefix().equals(prefix)) {
                return ms.singleMapping;
            }
            if (ms.mappings != null) {
                for (int i = 0; i < ms.mappings.size(); ++i) {
                    Mapping mapping = (Mapping)ms.mappings.get(i);
                    if (!mapping.getPrefix().equals(prefix)) continue;
                    return mapping;
                }
            }
            ms = local ? null : ms.parent;
        }
        return null;
    }

    public void setParent(MappingScope parent) {
        if (parent == this.parent) {
            return;
        }
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage("readOnlyMS00"));
        }
        MappingScope search = parent;
        while (search != null) {
            if (search == this) {
                throw new RuntimeException(Messages.getMessage("loopyMS00"));
            }
            search = search.parent;
        }
        this.parent = parent;
    }

    public MappingScope getParent() {
        return this.parent;
    }

    public void addMapping(String namespace, String prefix) {
        Mapping mapping = MappingTable.createMapping(namespace, prefix);
        this.addMapping(mapping);
    }

    private void addMapping(Mapping mapping) {
        if (mapping == this.getMappingForPrefix(mapping.getPrefix(), true)) {
            return;
        }
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage("readOnlyMS00"));
        }
        this.removeMappingForPrefix(mapping.getPrefix());
        if (this.singleMapping == null) {
            this.singleMapping = mapping;
        } else {
            if (this.mappings == null) {
                this.mappings = new ArrayList();
            }
            this.mappings.add(mapping);
        }
    }

    public Mapping getMappingForNamespaceURI(String namespaceURI, boolean local, boolean noDefault) {
        MappingScope ms = this;
        boolean research = false;
        while (ms != null) {
            if (ms.singleMapping != null && ms.singleMapping.getNamespaceURI().equals(namespaceURI) && (!noDefault || ms.singleMapping.getPrefix().length() > 0)) {
                return research && ms.singleMapping != this.getMappingForPrefix(ms.singleMapping.getPrefix(), local) ? null : ms.singleMapping;
            }
            if (ms.mappings != null) {
                for (int i = 0; i < ms.mappings.size(); ++i) {
                    Mapping mapping = (Mapping)ms.mappings.get(i);
                    if (!mapping.getNamespaceURI().equals(namespaceURI) || noDefault && mapping.getPrefix().length() <= 0) continue;
                    return research && mapping != this.getMappingForPrefix(mapping.getPrefix(), local) ? null : mapping;
                }
            }
            research = research || ms.singleMapping != null;
            ms = local ? null : ms.parent;
        }
        return null;
    }

    public boolean hasMappings() {
        return this.singleMapping != null;
    }

    public int size() {
        if (this.mappings == null) {
            return this.singleMapping != null ? 1 : 0;
        }
        return this.mappings.size() + (this.singleMapping != null ? 1 : 0);
    }

    public Mapping get(int i) {
        if (i == 0) {
            return this.singleMapping;
        }
        if (this.mappings == null) {
            return null;
        }
        return (Mapping)this.mappings.get(i - 1);
    }

    public boolean removeMappingForPrefix(String prefix) {
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage("readOnlyMS00"));
        }
        if (this.singleMapping != null && this.singleMapping.getPrefix().equals(prefix)) {
            this.singleMapping = this.mappings != null && this.mappings.size() > 0 ? (Mapping)this.mappings.remove(0) : null;
            return true;
        }
        if (this.mappings != null) {
            for (int i = 0; i < this.mappings.size(); ++i) {
                Mapping mapping = (Mapping)this.mappings.get(i);
                if (!mapping.getPrefix().equals(prefix)) continue;
                this.mappings.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean removeMapping(Mapping mapping) {
        int index;
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage("readOnlyMS00"));
        }
        if (this.singleMapping != null && this.singleMapping == mapping) {
            this.singleMapping = this.mappings != null && this.mappings.size() > 0 ? (Mapping)this.mappings.remove(0) : null;
            return true;
        }
        if (this.mappings != null && (index = this.mappings.indexOf(mapping)) >= 0) {
            this.mappings.remove(index);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage("readOnlyMS00"));
        }
        this.singleMapping = null;
        if (this.mappings != null) {
            this.mappings.clear();
        }
    }

    public MappingScope flatten() {
        MappingScope flat = new MappingScope();
        Stack<MappingScope> stack = new Stack<MappingScope>();
        MappingScope ms = this;
        while (ms != null) {
            stack.push(ms);
            ms = ms.parent;
        }
        while (!stack.empty()) {
            ms = (MappingScope)stack.pop();
            for (int i = 0; i < ms.size(); ++i) {
                flat.addMapping(ms.get(i));
            }
        }
        return flat;
    }

    private Mapping getOrCreateMappingForNamespaceURI(String namespaceURI, boolean local, boolean noDefault, String preferPrefix) {
        Mapping mapping = this.getMappingForNamespaceURI(namespaceURI, local, noDefault);
        if (mapping == null) {
            mapping = preferPrefix == null && !noDefault ? MappingTable.createMapping(namespaceURI, "") : (preferPrefix == null ? MappingTable.createMapping(namespaceURI) : MappingTable.createMapping(namespaceURI, preferPrefix));
            this.addMapping(mapping);
        }
        return mapping;
    }

    public void setReadOnly(boolean readOnly, Object owner) {
        if (readOnly == this.readOnly) {
            return;
        }
        if (this.readOnly && !readOnly && this.owner != owner) {
            throw new RuntimeException(Messages.getMessage("readOnlyMS00"));
        }
        this.readOnly = readOnly;
        this.owner = owner;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isReadOnlyOwner(Object owner) {
        return owner == this.owner;
    }

    public String toString() {
        String text = "\n-------------------\n";
        if (this.getParent() != null) {
            text = this.getParent().toString();
        }
        for (int i = 0; i < this.size(); ++i) {
            Mapping m = this.get(i);
            text = text + m.getPrefix() + " --> " + m.getNamespaceURI() + "\n";
        }
        text = text + "-------------------\n";
        return text;
    }
}

