/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.AttributeDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class BeanDeserializerFactory
extends BaseDeserializerFactory {
    protected BeanDesc beanDesc = null;
    protected Map propertyMap = null;

    public BeanDeserializerFactory(Class javaType, QName xmlType) {
        super(BeanDeserializer.class, xmlType, javaType);
        if (JavaUtils.isEnumClass(javaType)) {
            this.deserClass = EnumDeserializer.class;
        }
    }

    public static BeanDeserializerFactory create(Class javaType, QName xmlType, QName compQName, QName compTypeQName) {
        return new BeanDeserializerFactory(javaType, xmlType);
    }

    protected void lazyInitialization() {
        super.lazyInitialization();
        this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
        if (this.beanDesc == null) {
            this.propertyMap = BeanDeserializerFactory.getProperties(this.javaType, null);
        }
    }

    public static Map getProperties(Class javaType, BeanDesc beanDesc) {
        HashMap<String, BeanPropertyDescriptor> propertyMap = null;
        if (beanDesc != null) {
            return beanDesc.getPropertyDescriptorMap();
        }
        BeanPropertyDescriptor[] pd = BeanUtils.getPd(javaType, null);
        propertyMap = new HashMap<String, BeanPropertyDescriptor>();
        for (int i = 0; i < pd.length; ++i) {
            BeanPropertyDescriptor descriptor = pd[i];
            propertyMap.put(descriptor.getName(), descriptor);
        }
        return propertyMap;
    }

    protected Deserializer getSpecialized(String mechanismType) {
        Deserializer beanDeser = super.getSpecialized(mechanismType);
        if (beanDeser != null && beanDeser instanceof AttributeDeserializer && this.beanDesc != null) {
            ((AttributeDeserializer)beanDeser).setup(this.beanDesc, this.beanDesc.getPropertyDescriptorMap());
        }
        return beanDeser;
    }

    protected Deserializer getGeneralPurpose(String mechanismType) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.deserClass == EnumDeserializer.class) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.beanDesc != null) {
            return new BeanDeserializer(this.javaType, this.xmlType, this.beanDesc);
        }
        return new BeanDeserializer(this.javaType, this.xmlType, null, this.propertyMap);
    }

    protected Method getDeserializerMethod(Class clazz) {
        Method method2 = super.getDeserializerMethod(clazz);
        if (method2 == null && !this.deserClass.equals(EnumDeserializer.class)) {
            throw new InternalException(Messages.getMessage("missingHelper00", this.javaType.getName()));
        }
        return method2;
    }
}

