/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDElement;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDFault;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDParameter;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDOperation
extends WSDDElement {
    OperationDesc desc = new OperationDesc();

    public WSDDOperation(OperationDesc desc) {
        this.desc = desc;
    }

    public WSDDOperation(Element e, PortDesc parent) throws WSDDException {
        super(e);
        String retHStr;
        String retTypeStr;
        String retQNameStr;
        this.desc.setParent(parent);
        this.desc.setName(e.getAttribute("name"));
        String qNameStr = e.getAttribute("qname");
        if (qNameStr != null && !qNameStr.equals("")) {
            this.desc.setElementQName(XMLUtils.getQNameFromString(qNameStr, e));
        }
        if ((retQNameStr = e.getAttribute("returnQName")) != null && !retQNameStr.equals("")) {
            this.desc.setReturnQName(XMLUtils.getQNameFromString(retQNameStr, e));
        }
        if ((retTypeStr = e.getAttribute("returnType")) != null && !retTypeStr.equals("")) {
            this.desc.setReturnType(XMLUtils.getQNameFromString(retTypeStr, e));
        }
        if ((retHStr = e.getAttribute("returnHeader")) != null) {
            this.desc.setReturnHeader(JavaUtils.isTrueExplicitly(retHStr));
        }
        Element[] parameters = this.getChildElements(e, "parameter");
        for (int i = 0; i < parameters.length; ++i) {
            Element paramEl = parameters[i];
            WSDDParameter parameter = new WSDDParameter(paramEl, this.desc);
            this.desc.addParameter(parameter.getParameter());
        }
        Element[] faultElems = this.getChildElements(e, "fault");
        for (int i = 0; i < faultElems.length; ++i) {
            Element faultElem = faultElems[i];
            WSDDFault fault = new WSDDFault(faultElem);
            this.desc.addFault(fault.getFaultDesc());
        }
    }

    public void writeToContext(SerializationContext context) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        if (this.desc.getReturnQName() != null) {
            attrs.addAttribute("", "returnQName", "returnQName", "CDATA", context.getSerializationWriter().qName2String(this.desc.getReturnQName()));
        }
        if (this.desc.getReturnType() != null) {
            attrs.addAttribute("", "returnType", "returnType", "CDATA", context.getSerializationWriter().qName2String(this.desc.getReturnType()));
        }
        if (this.desc.isReturnHeader()) {
            attrs.addAttribute("", "returnHeader", "returnHeader", "CDATA", "true");
        }
        if (this.desc.getName() != null) {
            attrs.addAttribute("", "name", "name", "CDATA", this.desc.getName());
        }
        if (this.desc.getElementQName() != null) {
            attrs.addAttribute("", "qname", "qname", "CDATA", context.getSerializationWriter().qName2String(this.desc.getElementQName()));
        }
        context.getSerializationWriter().startElement(this.getElementName(), attrs);
        ArrayList params = this.desc.getParameters();
        Iterator i = params.iterator();
        while (i.hasNext()) {
            ParameterDesc parameterDesc = (ParameterDesc)i.next();
            WSDDParameter p = new WSDDParameter(parameterDesc);
            p.writeToContext(context);
        }
        ArrayList faults = this.desc.getFaults();
        if (faults != null) {
            Iterator i2 = faults.iterator();
            while (i2.hasNext()) {
                FaultDesc faultDesc = (FaultDesc)i2.next();
                WSDDFault f = new WSDDFault(faultDesc);
                f.writeToContext(context);
            }
        }
        context.getSerializationWriter().endElement();
    }

    protected QName getElementName() {
        return QNAME_OPERATION;
    }

    public OperationDesc getOperationDesc() {
        return this.desc;
    }
}

