/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.components.discovery.DiscoverNamesInManagedProperties;
import com.ibm.ws.webservices.engine.components.discovery.DiscoverServiceNames;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.discovery.resource.names.DiscoverMappedNames;
import org.apache.commons.discovery.resource.names.DiscoverNamesInAlternateManagedProperties;
import org.apache.commons.discovery.resource.names.NameDiscoverers;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.discovery.tools.ManagedProperties;
import org.apache.commons.logging.Log;

public class WebServicesProperties {
    protected static Log log = LogFactory.getLog(WebServicesProperties.class.getName());
    private static DiscoverNamesInAlternateManagedProperties altNameDiscoverer;
    private static DiscoverMappedNames mappedNames;

    public static void setClassOverrideProperty(Class clazz, String propertyName) {
        WebServicesProperties.getAlternatePropertyNameDiscoverer().addClassToPropertyNameMapping(clazz.getName(), propertyName);
    }

    public static void setClassDefault(Class clazz, String defaultName) {
        WebServicesProperties.getMappedNames().map(clazz.getName(), defaultName);
    }

    public static void setClassDefaults(Class clazz, String[] defaultNames) {
        WebServicesProperties.getMappedNames().map(clazz.getName(), defaultNames);
    }

    public static ResourceNameDiscover getSPINameDiscoverer() {
        NameDiscoverers nameDiscoverer = new NameDiscoverers();
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)WebServicesProperties.getAlternatePropertyNameDiscoverer());
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)new DiscoverNamesInManagedProperties("com.ibm.wsspi.webservices.", null));
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)new DiscoverServiceNames(WebServicesProperties.getLibClassLoaders(), "com.ibm.wsspi.webservices.", null));
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)WebServicesProperties.getMappedNames());
        return nameDiscoverer;
    }

    public static ResourceClassIterator getSPIResourceClassIterator(Class spi) {
        ResourceNameIterator it = WebServicesProperties.getSPINameDiscoverer().findResourceNames(spi.getName());
        return new DiscoverClasses(WebServicesProperties.getLibClassLoaders()).findResourceClasses(it);
    }

    public static ResourceNameDiscover getNameDiscoverer() {
        NameDiscoverers nameDiscoverer = new NameDiscoverers();
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)WebServicesProperties.getAlternatePropertyNameDiscoverer());
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)new DiscoverNamesInManagedProperties("com.ibm.wsspi.webservices.", null));
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)new DiscoverServiceNames(WebServicesProperties.getLibClassLoaders(), "com.ibm.wsspi.webservices.", null));
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)new DiscoverNamesInManagedProperties());
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)new DiscoverServiceNames(WebServicesProperties.getAppClassLoaders()));
        nameDiscoverer.addResourceNameDiscover((ResourceNameDiscover)WebServicesProperties.getMappedNames());
        return nameDiscoverer;
    }

    public static ResourceClassIterator getResourceClassIterator(Class spi) {
        ResourceNameIterator it = WebServicesProperties.getNameDiscoverer().findResourceNames(spi.getName());
        return new DiscoverClasses(WebServicesProperties.getAppClassLoaders()).findResourceClasses(it);
    }

    private static ClassLoaders getAppClassLoaders() {
        return ClassLoaders.getAppLoaders(WebServicesProperties.class, null, true);
    }

    private static ClassLoaders getLibClassLoaders() {
        return ClassLoaders.getLibLoaders(WebServicesProperties.class, null, true);
    }

    private static DiscoverMappedNames getMappedNames() {
        if (mappedNames == null) {
            mappedNames = new DiscoverMappedNames();
        }
        return mappedNames;
    }

    private static DiscoverNamesInAlternateManagedProperties getAlternatePropertyNameDiscoverer() {
        if (altNameDiscoverer == null) {
            altNameDiscoverer = new DiscoverNamesInAlternateManagedProperties();
        }
        return altNameDiscoverer;
    }

    public static Object newInstance(Class spiClass) {
        return WebServicesProperties.newInstance(spiClass, null, null);
    }

    public static Object newInstance(final Class spiClass, final Class[] constructorParamTypes, final Object[] constructorParams) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator services = WebServicesProperties.getResourceClassIterator(spiClass);
                Object obj = null;
                while (obj == null && services.hasNext()) {
                    Class service = services.nextResourceClass().loadClass();
                    if (service == null) continue;
                    try {
                        ClassUtils.verifyAncestory(spiClass, service);
                        obj = ClassUtils.newInstance(service, constructorParamTypes, constructorParams);
                    }
                    catch (InvocationTargetException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "219", this);
                        if (e.getTargetException() instanceof NoClassDefFoundError) {
                            log.debug(Messages.getMessage("exception00"), e);
                            continue;
                        }
                        log.warn(Messages.getMessage("exception00"), e);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "226", this);
                        log.warn(Messages.getMessage("exception00"), e);
                    }
                }
                return obj;
            }
        });
    }

    public static Object newSPIInstance(Class spiClass) {
        return WebServicesProperties.newSPIInstance(spiClass, null, null);
    }

    public static Object newSPIInstance(final Class spiClass, final Class[] constructorParamTypes, final Object[] constructorParams) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator services = WebServicesProperties.getSPIResourceClassIterator(spiClass);
                Object obj = null;
                while (obj == null && services.hasNext()) {
                    Class service = services.nextResourceClass().loadClass();
                    if (service == null) continue;
                    try {
                        ClassUtils.verifyAncestory(spiClass, service);
                        obj = ClassUtils.newInstance(service, constructorParamTypes, constructorParams);
                    }
                    catch (InvocationTargetException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "219", this);
                        if (e.getTargetException() instanceof NoClassDefFoundError) {
                            log.debug(Messages.getMessage("exception00"), e);
                            continue;
                        }
                        log.warn(Messages.getMessage("exception00"), e);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.WebServicesProperties.run", "226", this);
                        log.warn(Messages.getMessage("exception00"), e);
                    }
                }
                return obj;
            }
        });
    }

    public static String getProperty(final String propertyName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ManagedProperties.getProperty(propertyName);
            }
        });
    }

    public static String getProperty(final String propertyName, final String dephault) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ManagedProperties.getProperty(propertyName, dephault);
            }
        });
    }

    public static void setProperty(String propertyName, String value) {
        ManagedProperties.setProperty(propertyName, value);
    }

    public static void setProperty(String propertyName, String value, boolean isDefault) {
        ManagedProperties.setProperty(propertyName, value, isDefault);
    }

    public static void setProperties(Map newProperties) {
        ManagedProperties.setProperties(newProperties);
    }

    public static void setProperties(Map newProperties, boolean isDefault) {
        ManagedProperties.setProperties(newProperties, isDefault);
    }

    public static Enumeration propertyNames() {
        return ManagedProperties.propertyNames();
    }

    public static Properties getProperties() {
        return ManagedProperties.getProperties();
    }
}

