/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;

class XmlWebAccessor {
    private static TraceComponent tc = Tr.register(XmlWebAccessor.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private final WebApp webApp;
    private final AppDeploymentTask appDeploymentTask;
    private final AppDeploymentInfo appDeploymentInfo;

    XmlWebAccessor(WebApp webApp, AppDeploymentTask appDeploymentTask, AppDeploymentInfo appDeploymentInfo) {
        this.webApp = webApp;
        this.appDeploymentTask = appDeploymentTask;
        this.appDeploymentInfo = appDeploymentInfo;
    }

    String getUrlPatternForServletName(String targetServletName) throws AppDeploymentException {
        int index;
        EList list = this.webApp.getServletMappings();
        Iterator iterator = list.iterator();
        String urlPattern = null;
        while (iterator.hasNext()) {
            ServletMapping mapping = (ServletMapping)iterator.next();
            String servletName = mapping.getServlet().getServletName();
            if (!servletName.equals(targetServletName)) continue;
            if (urlPattern != null) {
                Object[] fillins = new Object[]{util.formUriString(this.appDeploymentInfo, this.webApp), targetServletName};
                String message = MessageFormat.format(util.getMessage(this.appDeploymentTask, "WSWS0031E"), fillins);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getUrlPatternForServletName: " + message);
                }
                Tr.error(tc, "WSWS0031E", fillins);
                throw new AppDeploymentException(message, null);
            }
            urlPattern = mapping.getUrlPattern();
        }
        if (urlPattern != null && (index = urlPattern.indexOf(42)) != -1) {
            Object[] fillins = new Object[]{util.formUriString(this.appDeploymentInfo, this.webApp), urlPattern, targetServletName};
            String message = MessageFormat.format(util.getMessage(this.appDeploymentTask, "WSWS0032E"), fillins);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getUrlPatternForServletName: " + message);
            }
            Tr.error(tc, "WSWS0032E", fillins);
            throw new AppDeploymentException(message, null);
        }
        return urlPattern;
    }
}

