/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCache;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCacheMgr;
import com.ibm.ws.webservices.shared.cache.jaxb.JaxrpcWebServiceInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WsCacheInfo;
import com.ibm.ws.webservices.utils.JAXRPCArtifactLocator;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.wsspi.webservices.models.WSModels;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class JAXRPCMetaDataHelper {
    private static TraceComponent tc = Tr.register(JAXRPCMetaDataHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private ClassLoader classLoader;
    private Set jaxwsClassList;
    private Archive archive;

    public JAXRPCMetaDataHelper(Archive archive, ClassLoader classLoader) {
        this.archive = archive;
        this.classLoader = classLoader;
    }

    public JAXRPCMetaDataHelper(Archive archive, ClassLoader classLoader, Set jaxwsClassList) {
        this.archive = archive;
        this.classLoader = classLoader;
        this.jaxwsClassList = jaxwsClassList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXRPCMetaDataWrapper loadJAXRPCMetaData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadJAXRPCMetaData");
        }
        try {
            JAXRPCMetaDataWrapper wrapper;
            this.checkClassLoader();
            WebServices ws = null;
            String moduleName = this.archive.getName();
            String applicationName = WebServiceUtils.getApplicationName(this.archive);
            List<Object> jaxrpcPortComponents = new ArrayList<String>();
            WebServicesModuleCache cache = WebServicesModuleCacheMgr.getModuleCache(this.archive);
            cache.setClassLoader(this.classLoader);
            cache.load();
            WsCacheInfo cacheInfo = null;
            String webServicesDDFileName = null;
            webServicesDDFileName = this.archive.isWARFile() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
            ws = this.loadWebServicesXML(this.archive.getLoadStrategy(), webServicesDDFileName);
            if (ws == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "A webservices.xml deployment descriptor was not found in the module: " + this.archive.getName() + ". This module will not " + "be inspected for JAX-RPC web service metadata.");
                }
            } else if (cache.exists() && cache.jaxrpcCacheExists()) {
                cacheInfo = cache.getWsCacheInfo();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For module: " + moduleName + " in application: " + applicationName + " JAX-RPC port components were found in " + "the cache.");
                }
                Iterator<JaxrpcWebServiceInfo> jaxrpcInfoIter = cacheInfo.getJaxrpcServices().iterator();
                while (jaxrpcInfoIter.hasNext()) {
                    JaxrpcWebServiceInfo jaxrpcInfo = jaxrpcInfoIter.next();
                    String pcn = jaxrpcInfo.getPortComponentName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding JAX-RPC port component: " + pcn + " from module: " + moduleName);
                    }
                    jaxrpcPortComponents.add(pcn);
                }
            } else if (cache.exists() && !cache.jaxrpcCacheExists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For module: " + moduleName + " in application: " + applicationName + " there was an empty JAX-RPC Port " + "Component cache. No JAX-RPC metadata processing will be done for this module.");
                }
            } else if (!cache.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAX-RPC port component list not found in cache...  looking in deployment descriptor.");
                }
                JAXRPCArtifactLocator locator = new JAXRPCArtifactLocator(this.archive, ws);
                locator.setJAXWSClasses(this.jaxwsClassList);
                locator.setClassLoader(this.classLoader);
                jaxrpcPortComponents = locator.locateJAXRPCPortComponents();
                if (jaxrpcPortComponents == null || jaxrpcPortComponents.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "For module: " + moduleName + " in application: " + applicationName + " there was an empty JAX-RPC " + "Port Component cache. No web service metadata processing will be done for this module.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For module: " + moduleName + " in application: " + applicationName + " " + jaxrpcPortComponents.size() + " JAX-RPC Port Component(s) were found.");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "initializeNeededJAXRPCMetaData= " + this.archive.getName());
            }
            JAXRPCMetaDataWrapper jAXRPCMetaDataWrapper = wrapper = new JAXRPCMetaDataWrapper(ws, jaxrpcPortComponents);
            return jAXRPCMetaDataWrapper;
        }
        catch (Exception e) {
            Tr.error(tc, "jaxrpc.load.metadata.fail", new Object[]{this.archive.getName(), e});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.component.JAXRPCMetaDataHelper", "184", this);
            JAXRPCMetaDataWrapper jAXRPCMetaDataWrapper = null;
            return jAXRPCMetaDataWrapper;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadJAXRPCMetaData");
            }
        }
    }

    private void checkClassLoader() {
        if (this.classLoader == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The JAXRPCMetaDataHelper will use the thread's context classloader");
            }
            this.classLoader = (ClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    WebServices loadWebServicesXML(LoadStrategy loadStrategy, String xmlFilename) {
        try {
            return WSModels.getWebServices(loadStrategy, xmlFilename);
        }
        catch (RuntimeException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "com.ibm.ws.webservices.component.JAXRPCMetaDataHelper.loadWebServicesXML(loadStrategy, xmlFilename): caught Exception reading " + xmlFilename, e);
            }
            return null;
        }
    }
}

