/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ClauseTable {
    private int X = 1;
    private int Y = 1;
    private int Z = 1;
    private Object[][][] array = null;
    int Y_MAX = 200;
    int X_MAX = 200;
    int Z_MAX = 200;
    private Object syncObject = new Object();
    private boolean scalable;
    private HashMap hashMap;

    public ClauseTable() {
    }

    public ClauseTable(boolean scalable) {
        this.scalable = scalable;
        if (scalable) {
            this.hashMap = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int hash) {
        if (this.scalable) {
            return this.hashMap.get(new Integer(hash));
        }
        try {
            Object o;
            Object object = this.syncObject;
            synchronized (object) {
                o = this.array[hash % this.X][hash % this.Y][hash % this.Z];
            }
            if (o == null) {
                return null;
            }
            return o.hashCode() == hash ? o : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object get(Object o) {
        if (this.scalable) {
            return this.hashMap.get(new Integer(o.hashCode() & Integer.MAX_VALUE));
        }
        return this.get(o.hashCode() & Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object o) {
        if (this.scalable) {
            ClauseTable clauseTable = this;
            synchronized (clauseTable) {
                this.hashMap.remove(new Integer(o.hashCode() & Integer.MAX_VALUE));
            }
            return;
        }
        ArrayList list = this.getList();
        list.remove(o);
        this.sync(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getList() {
        if (this.scalable) {
            ClauseTable clauseTable = this;
            synchronized (clauseTable) {
                return new ArrayList(this.hashMap.values());
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.array == null) {
            return list;
        }
        Object object = this.syncObject;
        synchronized (object) {
            for (int x = 0; x < this.X; ++x) {
                for (int y = 0; y < this.Y; ++y) {
                    for (int z = 0; z < this.Z; ++z) {
                        if (this.array[x][y][z] == null) continue;
                        list.add(this.array[x][y][z]);
                    }
                }
            }
        }
        return list;
    }

    public int size() {
        if (this.scalable) {
            return this.hashMap.size();
        }
        return this.getList().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryWithoutCollisions(Object item) {
        try {
            int hash = item.hashCode() & Integer.MAX_VALUE;
            if (this.array == null) {
                return false;
            }
            Object object = this.syncObject;
            synchronized (object) {
                if (this.array[hash % this.X][hash % this.Y][hash % this.Z] != null) {
                    return false;
                }
                this.array[hash % this.X][hash % this.Y][hash % this.Z] = item;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object add(Object item) {
        if (this.scalable) {
            ClauseTable clauseTable = this;
            synchronized (clauseTable) {
                return this.hashMap.put(new Integer(item.hashCode() & Integer.MAX_VALUE), item);
            }
        }
        if (this.tryWithoutCollisions(item)) {
            return item;
        }
        ArrayList list = this.getList();
        Object object = this.syncObject;
        synchronized (object) {
            list.add(item);
        }
        this.sync(list);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(ArrayList items) {
        int z = 0;
        int x = 0;
        int y = 0;
        int siz = items.size();
        boolean condition = false;
        Object[][][] tempArray = null;
        for (int XMax = siz / 3; XMax < this.X_MAX && !condition; ++XMax) {
            for (int YMax = siz / 6; YMax < this.Y_MAX && !condition; ++YMax) {
                for (int ZMax = siz / 9; ZMax < this.Z_MAX && !condition; ++ZMax) {
                    for (x = 1; x < XMax && !condition; ++x) {
                        for (y = 1; y < YMax && !condition; ++y) {
                            if (x == y) continue;
                            block8: for (z = 1; z < ZMax && !condition; ++z) {
                                if (z == y || z == x) continue;
                                tempArray = new Object[x][y][z];
                                condition = true;
                                for (int i = 0; i < siz; ++i) {
                                    int ZBucket;
                                    int YBucket;
                                    int XBucket = Math.abs(items.get(i).hashCode() % x);
                                    if (tempArray[XBucket][YBucket = Math.abs(items.get(i).hashCode() % y)][ZBucket = Math.abs(items.get(i).hashCode() % z)] != null) {
                                        condition = false;
                                        continue block8;
                                    }
                                    tempArray[XBucket][YBucket][ZBucket] = items.get(i);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!condition) {
            throw new RuntimeException("FAILURE!!!!!!!!!!!!!!!!! couldn't add items");
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.array = tempArray;
            this.X = x - 1;
            this.Y = y - 1;
            this.Z = z - 1;
        }
    }

    public void print() {
        for (int i = 0; i < this.X; ++i) {
            for (int j = 0; j < this.Y; ++j) {
                for (int k = 0; k < this.Z; ++k) {
                    System.out.print(this.array[i][j]);
                }
            }
            System.out.println("");
        }
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> transfer = new HashMap<String, String>();
            Hashtable t = new Hashtable();
            ClauseTable c = new ClauseTable();
            String file = "m1.txt";
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            while (line != null) {
                if (line.equals("")) {
                    line = in.readLine();
                    continue;
                }
                StringTokenizer tok = new StringTokenizer(line);
                String tok1 = tok.nextToken();
                String tok2 = tok.nextToken();
                transfer.put(tok1, tok2);
                line = in.readLine();
            }
            in.close();
            Object[] ar = transfer.keySet().toArray();
            long start = System.currentTimeMillis();
            for (int i = 0; i < ar.length - 30; ++i) {
                c.add(ar[i]);
            }
            long end = System.currentTimeMillis();
            for (int i = ar.length - 30; i < ar.length; ++i) {
                c.add(ar[i]);
            }
            System.out.println("" + c.get("/rdfweb.org/people/danbri/rdfweb/danbri-biblio.rdf"));
            long startTime = System.currentTimeMillis();
            int HITS = 40;
            for (int i = 0; i < HITS; ++i) {
                c.get("/rdfweb.org/people/danbri/rdfweb/danbri-biblio.rdf");
            }
            long endTime = System.currentTimeMillis();
            System.out.println("Average put time = " + (double)(end - start) / 206.0);
            System.out.println("Average match time = " + (double)(endTime - startTime) / (double)HITS);
            System.out.println("Size = " + c.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

