/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import javax.management.AttributeList;

public class SchedulerCommandHelper {
    private static final TraceComponent tc = Tr.register(SchedulerCommandHelper.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public Date getNextStartDate(String scheduleName) throws KeyException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNextStartDate", scheduleName);
            }
            if (scheduleName == null) {
                throw new KeyException("Schedule name parameter is null.");
            }
            try {
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                Session session = new Session();
                AdminCommand getUserCmd = commandMgr.createCommand("getWSSchedule");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter(CommandConstants.NAME, scheduleName);
                getUserCmd.execute();
                CommandResult cmdResult = getUserCmd.getCommandResult();
                if (cmdResult.isSuccessful()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found schedule name: " + scheduleName);
                    }
                    AttributeList wsSchedule = (AttributeList)cmdResult.getResult();
                    Long nextStartLong = null;
                    if (wsSchedule != null) {
                        nextStartLong = (Long)ConfigServiceHelper.getAttributeValue(wsSchedule, CommandConstants.NEXT_START_DATE);
                        if (nextStartLong != null && nextStartLong > 0L) {
                            Date nextStartDate = new Date(nextStartLong);
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "getNextStartDate (success) -> ", nextStartDate);
                            }
                            return nextStartDate;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "getNextStartDate (failure) -> null");
                        }
                        return null;
                    }
                    break block13;
                }
                throw new KeyException(cmdResult.getException().getMessage(), (Exception)cmdResult.getException());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.utils.SchedulerCommandHelper.getNextStartDate", "108");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getNextStartDate did not execute.", new Object[]{e});
                }
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                throw new KeyException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextStartDate");
        }
        return null;
    }

    public void updateNextStartDate(String scheduleName, Long newStartDate) throws KeyException {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateNextStartDate", new Object[]{scheduleName, newStartDate});
            }
            if (scheduleName == null) {
                throw new KeyException("Schedule name parameter is null.");
            }
            if (newStartDate == null) {
                throw new KeyException("New start date parameter is null.");
            }
            try {
                StartCommand action = new StartCommand(scheduleName, newStartDate);
                Class<?> cl1 = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                Method theMethod1 = cl1.getMethod("getInstance", null);
                Object ctxMgr = theMethod1.invoke(null, null);
                Class<?> cl2 = Class.forName("com.ibm.ws.security.core.ContextManager");
                Method theMethod2 = cl2.getMethod("runAsSystem", PrivilegedExceptionAction.class);
                theMethod2.invoke(ctxMgr, action);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.SchedulerCommandHelper.updateNextStartDate", "162", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "updateNextStartDate did not execute.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNextStartDate");
        }
    }

    static /* synthetic */ TraceComponent access$000() {
        return tc;
    }

    private class StartCommand
    implements PrivilegedExceptionAction {
        private String name = null;
        private Long date = null;

        public StartCommand(String scheduleName, Long newStartDate) {
            this.name = scheduleName;
            this.date = newStartDate;
        }

        /*
         * Unable to fully structure code
         */
        public Object run() throws Exception {
            cs = null;
            session = null;
            try {
                commandMgr = CommandMgr.getCommandMgr();
                session = new Session();
                getUserCmd = commandMgr.createCommand("getWSSchedule");
                getUserCmd.setConfigSession(session);
                getUserCmd.setParameter(CommandConstants.NAME, this.name);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) ** GOTO lbl45
                if (SchedulerCommandHelper.access$000().isDebugEnabled()) {
                    Tr.debug(SchedulerCommandHelper.access$000(), "Found schedule name: " + this.name);
                }
                if ((wsSchedule = (AttributeList)cmdResult.getResult()) == null) ** GOTO lbl42
                wsScheduleName = (String)ConfigServiceHelper.getAttributeValue(wsSchedule, CommandConstants.NAME);
                frequency = (Integer)ConfigServiceHelper.getAttributeValue(wsSchedule, CommandConstants.FREQUENCY);
                dayOfWeek = (Integer)ConfigServiceHelper.getAttributeValue(wsSchedule, CommandConstants.DAY_OF_WEEK);
                hour = (Integer)ConfigServiceHelper.getAttributeValue(wsSchedule, CommandConstants.HOUR);
                minute = (Integer)ConfigServiceHelper.getAttributeValue(wsSchedule, CommandConstants.MINUTE);
                updateScheduleCmd = commandMgr.createCommand("modifyWSSchedule");
                updateScheduleCmd.setConfigSession(session);
                updateScheduleCmd.setParameter(CommandConstants.NAME, wsScheduleName);
                updateScheduleCmd.setParameter(CommandConstants.FREQUENCY, frequency);
                if (dayOfWeek > 0) {
                    updateScheduleCmd.setParameter(CommandConstants.DAY_OF_WEEK, dayOfWeek);
                }
                updateScheduleCmd.setParameter(CommandConstants.HOUR, hour);
                updateScheduleCmd.setParameter(CommandConstants.MINUTE, minute);
                updateScheduleCmd.setParameter(CommandConstants.NEXT_START_DATE, this.date);
                updateScheduleCmd.execute();
                updateScheduleResult = updateScheduleCmd.getCommandResult();
                if (updateScheduleResult.isSuccessful()) {
                    cs = ConfigServiceFactory.getConfigService();
                    cs.save(session, true);
                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (success)");
                    }
                    var14_15 = null;
                    return var14_15;
                }
                try {
                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (exception)");
                    }
                    throw new KeyException(updateScheduleResult.getException().getMessage(), (Exception)updateScheduleResult.getException());
lbl42:
                    // 1 sources

                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (exception)");
                    }
                    throw new KeyException("Could not get wsSchedule from schedule name: " + this.name);
lbl45:
                    // 1 sources

                    if (SchedulerCommandHelper.access$000().isEntryEnabled()) {
                        Tr.exit(SchedulerCommandHelper.access$000(), "updateNextStartDate (exception)");
                    }
                    throw new KeyException(cmdResult.getException().getMessage(), (Exception)cmdResult.getException());
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.ssl.utils.SchedulerCommandHelper.updateNextStartDate", "247");
                    if (SchedulerCommandHelper.access$000().isDebugEnabled()) {
                        Tr.debug(SchedulerCommandHelper.access$000(), "updateNextStartDate did not execute.", new Object[]{e});
                    }
                    if (e instanceof KeyException) {
                        throw (KeyException)e;
                    }
                    throw new KeyException(e.getMessage(), e);
                }
            }
            finally {
                if (cs != null && session != null) {
                    cs.discard(session);
                }
            }
        }
    }
}

