/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.crypto.config.WSNotifier;
import com.ibm.ws.crypto.config.WSScheduler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityConfigObject;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;

public class CertificateExpirationMonitor
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(CertificateExpirationMonitor.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static ConcurrentHashMap<String, CertificateExpirationMonitor> instanceCache = new ConcurrentHashMap();
    private static Object lockObject = new Object();
    private WSNotifier notifier = null;
    private WSScheduler scheduler = null;
    private String name = null;
    private boolean autoReplace = false;
    private boolean deleteOld = false;
    private int daysBeforeNotification = 30;
    private boolean isEnabled = true;
    private String uuid = null;

    private CertificateExpirationMonitor(SecurityConfigObject monitor, String uuid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{uuid});
        }
        this.name = monitor.getString("name");
        this.autoReplace = monitor.getBoolean("autoReplace");
        this.deleteOld = monitor.getBoolean("deleteOld");
        this.daysBeforeNotification = monitor.getInteger("daysBeforeNotification");
        this.isEnabled = monitor.getBoolean("isEnabled");
        this.uuid = uuid;
        if (this.isEnabled) {
            this.scheduler = new WSScheduler(monitor.getObject("wsSchedule"), (AlarmListener)this, "CertExpMonitor_" + uuid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", new Object[]{this.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertificateExpirationMonitor getInstance(SecurityConfigObject monitor) {
        CertificateExpirationMonitor instance;
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if ((uuid = AdminContext.peek()) == null) {
            uuid = "admin";
        }
        if ((instance = instanceCache.get(uuid)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getInstance did not find CertificateExpirationMonitor in the cache");
            }
            Object object = lockObject;
            synchronized (object) {
                instance = instanceCache.get(uuid);
                if (instance == null && (instance = new CertificateExpirationMonitor(monitor, uuid)) != null) {
                    instanceCache.put(uuid, instance);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInstance found CertificateExpirationMonitor in the cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    public static void releaseInstance() {
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseInstance");
        }
        if ((uuid = AdminContext.peek()) == null) {
            uuid = "admin";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseInstance using uuid " + uuid);
        }
        instanceCache.remove(uuid);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseInstance");
        }
    }

    public void alarm(Object alarmCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", alarmCtx);
        }
        this.monitorExpirations();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public String monitorExpirations() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "monitorExpirations");
        }
        String message = null;
        try {
            StartAlarm action = new StartAlarm();
            Class<?> cl1 = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
            Method theMethod1 = cl1.getMethod("getInstance", null);
            Object ctxMgr = theMethod1.invoke(null, null);
            Class<?> cl2 = Class.forName("com.ibm.ws.security.core.ContextManager");
            Method theMethod2 = cl2.getMethod("runAsSystem", PrivilegedExceptionAction.class);
            message = (String)theMethod2.invoke(ctxMgr, action);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.utils.CertificateExpirationMonitor.alarm", "130", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "monitorExpirations alarm did not execute.", new Object[]{e});
            }
            message = "CertificateExpirationMonitor alarm did not execute; the error is: " + e.getMessage();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "monitorExpirations");
        }
        return message;
    }

    public WSScheduler getScheduler() {
        return this.scheduler;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CertificateExpirationMonitor.toString() {\n");
        buf.append("name = ");
        buf.append(this.name);
        buf.append("\n");
        buf.append("autoReplace = ");
        buf.append(this.autoReplace);
        buf.append("\n");
        buf.append("deleteOld = ");
        buf.append(this.autoReplace);
        buf.append("\n");
        buf.append("daysBeforeNotification = ");
        buf.append(this.daysBeforeNotification);
        buf.append("\n");
        buf.append("isEnabled = ");
        buf.append(this.isEnabled);
        buf.append("\n");
        buf.append("uuid = ");
        buf.append(this.uuid);
        buf.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return buf.toString();
    }

    static /* synthetic */ TraceComponent access$000() {
        return tc;
    }

    class StartAlarm
    implements PrivilegedExceptionAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Object run() throws Exception {
            block12: {
                block13: {
                    errorMessage = null;
                    cs = null;
                    session = null;
                    commandMgr = CommandMgr.getCommandMgr();
                    getUserCmd = commandMgr.createCommand("startCertificateExpMonitor");
                    cs = ConfigServiceFactory.getConfigService();
                    session = new Session();
                    getUserCmd.setConfigSession(session);
                    getUserCmd.setParameter("ExpMonitorSaveConfig", Boolean.TRUE);
                    getUserCmd.execute();
                    cmdResult = getUserCmd.getCommandResult();
                    if (!cmdResult.isSuccessful()) break block12;
                    if (CertificateExpirationMonitor.access$000().isEntryEnabled()) {
                        Tr.exit(CertificateExpirationMonitor.access$000(), "monitorExpirations");
                    }
                    var7_8 = (String)cmdResult.getResult();
                    if (session == null || cs == null) break block13;
                    cs.discard(session);
                }
                return var7_8;
            }
            try {
                e = cmdResult.getException();
                if (CertificateExpirationMonitor.access$000().isDebugEnabled()) {
                    Tr.debug(CertificateExpirationMonitor.access$000(), "monitorExpirations did not execute.", new Object[]{e});
                }
                Tr.error(CertificateExpirationMonitor.access$000(), "ssl.expiration.monitor.start.error.CWPKI0038E", new Object[]{e.getMessage()});
                errorMessage = "Error occurred executing expiration monitor: " + e.getMessage();
                ** if (session == null || cs == null) goto lbl-1000
            }
            catch (Exception e) {
                try {
                    if (CertificateExpirationMonitor.access$000().isDebugEnabled()) {
                        Tr.debug(CertificateExpirationMonitor.access$000(), "monitorExpirations did not execute.", new Object[]{e});
                    }
                    Tr.error(CertificateExpirationMonitor.access$000(), "ssl.expiration.monitor.start.error.CWPKI0038E", new Object[]{e.getMessage()});
                    errorMessage = "Error occurred executing expiration monitor: " + e.getMessage();
                    ** if (session == null || cs == null) goto lbl-1000
                }
                catch (Throwable var8_10) {
                    if (session != null && cs != null) {
                        cs.discard(session);
                    }
                    throw var8_10;
                }
lbl-1000:
                // 1 sources

                {
                    cs.discard(session);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                cs.discard(session);
            }
lbl-1000:
            // 2 sources

            {
            }
            if (CertificateExpirationMonitor.access$000().isEntryEnabled()) {
                Tr.exit(CertificateExpirationMonitor.access$000(), "monitorExpirations");
            }
            return errorMessage;
        }
    }
}

