/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public final class WSPKCSInKeyStoreList {
    private static Vector theV = new Vector();
    private static final TraceComponent tc = Tr.register(WSPKCSInKeyStoreList.class, "SSL", "com.ibm.ws.ssl.resources.ssl");

    public WSPKCSInKeyStore insert(String tokenType, String tokenlib, String tokenPwd, boolean askeystore, boolean pureAcceleration) throws Exception {
        return this.insert(tokenType, tokenlib, tokenPwd, askeystore, "IBMJSSE2", pureAcceleration);
    }

    public synchronized WSPKCSInKeyStore insert(String tokenType, String tokenlib, String tokenPwd, boolean askeystore, String contextProvider, boolean pureAcceleration) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insert");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "token type and tokenLib are: " + tokenType + "," + tokenlib);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "use For Pure Acceleration: " + pureAcceleration);
        }
        WSPKCSInKeyStore pKS = this.insertedAlready(tokenlib);
        boolean already = false;
        if (pKS == null) {
            pKS = new WSPKCSInKeyStore(tokenlib);
        } else {
            already = true;
        }
        if (askeystore) {
            pKS.asKeyStore(tokenType, tokenlib, tokenPwd, contextProvider, pureAcceleration);
        } else {
            pKS.asTrustStore(tokenType, tokenlib, tokenPwd, contextProvider, pureAcceleration);
        }
        if (!already) {
            theV.add(pKS);
        }
        return pKS;
    }

    public WSPKCSInKeyStore getListElement(String tokenlib) {
        return this.insertedAlready(tokenlib);
    }

    public boolean contains(String tokenlib) {
        return true;
    }

    private WSPKCSInKeyStore insertedAlready(String tokenlib) {
        WSPKCSInKeyStore pKS = null;
        if (theV != null) {
            Enumeration e = theV.elements();
            while (!(!e.hasMoreElements() || (pKS = (WSPKCSInKeyStore)e.nextElement()).getlibName_key() != null && pKS.getlibName_key().compareToIgnoreCase(tokenlib) == 0 || pKS.getlibName_trust() != null && pKS.getlibName_trust().compareToIgnoreCase(tokenlib) == 0)) {
                pKS = null;
            }
        }
        return pKS;
    }

    public InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        URL urlFile;
        InputStream fis;
        block10: {
            fis = null;
            urlFile = null;
            File kfile = null;
            Object msg = null;
            try {
                kfile = new File(fileName);
            }
            catch (NullPointerException e) {
                throw new IOException();
            }
            try {
                if (kfile.exists()) {
                    if (kfile.length() == 0L) {
                        throw new IOException(fileName);
                    }
                    urlFile = new URL("file:" + kfile.getCanonicalPath());
                    break block10;
                }
                urlFile = new URL(fileName);
            }
            catch (SecurityException e) {
                throw new IOException(fileName);
            }
        }
        fis = urlFile.openStream();
        return fis;
    }
}

