/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.FIPSManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.core.SSLAdmin;
import com.ibm.ws.ssl.core.SSLConfigChangeListener;
import com.ibm.ws.ssl.core.SSLDiagnosticModule;
import com.ibm.ws.ssl.service.SSLService;
import com.ibm.ws.ssl.service.SSLServiceEvent;
import com.ibm.ws.ssl.service.SSLServiceListener;
import com.ibm.ws.ssl.utils.CertificateExpirationMonitor;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class SSLComponentImpl
extends ComponentImpl
implements SSLService {
    private static final TraceComponent tc = Tr.register(SSLComponentImpl.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private ConfigChangeListener configListener = null;
    private EndPointMgr endPointMgr = null;
    private ArrayList listeners = new ArrayList(32);
    private boolean expandedVariables = false;
    private static HashMap configProps = new HashMap();
    private Properties topLevelProps = null;
    private int componentState = 2;
    private static SSLConfigManager sslConfigManager = SSLConfigManager.getInstance();
    private static KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
    private static KeySetGroupManager keySetGroupManager = KeySetGroupManager.getInstance();
    private static FIPSManager fipsManager = FIPSManager.getInstance();
    private static ManagementScopeManager scopeManager = null;
    private static VariableMap vMap = null;
    private static boolean isServerProcess = false;
    private Repository repository = null;
    private ConfigRoot cfgRoot = null;

    public void initialize(Object config) throws ConfigurationWarning, ConfigurationError {
        Tr.info(tc, "ssl.init.startinit.CWPKI0001I");
        SecurityConfigObject security2 = null;
        isServerProcess = true;
        try {
            this.repository = this.getRepositoryService();
            this.cfgRoot = this.getConfigRoot();
            this.addService(SSLService.class);
            vMap = (VariableMap)this.getService(VariableMap.class);
            scopeManager = ManagementScopeManager.getInstance();
            SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
            security2 = scm.getObject("security");
            sslConfigManager.initializeServerSSL(security2, false);
            scm.getDomain();
            keySetGroupManager.initializeKeySetGroups(security2, false);
            SecurityConfigObject keyStoreSCO = KeyStoreManager.getKeyStore(KeyStoreManager.getDefaultKeyStoreName("RSATokenKeyStore"), null);
            if (keyStoreSCO != null) {
                AuthMechanismConfig rsaMechanism;
                File keyStore;
                String location = keyStoreSCO.getUnexpandedString("location");
                Boolean fileBased = keyStoreSCO.getBoolean("fileBased");
                if (location != null && fileBased != null && fileBased.booleanValue() && !(keyStore = new File(location = KeyStoreManager.getInstance().expand(location))).exists() && (rsaMechanism = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("RSATOKEN")) != null) {
                    rsaMechanism.initializeRSAProperties();
                }
            }
            SSLDiagnosticModule sslDM = new SSLDiagnosticModule();
            sslDM.registerWithFFDCService();
            if (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager")) {
                WSKeyStoreRemotable.setConnectorMap(SSLComponentImpl.getNodeAdminProps());
            }
            if ((!PlatformHelperFactory.getPlatformHelper().isZOS() || PlatformHelperFactory.getPlatformHelper().isZOS() && PlatformHelperFactory.getPlatformHelper().isControlJvm()) && (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") || ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess") && !AdminHelper.getInstance().isCellRegistered() || ManagementScopeManager.getInstance().getProcessType().equals("JobManager") || ManagementScopeManager.getInstance().getProcessType().equals("AdminAgent"))) {
                CertificateExpirationMonitor.getInstance(security2.getObject("wsCertificateExpirationMonitor"));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLComponentImpl.initialize", "200", this);
            Tr.audit(tc, "ssl.init.svcstartfail.CWPKI0007I");
            if (e instanceof ConfigurationError) {
                throw (ConfigurationError)e;
            }
            if (e instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)e;
            }
            throw new ConfigurationError(e);
        }
        Tr.info(tc, "ssl.init.startcomplete.CWPKI0002I");
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        Tr.info(tc, "ssl.init.svcstart.CWPKI0003I");
        try {
            this.registerListenerWithAdminService();
            this.initializeSSLMBean();
            this.fireStartedEvent();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLComponentImpl.start", "243", this);
            Tr.error(tc, "ssl.init.error.CWPKI0008E", new Object[]{e});
            Tr.audit(tc, "ssl.init.svcstartfail.CWPKI0007I");
            throw new RuntimeError(e);
        }
        Tr.info(tc, "ssl.init.svcstartcomplete.CWPKI0004I");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerWithAdminService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerListenerWithAdminService");
        }
        Admin adminService = null;
        try {
            adminService = (Admin)this.getService(Admin.class);
            if (adminService != null) {
                this.configListener = new SSLConfigChangeListener(this);
                adminService.addConfigChangeListener(this.configListener);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithAdminService", "271", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempt to register ConfigChangeListener failed", e);
            }
        }
        finally {
            if (adminService != null) {
                this.releaseService(adminService);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerListenerWithAdminService");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        this.fireStoppedEvent();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    protected Security loadSecurityXMLFromConfig() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityXMLFromConfig");
        }
        Security security2 = null;
        Resource r = null;
        String resourceName = "security.xml";
        try {
            r = this.cfgRoot.getResource(0, resourceName);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.core.SSLComponentImpl.initialize", "310", this);
            Tr.error(tc, "ssl.loadresource.error.CWPKI0011E", new Object[]{resourceName, e});
            throw new ConfigurationError(e);
        }
        Security sec2 = (Security)r.getContents().get(0);
        EtoolsCopyUtility copier = new EtoolsCopyUtility();
        security2 = (Security)copier.copy(sec2);
        if (security2 == null) {
            Tr.error(tc, "ssl.init.nullsecobject.CWPKI0009E");
            throw new ConfigurationError("Cannot get WCCM Security object.  security.xml might be corrupt or missing.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityXMLFromConfig");
        }
        return security2;
    }

    void initializeSSLMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSSLMBean");
        }
        try {
            SSLAdmin sslAdmin = new SSLAdmin();
            MBeanFactory mbeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator collab = new DefaultRuntimeCollaborator(sslAdmin, "SSLAdmin");
            mbeanFactory.activateMBean("SSLAdmin", collab, mbeanFactory.getConfigId("SSLAdmin"), "com/ibm/ws/management/descriptor/xml/SSLAdmin.xml");
        }
        catch (Exception e) {
            Tr.error(tc, "ssl.init.mbeanerror.CWPKI0006E", new Object[]{"SSLAdmin", e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSSLMBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SSLServiceListener l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", l);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SSLServiceListener l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", l);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStartedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStartedEvent");
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int SIZE = list.size();
            SSLServiceEvent e = new SSLServiceEvent(1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + SIZE);
            }
            for (int i = 0; i < SIZE; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    sb.append(list.get(i).hashCode());
                    sb.append("Listener.toString()");
                    sb.append(list.get(i).toString());
                    Tr.debug(tc, sb.toString());
                }
                try {
                    ((SSLServiceListener)list.get(i)).stateChanged(e);
                    continue;
                }
                catch (Exception ex) {
                    Tr.error(tc, "ssl.init.error.CWPKI0008E", new Object[]{ex});
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.core.SSLComponentImpl.fireStartedEvent", "436", this);
                }
            }
        }
        this.componentState = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStartedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStoppedEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireStoppedEvent");
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int SIZE = list.size();
            SSLServiceEvent e = new SSLServiceEvent(2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + SIZE);
            }
            for (int i = 0; i < SIZE; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    sb.append(list.get(i).hashCode());
                    sb.append("Listener.toString()");
                    sb.append(list.get(i).toString());
                    Tr.debug(tc, sb.toString());
                }
                try {
                    ((SSLServiceListener)list.get(i)).stateChanged(e);
                    continue;
                }
                catch (Exception ex) {
                    Tr.error(tc, "ssl.stop.error.CWPKI0015E", new Object[]{ex});
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.ssl.core.SSLComponentImpl.fireStoppedEvent", "6/24/08", this);
                }
            }
        }
        this.componentState = 2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireStoppedEvent");
        }
    }

    public Properties getSecureSocketLayer(String alias) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecureSocketLayer", alias);
        }
        if (alias == null || alias.equals("")) {
            throw new IllegalArgumentException("Alias is null or empty string.");
        }
        SSLConfig sslProps = sslConfigManager.getSSLConfig(alias);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecureSocketLayer");
        }
        return sslProps;
    }

    public ConfigRoot getConfigRoot() {
        try {
            this.cfgRoot = this.repository.getConfigRoot();
            return this.cfgRoot;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Repository getRepositoryService() {
        Repository repository2 = null;
        try {
            repository2 = (Repository)this.getService(Repository.class);
            return repository2;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void releaseRepositoryService(Repository repository2) {
        if (repository2 != null) {
            this.releaseService(repository2);
        }
    }

    private void expandVariables() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariables");
        }
        VariableMap vMap = (VariableMap)this.getService(VariableMap.class);
        String wasFolder = "";
        String userFolder = "";
        String tmpFolder = "";
        String etcFolder = "";
        String propsFolder = "";
        String installedAppsFolder = "";
        try {
            wasFolder = vMap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_INSTALL_ROOT}");
            }
            wasFolder = System.getProperty("was.install.root");
        }
        try {
            userFolder = vMap.expand("${USER_INSTALL_ROOT}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${USER_INSTALL_ROOT}");
            }
            userFolder = System.getProperty("user.install.root", System.getProperty("was.install.root"));
        }
        try {
            tmpFolder = vMap.expand("${WAS_TEMP_DIR}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_TEMP_DIR}");
            }
            tmpFolder = wasFolder + File.separator + "tmp";
        }
        try {
            propsFolder = vMap.expand("${WAS_PROPS_DIR}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_PROPS_DIR}");
            }
            propsFolder = wasFolder + File.separator + "properties";
        }
        try {
            installedAppsFolder = vMap.expand("${APP_INSTALL_ROOT}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${APP_INSTALL_ROOT}");
            }
            installedAppsFolder = wasFolder + File.separator + "installedApps";
        }
        try {
            etcFolder = vMap.expand("${WAS_ETC_DIR}");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_ETC_DIR}");
            }
            etcFolder = wasFolder + File.separator + "etc";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariables");
        }
    }

    public static Properties getProperties(List props) {
        Properties oProps = new Properties();
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                Property p = (Property)props.get(i);
                oProps.put(p.getName(), p.getValue());
            }
        }
        return oProps;
    }

    public static String expand(String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expand <- " + name);
        }
        String expandedName = vMap.expand(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expand -> " + expandedName);
        }
        return expandedName;
    }

    public static boolean isServerProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerProcess");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerProcess -> " + isServerProcess);
        }
        return isServerProcess;
    }

    public static String dumpConfigForFFDC() {
        StringBuffer sb = new StringBuffer();
        sb.append(sslConfigManager.toString());
        sb.append(scopeManager.toString());
        return sb.toString();
    }

    public static Boolean queryProvider(String provider) {
        return new Boolean(StreamHandlerUtils.queryProvider(provider));
    }

    public static void addProvider(String provider, String handler) {
        try {
            StreamHandlerUtils.addProvider(provider, handler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Boolean queryHandler() {
        return new Boolean(StreamHandlerUtils.queryHandler());
    }

    public static void createStreamHandler() {
        try {
            StreamHandlerUtils.createStreamHandler();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Map getNodeAdminProps() throws Exception {
        HashMap<String, Properties> nodeConfigMap;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeAdminProps");
            }
            nodeConfigMap = new HashMap<String, Properties>();
            String cellName = ManagementScopeManager.getInstance().getCellName();
            try {
                ConfigService configService = WsServiceRegistry.getService(SSLComponentImpl.class, ConfigService.class);
                ConfigScope scope = configService.createScope(0);
                String[] nodes = scope.list("nodes");
                if (nodes != null) {
                    for (int i = 0; i < nodes.length; ++i) {
                        String nodeName = nodes[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Node name: " + nodeName);
                        }
                        scope = configService.createScope(3);
                        scope.set(3, nodes[i]);
                        List resource = configService.getDocumentObjects(scope, "serverindex.xml");
                        ConfigObject doc = (ConfigObject)resource.get(0);
                        List servers = doc.getObjectList("serverEntries");
                        for (int j = 0; j < servers.size(); ++j) {
                            Properties p = null;
                            ConfigObject s = (ConfigObject)servers.get(j);
                            String canonicalHostName = null;
                            if (s != null) {
                                p = new Properties();
                                p.setProperty("queryString", "WebSphere:type=SSLAdmin,cell=" + cellName + ",node=" + nodeName + ",*");
                                String type = s.getString("serverType", null);
                                if (type.equals("NODE_AGENT")) {
                                    ConfigObject soapEP = null;
                                    ConfigObject rmiEP = null;
                                    List endpoints = s.getObjectList("specialEndpoints");
                                    for (int k = 0; k < endpoints.size(); ++k) {
                                        ConfigObject nep = (ConfigObject)endpoints.get(k);
                                        if (nep.getString("endPointName", null).equals("SOAP_CONNECTOR_ADDRESS")) {
                                            soapEP = nep.getObject("endPoint");
                                        }
                                        if (!nep.getString("endPointName", null).equals("BOOTSTRAP_ADDRESS") || (rmiEP = nep.getObject("endPoint")) == null) continue;
                                        String rmiPort = new Integer(rmiEP.getInt("port", 0)).toString();
                                        canonicalHostName = rmiEP.getString("host", null);
                                        p.setProperty("java.naming.provider.url", "corbaloc:iiop:" + canonicalHostName + ":" + rmiPort + "/WsnAdminNameService");
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug(tc, "PROVIDER_URL: corbaloc:iiop:" + canonicalHostName + ":" + rmiPort);
                                    }
                                    if (soapEP != null) {
                                        if (canonicalHostName == null) {
                                            canonicalHostName = soapEP.getString("host", null);
                                        }
                                        p.setProperty("SOAP HOST|PORT", soapEP.getString("host", null) + "|" + new Integer(soapEP.getInt("port", 0)).toString());
                                    }
                                    if (rmiEP != null) {
                                        if (canonicalHostName == null) {
                                            canonicalHostName = rmiEP.getString("host", null);
                                        }
                                        p.setProperty("RMI HOST|PORT", rmiEP.getString("host", null) + "|" + new Integer(rmiEP.getInt("port", 0)).toString());
                                    }
                                }
                            }
                            if (p == null || canonicalHostName == null) continue;
                            nodeConfigMap.put(canonicalHostName.toLowerCase(), p);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Set connector props for hostname \"" + canonicalHostName.toLowerCase() + "\" with prop values: " + p.toString());
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.core.SSLComponentImpl.getNodeAdminProps", "799");
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Exception occurred getting Connector props for Node.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAdminProps");
        }
        return nodeConfigMap;
    }
}

