/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.config.WSKeyStoreRemotableInterface;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class WSKeyStoreRemotable
extends WSKeyStore
implements WSKeyStoreRemotableInterface {
    private static final TraceComponent tc = Tr.register(WSKeyStoreRemotable.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private String name = null;
    private static Map connectorPropMap = null;
    private KeyStore ks = null;

    public WSKeyStoreRemotable(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) {
        super(keyStore);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public WSKeyStoreRemotable(WSKeyStore wsks) {
        Enumeration<?> propNames = wsks.propertyNames();
        if (propNames != null) {
            while (propNames.hasMoreElements()) {
                String prop = (String)propNames.nextElement();
                if (prop == null) continue;
                this.setProperty(prop, wsks.getProperty(prop));
            }
        }
    }

    public WSKeyStoreRemotable(KeyStoreInfo ksInfo) {
        super(ksInfo);
    }

    public WSKeyStoreRemotable() {
    }

    public Object[] invokeKeyStoreCommand(String method2, Object[] parms) throws KeyException {
        return this.invokeKeyStoreCommand(method2, parms, Boolean.FALSE);
    }

    public Object[] invokeKeyStoreCommand(String method2, Object[] parms, Boolean createIfNotPresent) throws KeyException {
        Object[] results;
        block40: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invokeKeyStoreCommand", new Object[]{method2});
            }
            results = null;
            try {
                String keyStoreHostList = this.getProperty("com.ibm.ssl.keyStoreHostList");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyStoreHostList is " + keyStoreHostList);
                }
                if (keyStoreHostList != null && !keyStoreHostList.equals("")) {
                    String separator = "\\|";
                    if (keyStoreHostList.indexOf(44) >= 0) {
                        separator = ",";
                    }
                    String[] hostArray = keyStoreHostList.split(separator);
                    this.hostInListAreGood(hostArray);
                    for (int j = 0; j < hostArray.length; ++j) {
                        String host;
                        Properties connectorProps;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Locating connector properties for host: " + hostArray[j]);
                        }
                        if ((connectorProps = (Properties)connectorPropMap.get(host = hostArray[j].toLowerCase())) != null) {
                            String soapHostPort;
                            String[] soapHostPortArray;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found the node connector props, proceeding to call SSLAdmin MBean using AdminClient.");
                            }
                            if ((soapHostPortArray = (soapHostPort = connectorProps.getProperty("SOAP HOST|PORT")).split("\\|")) != null && soapHostPortArray.length == 2) {
                                connectorProps.setProperty("host", soapHostPortArray[0]);
                                connectorProps.setProperty("port", soapHostPortArray[1]);
                                connectorProps.setProperty("type", "SOAP");
                                connectorProps.setProperty("isInternal", "true");
                                AdminClient adminClient = AdminClientFactory.createAdminClient(connectorProps);
                                String queryString = connectorProps.getProperty("queryString");
                                ObjectName queryObject = new ObjectName(queryString);
                                Set s = adminClient.queryNames(queryObject, null);
                                ObjectName sslAdmin = null;
                                if (s.isEmpty()) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit(tc, "invokeKeyStoreCommand: SSLAdmin MBean was not found using queryString " + queryString);
                                    }
                                    throw new KeyException("Cannot get AdminClient to make remote keystore request.");
                                }
                                sslAdmin = (ObjectName)s.iterator().next();
                                if (sslAdmin != null) {
                                    String keyStoreName = this.getProperty("com.ibm.ssl.keyStoreName");
                                    results = (Object[])adminClient.invoke(sslAdmin, "invokeRemoteKeyStoreCommand", new Object[]{keyStoreName, method2, parms}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                                    continue;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invokeKeyStoreCommand: SSLAdmin is null.");
                                }
                                throw new KeyException("Cannot get SSLAdmin MBean to make remote keystore request.");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "invokeKeyStoreCommand: Host/Port property is null.");
                            }
                            throw new KeyException("Cannot get host and port from connector properties.");
                        }
                        Tr.error(tc, "ssl.cannot.find.node.from.hostlist.CWPKI0039E", new Object[]{host, this.getProperty("com.ibm.ssl.keyStoreName")});
                    }
                    break block40;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not remote, Calling local KeyStoreCommand via MBean call .");
                }
                if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    return super.invokeKeyStoreCommand(method2, parms, createIfNotPresent);
                }
                String keyStoreType = this.getProperty("com.ibm.ssl.keyStoreType");
                if (!keyStoreType.equals("JCERACFKS") && !keyStoreType.equals("JCECCARACFKS")) {
                    return super.invokeKeyStoreCommand(method2, parms, createIfNotPresent);
                }
                ObjectName scopeObjName = null;
                String keyStoreMGMTScope = this.getProperty("com.ibm.ssl.keyStoreScope");
                if (keyStoreMGMTScope != null && !keyStoreMGMTScope.equals("")) {
                    ManagementScopeData scopeData = new ManagementScopeData(keyStoreMGMTScope);
                    String scopeString = "WebSphere:type=SSLAdmin";
                    if (scopeData.getCellName() != null) {
                        scopeString = scopeString + ",cell=" + scopeData.getCellName();
                    }
                    if (scopeData.getNodeName() != null) {
                        scopeString = scopeString + ",node=" + scopeData.getNodeName();
                    }
                    if (scopeData.getProcessName() != null) {
                        scopeString = scopeString + ",process=" + scopeData.getProcessName();
                    }
                    scopeString = scopeString + ",*";
                    scopeObjName = new ObjectName(scopeString);
                } else {
                    scopeObjName = new ObjectName("WebSphere:type=SSLAdmin,*");
                }
                Iterator it = AdminServiceFactory.getAdminService().queryNames(scopeObjName, null).iterator();
                if (!it.hasNext()) {
                    if (tc.isDebugEnabled()) {
                        Tr.exit(tc, "SSLAdmin MBean not found. ");
                    }
                    return null;
                }
                if (keyStoreType.equals("JCERACFKS") || keyStoreType.equals("JCECCARACFKS") && new Boolean(this.getProperty("com.ibm.ssl.keyStoreReadOnly")).equals(false)) {
                    String keyStoreName = this.getProperty("com.ibm.ssl.keyStoreName");
                    scopeObjName = (ObjectName)it.next();
                    results = (Object[])AdminServiceFactory.getAdminService().invoke(scopeObjName, "invokeRemoteKeyStoreCommand", new Object[]{keyStoreName, method2, parms}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                    return results;
                }
                Object[] mergedAliases = null;
                while (it.hasNext()) {
                    String keyStoreName = this.getProperty("com.ibm.ssl.keyStoreName");
                    scopeObjName = (ObjectName)it.next();
                    results = (Object[])AdminServiceFactory.getAdminService().invoke(scopeObjName, "invokeRemoteKeyStoreCommand", new Object[]{keyStoreName, method2, parms}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.Object;"});
                    if (method2.substring(0, 3).equals("set")) {
                        return results;
                    }
                    if (method2.equals("aliases")) {
                        if (results == null) continue;
                        if (mergedAliases == null) {
                            List<String> aliasListResults = Arrays.asList((String[])results);
                            ArrayList<String> newAliasList = new ArrayList<String>();
                            Iterator<String> iResults = aliasListResults.iterator();
                            while (iResults.hasNext()) {
                                newAliasList.add(iResults.next());
                            }
                            String[] mergedAliasArray = newAliasList.toArray(new String[newAliasList.size()]);
                            mergedAliases = mergedAliasArray;
                            if (!tc.isEntryEnabled()) continue;
                            Tr.exit(tc, "invokeRemoteKeyStoreCommand - merged Aliases list is ", mergedAliases);
                            continue;
                        }
                        List<String> aliasListMerged = Arrays.asList((String[])mergedAliases);
                        List<String> aliasListResults = Arrays.asList((String[])results);
                        ArrayList<String> newAliasList = new ArrayList<String>();
                        Iterator<String> iResults = aliasListResults.iterator();
                        Iterator<String> iMerged = aliasListMerged.iterator();
                        while (iMerged.hasNext()) {
                            newAliasList.add(iMerged.next());
                        }
                        while (iResults.hasNext()) {
                            String x = iResults.next();
                            if (newAliasList.contains(x)) continue;
                            newAliasList.add(x);
                        }
                        String[] mergedAliasArray = newAliasList.toArray(new String[newAliasList.size()]);
                        mergedAliases = mergedAliasArray;
                        continue;
                    }
                    if (!(method2.equals("isKeyEntry") | method2.equals("isCertificateEntry") | method2.equals("containsAlias") ? results != null && (Boolean)results[0] != false : results != null && results.length > 0 && results[0] != null)) continue;
                    return results;
                }
                if (method2.equals("aliases")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "invokeRemoteKeyStoreCommand - final merged Aliases list is ", mergedAliases);
                    }
                    return mergedAliases;
                }
                return results;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception executing KeyStore method.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.config.WSKeyStore.invokeKeyStoreCommand", "460", this);
                if (e instanceof KeyException) {
                    throw (KeyException)e;
                }
                if (e instanceof MBeanException) {
                    throw new KeyException(e.getCause().getMessage(), e);
                }
                throw new KeyException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeKeyStoreCommand");
        }
        return results;
    }

    private String printParms(Object[] parms) {
        StringBuffer sb = new StringBuffer();
        if (parms == null || parms.length == 0) {
            sb.append("null or empty parms");
            return sb.toString();
        }
        for (int i = 0; i < parms.length; ++i) {
            sb.append("parm ");
            sb.append(i);
            sb.append(": ");
            sb.append(parms[i]);
            sb.append(", ");
        }
        String parmString = sb.toString();
        if (parmString.endsWith(", ")) {
            parmString = parmString.substring(0, parmString.length() - 2);
        }
        return parmString;
    }

    public static void setConnectorMap(Map connectorMap) {
        connectorPropMap = connectorMap;
    }

    private void hostInListAreGood(String[] hosts) throws KeyException {
        for (int j = 0; j < hosts.length; ++j) {
            String host;
            Properties connectorProps;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Locating connector properties for host: " + hosts[j]);
            }
            if ((connectorProps = (Properties)connectorPropMap.get(host = hosts[j].toLowerCase())) != null) continue;
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.cannot.find.node.from.hostlist.CWPKI0039E", new Object[]{host, this.getProperty("com.ibm.ssl.keyStoreName")}, "Cannot find Node connector properties for the hostname " + host + " in the hostlist for keystore " + this.getProperty("com.ibm.ssl.keyStoreName") + ".");
            throw new KeyException(message);
        }
    }
}

