/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadContext;
import com.ibm.ws.util.WSThreadLocal;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;

public class ThreadManager {
    private static final TraceComponent tc = Tr.register(ThreadManager.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static ThreadManager thisClass = null;
    private static WSThreadLocal threadLocStorage = new WSThreadLocal();
    private static InheritableThreadLocal inheritableThreadLocStorage = new InheritableThreadLocal();
    private static boolean useInheritableThreadLocal = false;

    private ThreadManager() {
    }

    public static ThreadManager getInstance() {
        if (thisClass == null) {
            thisClass = new ThreadManager();
            String useInheritableThreadLocalString = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.useInheritableThreadLocalOnClient");
            if (useInheritableThreadLocalString != null && (useInheritableThreadLocalString.equalsIgnoreCase("true") || useInheritableThreadLocalString.equalsIgnoreCase("yes"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "useInheritableThreadLocal is enabled.");
                }
                useInheritableThreadLocal = true;
            }
        }
        return thisClass;
    }

    public ThreadContext getThreadContext() {
        ThreadContext tc;
        if (ThreadManager.tc.isEntryEnabled()) {
            Tr.entry(ThreadManager.tc, "getThreadContext");
        }
        if (useInheritableThreadLocal && !SSLConfigManager.getInstance().isServerProcess()) {
            ThreadContext tc2;
            if (ThreadManager.tc.isEntryEnabled()) {
                Tr.exit(ThreadManager.tc, "getThreadContext (inheritable)");
            }
            if ((tc2 = (ThreadContext)inheritableThreadLocStorage.get()) == null) {
                tc2 = new ThreadContext();
                inheritableThreadLocStorage.set(tc2);
            }
            return tc2;
        }
        if (ThreadManager.tc.isEntryEnabled()) {
            Tr.exit(ThreadManager.tc, "getThreadContext");
        }
        if ((tc = (ThreadContext)threadLocStorage.get()) == null) {
            tc = new ThreadContext();
            threadLocStorage.set(tc);
        }
        return tc;
    }

    public Properties getPropertiesOnThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties");
        }
        return this.getThreadContext().getProperties();
    }

    public void setPropertiesOnThread(Properties sslProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPropertiesOnThread");
        }
        this.getThreadContext().setProperties(sslProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPropertiesOnThread");
        }
    }

    public boolean getSetSignerOnThread() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSetSignerOnThread");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSetSignerOnThread");
        }
        return this.getThreadContext().getSetSignerOnThread();
    }

    public void setSetSignerOnThread(boolean setSigner) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSetSignerOnThread");
        }
        this.getThreadContext().setSetSignerOnThread(setSigner);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSetSignerOnThread");
        }
    }

    public boolean getAutoAcceptBootstrapSigner() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoAcceptBootstrapSigner");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAutoAcceptBootstrapSigner");
        }
        return this.getThreadContext().getAutoAcceptBootstrapSigner();
    }

    public void setAutoAcceptBootstrapSigner(boolean autoAccept) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoAcceptBootstrapSigner");
        }
        this.getThreadContext().setAutoAcceptBootstrapSigner(autoAccept);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoAcceptBootstrapSigner");
        }
    }

    public boolean getAutoAcceptBootstrapSignerWithoutStorage() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoAcceptBootstrapSignerWithoutStorage");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAutoAcceptBootstrapSignerWithoutStorage");
        }
        return this.getThreadContext().getAutoAcceptBootstrapSignerWithoutStorage();
    }

    public void setAutoAcceptBootstrapSignerWithoutStorage(boolean autoAccept) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoAcceptBootstrapSignerWithoutStorage");
        }
        this.getThreadContext().setAutoAcceptBootstrapSignerWithoutStorage(autoAccept);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoAcceptBootstrapSignerWithoutStorage");
        }
    }

    public X509Certificate[] getSignerChain() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignerChain");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignerChain");
        }
        return this.getThreadContext().getSignerChain();
    }

    public void setSignerChain(X509Certificate[] signerChain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignerChain");
        }
        this.getThreadContext().setSignerChain(signerChain);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignerChain");
        }
    }

    public Map getInboundConnectionInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundConnectionInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundConnectionInfo");
        }
        return this.getThreadContext().getInboundConnectionInfo();
    }

    public void setInboundConnectionInfo(Map connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundConnectionInfo");
        }
        this.getThreadContext().setInboundConnectionInfo(connectionInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundConnectionInfo");
        }
    }

    public Map getOutboundConnectionInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundConnectionInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundConnectionInfo");
        }
        return this.getThreadContext().getOutboundConnectionInfo();
    }

    public void setOutboundConnectionInfo(Map connectionInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOutboundConnectionInfo");
        }
        this.getThreadContext().setOutboundConnectionInfo(connectionInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOutboundConnectionInfo");
        }
    }
}

