/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Locale;
import javax.management.ObjectName;

public class RenewCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(RenewCertificate.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certificateAlias = null;
    private Boolean deleteSigners = null;
    private KeyStoreInfo ksInfo = null;
    private KeyStoreInfo rootKsInfo = null;
    private String rootKeyStoreName = null;
    private KeyStoreInfo deletedKsInfo = null;
    private Session session = null;

    public RenewCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public RenewCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName security2 = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            this.session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName cell = cs.resolve(this.session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(this.session, cell, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certificateAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.deleteSigners = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_SIGNERS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope= " + this.keyStoreScope + " certAlias=" + this.certificateAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(this.session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            String usage = this.ksInfo.getUsage();
            this.rootKeyStoreName = usage != null && usage.equals(CommandConstants.KS_USAGE_RSA) ? commandHelper.getDefaultKeyStoreName("RSATokenRootStore", this.session, cs) : commandHelper.getDefaultKeyStoreName("DefaultRootStore", this.session, cs);
            String rootKeyStoreScope = commandHelper.getScopeForNodeKeyStore(this.session, cs, this.rootKeyStoreName);
            this.rootKsInfo = PersonalCertificateHelper.getKsInfo(this.session, cs, this.rootKeyStoreName, rootKeyStoreScope);
            this.deletedKsInfo = commandHelper.getDeletedKeyStore(this.session, cs, this.keyStoreName);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            String rResult = this.personalCertificateRenew(this.session, this.ksInfo, this.certificateAlias, this.keyStoreScope);
            result.setResult(rResult);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public String personalCertificateRenew(Session session, KeyStoreInfo info, String certAlias, String scope) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateRenew");
        }
        StringBuffer rResult = new StringBuffer();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        boolean fileBased = info.getFileBased();
        boolean readOnly = info.getReadOnly();
        String password = info.getPassword();
        Certificate[] certChain = null;
        X509Certificate cert = null;
        PrivateKey certKey = null;
        boolean isCA = false;
        boolean overwrite = false;
        String certificateType = "self-signed";
        boolean signWithDefaultRoot = false;
        try {
            String method2 = "isKeyEntry";
            Object[] parms = new Object[]{certAlias};
            Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)isKeyEntry[0]).booleanValue()) {
                method2 = "getCertificateChain";
                parms = new Object[]{certAlias};
                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                certChain = (Certificate[])certArray[0];
                cert = (X509Certificate)certChain[0];
                method2 = "getKey";
                parms = new Object[]{certAlias, password.toCharArray()};
                Object[] key = wsksr.invokeKeyStoreCommand(method2, parms);
                certKey = (PrivateKey)key[0];
                if (CertificateRequestHelper.isKeyCertReq(cert, certAlias) != null) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{certAlias}, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                    throw new Exception(msg);
                }
            } else {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.not.personal.cert.CWPKI0666E", new Object[]{certAlias}, "Certificate \"" + certAlias + "\" is not a personal certificate.");
                throw new Exception(msg);
            }
            if (cert.getBasicConstraints() != -1) {
                isCA = true;
            }
            if (cert != null && certKey != null) {
                Locale currentLocale;
                String msg;
                block33: {
                    try {
                        cert.verify(cert.getPublicKey());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Certificate to be renewed is self-signed");
                        }
                    }
                    catch (SignatureException e) {
                        certificateType = "chained";
                        if (!tc.isDebugEnabled()) break block33;
                        Tr.debug(tc, "Certificate to be renewed is chained");
                    }
                }
                boolean issuedByWebSphere = true;
                if (certificateType.equalsIgnoreCase("chained")) {
                    issuedByWebSphere = PersonalCertificateHelper.signedByWebSphere((X509Certificate)certChain[certChain.length - 1], certKey, this.rootKsInfo);
                }
                if (!issuedByWebSphere) {
                    ObjectName certRefObj;
                    block34: {
                        ConfigService cs = ConfigServiceFactory.getConfigService();
                        ObjectName security2 = cs.resolve(session, "Cell=:Security=")[0];
                        certRefObj = null;
                        try {
                            certRefObj = PersonalCertificateHelper.getCertificateObj(session, cs, security2, certAlias, info);
                        }
                        catch (CommandValidationException e) {
                            if (!tc.isDebugEnabled()) break block34;
                            Tr.debug(tc, "Error obtaining certificate object: " + e.getMessage());
                        }
                    }
                    if (certRefObj != null) {
                        String msg2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.ca.norenew.CWPKI0702E", new Object[]{certAlias}, "Certificate specified as alias " + certAlias + " is a certificate authority (CA) certificate and must be renewed manually.");
                        throw new Exception(msg2);
                    }
                    String msg3 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.root.cert.not.exist.CWPKI0705E", new Object[]{cert.getSerialNumber().toString(), this.rootKsInfo.getName()}, "The root certificate used to sign the certificate with serial number " + cert.getSerialNumber().toString() + " could not be found in key store " + this.rootKsInfo.getName() + ".");
                    throw new Exception(msg3);
                }
                PublicKey publicKey = cert.getPublicKey();
                int keySize = -1;
                keySize = publicKey instanceof RSAPublicKey ? ((RSAPublicKey)publicKey).getModulus().bitLength() : ((DSAPublicKey)publicKey).getParams().getP().bitLength();
                if (keySize % 2 != 0) {
                    ++keySize;
                }
                Date begin = cert.getNotBefore();
                Date end = cert.getNotAfter();
                long difference = end.getTime() - begin.getTime();
                long differenceDays = difference / 86400000L;
                int validDays = new Long(differenceDays).intValue();
                String subjectDN = ((Object)cert.getSubjectDN()).toString();
                String profileUUID = PersonalCertificateHelper.getUUIDFromCert(cert);
                CertReqInfo certInfo = new CertReqInfo(certAlias, keySize, subjectDN, validDays, this.ksInfo, null);
                if (profileUUID != null) {
                    certInfo.setProfileUUID(profileUUID);
                }
                X509Certificate signer = null;
                X509Certificate oldRootSigner = null;
                X509Certificate newRootSigner = null;
                if (!this.ksInfo.getType().equals("JCERACFKS") && !this.ksInfo.getType().equals("JCECCARACFKS")) {
                    overwrite = true;
                }
                String newAlias = certAlias;
                WSKeyStoreHelper target_wsks = new WSKeyStoreHelper(this.ksInfo);
                WSKeyStoreHelper root_wsks = new WSKeyStoreHelper(this.rootKsInfo);
                if (certificateType.equals("chained")) {
                    String rootCertAlias;
                    String rootCertificateAlias = PersonalCertificateHelper.findRootCertificateAlias((X509Certificate)certChain[1], this.rootKsInfo);
                    if (rootCertificateAlias == null && issuedByWebSphere && (rootCertAlias = PersonalCertificateHelper.getDefaultRootAlias(this.rootKsInfo)) != null) {
                        signWithDefaultRoot = true;
                        rootCertificateAlias = rootCertAlias;
                    }
                    if (rootCertificateAlias == null) {
                        msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.root.cert.not.exist.CWPKI0705E", new Object[]{cert.getSerialNumber().toString(), this.rootKsInfo.getName()}, "The root certificate used to sign the certificate with serial number " + cert.getSerialNumber().toString() + " could not be found in key store " + this.rootKsInfo.getName() + ".");
                        throw new Exception(msg);
                    }
                    Certificate[] rootCertChain = root_wsks.getCertChainFromKey(rootCertificateAlias);
                    Key rootCertKey = root_wsks.getKey(rootCertificateAlias, this.rootKsInfo.getPassword());
                    newAlias = target_wsks.createChainedCertificate(certInfo, rootCertChain, (PrivateKey)rootCertKey, isCA, overwrite);
                    signer = target_wsks.getSigner(newAlias);
                    if (signWithDefaultRoot) {
                        newRootSigner = (X509Certificate)rootCertChain[rootCertChain.length - 1];
                        oldRootSigner = (X509Certificate)certChain[certChain.length - 1];
                    }
                } else if (certificateType.equals("self-signed")) {
                    newAlias = target_wsks.createSelfSignedCertificate(certInfo, isCA, overwrite);
                    signer = target_wsks.getSigner(newAlias);
                }
                if (newAlias != certAlias) {
                    PersonalCertificateHelper.changeAliasReferences(session, info, certAlias, newAlias);
                }
                if (this.ksInfo.getType().equals("JCERACFKS") || this.ksInfo.getType().equals("JCECCARACFKS")) {
                    CommandHelper commandHelper = new CommandHelper();
                    commandHelper.deleteCertificate(session, info, this.deletedKsInfo, certAlias);
                    WSKeyStoreHelper wsksHelper = new WSKeyStoreHelper(this.ksInfo);
                    wsksHelper.deleteCertificate(certAlias);
                }
                if ((currentLocale = this.getLocale()) == null) {
                    currentLocale = Locale.getDefault();
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "locale is null, use system locale:" + currentLocale);
                    }
                }
                msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.renewed.CWPKI0704I", new Object[]{certAlias, info.getName()}, "Personal certificate with alias \"" + certAlias + "\" in KeyStore \"" + info.getName() + "\" was RENEWED.", currentLocale);
                rResult.append(System.getProperty("line.separator"));
                rResult.append(msg);
                rResult.append(PersonalCertificateHelper.replaceCerts(session, info, certAlias, cert, null, signer, null, null, this.deleteSigners, currentLocale));
                if (signWithDefaultRoot) {
                    PersonalCertificateHelper.addNewRootSigner(session, oldRootSigner, newRootSigner);
                }
                if (info.getFileBased().booleanValue()) {
                    PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
                }
            } else {
                String msg = "Certificate not found in keyStore.";
                throw new KeyStoreException(msg);
            }
            PersonalCertificateHelper.markSSLConfigChanged(info, session);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateRenew");
        }
        return rResult.toString();
    }
}

