/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.management.ObjectName;

public class ReceiveCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ReceiveCertificate.class, "SSL", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certAlias = null;
    private String certFilePath = null;
    private String certFilePathExpanded = null;
    private KeyStoreInfo ksInfo = null;

    public ReceiveCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ReceiveCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName pattern = null;
        ObjectName security2 = null;
        Object keyFileName = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certFilePath = (String)this.getParameter(CommandConstants.CERT_FILE_PATH);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certFilePath=" + this.certFilePath + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.ksInfo.getName()}, this.ksInfo.getName() + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            this.certFilePathExpanded = KeyStoreManager.getInstance().expand(this.certFilePath);
            File certFile = new File(this.certFilePathExpanded);
            if (!certFile.isAbsolute()) {
                this.certFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certFilePathExpanded);
                certFile = new File(this.certFilePathExpanded);
            }
            if (certFile == null | !certFile.isFile() | !certFile.canRead()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.file.not.exist.CWPKI0652E", new Object[]{this.certFilePath}, "Certificate file \"" + this.certFilePath + "\" does not exist");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean created = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateReceive(this.ksInfo, this.certFilePathExpanded, this.certAlias);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void personalCertificateReceive(KeyStoreInfo info, String filePath, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateReceive");
        }
        String keyStorePassword = info.getPassword();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        try {
            Session session;
            block16: {
                block17: {
                    block15: {
                        Object[] key;
                        String method2 = null;
                        Object[] parms = null;
                        CertificateFactory certificatefactory = null;
                        Collection<? extends Certificate> collection = null;
                        FileInputStream fis = new FileInputStream(filePath);
                        certificatefactory = CertificateFactory.getInstance("X509");
                        collection = certificatefactory.generateCertificates(fis);
                        X509Certificate[] certFromReqFile = new X509Certificate[collection.size()];
                        Iterator<? extends Certificate> iterator = collection.iterator();
                        int i = 0;
                        while (iterator.hasNext()) {
                            certFromReqFile[i] = (X509Certificate)iterator.next();
                            ++i;
                        }
                        X509Certificate certFromConfig = null;
                        PublicKey publickey = certFromReqFile[0].getPublicKey();
                        if (alias != null) {
                            Object[] containsAlias;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Alias supplied, looking for alias " + alias);
                            }
                            if (!((Boolean)(containsAlias = wsksr.invokeKeyStoreCommand(method2 = "containsAlias", parms = new Object[]{alias}))[0]).booleanValue()) {
                                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.does.not.exist.CWPKI0655E", new Object[]{alias, info.getName()}, "Certificate alais \"" + alias + "\" does not exist in key store \"" + info.getName() + "\".");
                                throw new KeyStoreException(msg);
                            }
                            method2 = "getCertificate";
                            parms = new Object[]{alias};
                            Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                            certFromConfig = (X509Certificate)certArray[0];
                            if (CertificateRequestHelper.isKeyCertReq(certFromConfig, alias) == null) {
                                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{alias}, "Certificate alias \"" + alias + "\" is not a certificate request.");
                                throw new CommandValidationException(msg);
                            }
                            if (!publickey.equals(certFromConfig.getPublicKey())) {
                                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.publickey.not.match.CWPKI0654E", new Object[]{alias}, "Public key from certificate alais \"" + alias + "\" and the public key from the certificate authority do no match.");
                                throw new KeyStoreException(msg);
                            }
                        } else {
                            method2 = "aliases";
                            parms = null;
                            Object[] certAliases = wsksr.invokeKeyStoreCommand(method2, parms);
                            for (int i2 = 0; i2 < certAliases.length; ++i2) {
                                String aliasFromKS = (String)certAliases[i2];
                                method2 = "isKeyEntry";
                                parms = new Object[]{aliasFromKS};
                                Object[] isKeyEntry = wsksr.invokeKeyStoreCommand(method2, parms);
                                method2 = "getCertificate";
                                parms = new Object[]{aliasFromKS};
                                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                                X509Certificate cert = (X509Certificate)certArray[0];
                                if (!((Boolean)isKeyEntry[0]).booleanValue() || CertificateRequestHelper.isKeyCertReq(cert, aliasFromKS) == null || !publickey.equals(cert.getPublicKey())) continue;
                                certFromConfig = cert;
                                alias = aliasFromKS;
                                break;
                            }
                            if (certFromConfig == null) {
                                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.publickey.not.found.CWPKI0662E", new Object[]{info.getName()}, "Certificate with a public key matching the public key in the certificate from the Certificate Authority is not found in key store \"" + info.getName() + "\".");
                                throw new KeyStoreException(msg);
                            }
                        }
                        if ((key = wsksr.invokeKeyStoreCommand(method2 = "getKey", parms = new Object[]{alias, keyStorePassword.toCharArray()})) == null) break block15;
                        method2 = "setKeyEntryOverwrite";
                        parms = new Object[]{alias, (Key)key[0], keyStorePassword != null ? keyStorePassword.toCharArray() : null, certFromReqFile};
                        wsksr.invokeKeyStoreCommand(method2, parms);
                        session = this.getConfigSession();
                        if (!info.getFileBased().booleanValue()) break block16;
                        break block17;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key entry is not found.");
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.key.not.exist.CWPKI0653E", new Object[]{alias}, "Failed to retrieve key for alias \"" + alias + "\" from the key store.");
                    throw new KeyStoreException(msg);
                }
                PersonalCertificateHelper.setWorkspaceUpdated(session, info.getLocation());
            }
            PersonalCertificateHelper.markSSLConfigChanged(info, session);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateImport");
        }
    }
}

