/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.personalCertificates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;

public class ExtractCertificate
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ExtractCertificate.class, "ExtractCertificate", "com.ibm.ws.ssl.commands.personalCertificates");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certAlias = null;
    private String certFilePath = null;
    private String certFilePathExpanded = null;
    private Boolean base64Encoded = null;
    private KeyStoreInfo ksInfo = null;

    public ExtractCertificate(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ExtractCertificate(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certFilePath = (String)this.getParameter(CommandConstants.CERT_FILE_PATH);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.base64Encoded = (Boolean)this.getParameter(CommandConstants.CERT_BASE64ENCODED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certFilePath=" + this.certFilePath + " keyFileDataType=" + this.base64Encoded + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            this.certFilePathExpanded = KeyStoreManager.getInstance().expand(this.certFilePath);
            File certFile = new File(this.certFilePathExpanded);
            if (!certFile.isAbsolute()) {
                this.certFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certFilePathExpanded);
                certFile = new File(this.certFilePathExpanded);
            }
            if (certFile.exists()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.exists.CWPKI0621E", new Object[]{this.certFilePathExpanded}, "File " + this.certFilePathExpanded + " already exists.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.personalCertificateExtract(this.ksInfo, this.certFilePathExpanded, this.certAlias, this.base64Encoded);
            result.setResult(this.certFilePathExpanded);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public void personalCertificateExtract(KeyStoreInfo info, String filePath, String alias, boolean ascii2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "personalCertificateExtract");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] containsAlias = wsksr.invokeKeyStoreCommand(method2, parms);
            if (!((Boolean)containsAlias[0]).booleanValue()) {
                String msg = "Alias " + alias + " is not in keyStore " + info.getName();
            } else {
                File file = new File(filePath);
                if (!file.exists() && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                method2 = "personalCertificateExtract";
                parms = new Object[]{info, filePath, alias, new Boolean(ascii2)};
                wsksr.invokeKeyStoreCommand(method2, parms);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "personalCertificateExtract");
        }
    }
}

