/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.ssl.commands.keyStores.KeyStoreHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListKeyStores
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKeyStores.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String scopeName = null;
    private Boolean allScopes = null;
    private String usage = null;

    public ListKeyStores(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListKeyStores(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (cs == null) {
                AdminClient adminClient = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
                cs = new ConfigServiceProxy(adminClient);
            }
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            CommandHelper commandHelper = new CommandHelper();
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.allScopes = (Boolean)this.getParameter(CommandConstants.ALL);
            this.usage = (String)this.getParameter(CommandConstants.KEY_STORE_USAGE);
            if (this.allScopes == null) {
                this.allScopes = Boolean.FALSE;
            }
            if (this.usage != null && this.usage.length() == 0) {
                this.usage = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "allScopes: " + this.allScopes);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreUsage: " + this.usage);
            }
            List keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
            ArrayList<ObjectName> keyStoreList = new ArrayList<ObjectName>(keyStores.size());
            ArrayList<String> keyStoreListNames = new ArrayList<String>(keyStores.size());
            for (AttributeList keyStore : keyStores) {
                String ksName = (String)ConfigServiceHelper.getAttributeValue(keyStore, "name");
                keyStoreListNames.add(ksName);
            }
            if (this.usage != null && !KeyStoreHelper.ValidUsage(this.usage) && !keyStoreListNames.contains(this.usage)) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.usage.not.valid.CWPKI0708E", "Usage is not valid.");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Usage is not valid.");
                }
                throw new CommandValidationException(msg);
            }
            if (this.scopeName == null && !this.allScopes.booleanValue() && this.usage == null) {
                this.scopeName = commandHelper.defaultScope();
            }
            if (this.allScopes.booleanValue()) {
                this.scopeName = null;
            }
            keyStores = (List)cs.getAttribute(session, security2, CommandConstants.KEY_STORES);
            for (AttributeList keyStore : keyStores) {
                String ksUsage = (String)ConfigServiceHelper.getAttributeValue(keyStore, "usage");
                if (ksUsage == null) {
                    ksUsage = CommandConstants.KS_USAGE_SSL;
                }
                if (this.usage != null && !this.usage.equalsIgnoreCase(ksUsage)) continue;
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(keyStore), null);
                if (this.scopeName != null) {
                    boolean inScope = commandHelper.withInScope(cs, session, keyStore, this.scopeName);
                    if (!inScope) continue;
                    keyStoreList.add(matches[0]);
                    continue;
                }
                keyStoreList.add(matches[0]);
            }
            result.setResult(keyStoreList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

