/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.keyStores;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.util.ArrayList;

public class ListKeyStoreTypes
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKeyStoreTypes.class, "SSL", "com.ibm.ws.ssl.commands");

    public ListKeyStoreTypes(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListKeyStoreTypes(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ArrayList keyStoreTypes = WSKeyStore.getKeyStoreTypes();
            int e = keyStoreTypes.indexOf("PKCS11");
            String type = TraceNLSHelper.getInstance().getString("pkcs11type", "Cryptographic Token Device (PKCS11)");
            if (e != -1) {
                keyStoreTypes.set(e, type);
            } else {
                keyStoreTypes.add(type);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreTypes: " + keyStoreTypes.toString());
            }
            result.setResult(keyStoreTypes);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

