/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.dynamicSSLConfigSelections;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GetDynamicSSLConfigSelection
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetDynamicSSLConfigSelection.class, "SSL", "com.ibm.ws.ssl.commands.dynamicSSLConfigSelection");
    private String dynSSLName = null;
    private String scopeName = null;
    private ObjectName dynSSLNameObjName = null;

    public GetDynamicSSLConfigSelection(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GetDynamicSSLConfigSelection(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ObjectName security2 = null;
        Object dynSSLInfo = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            this.dynSSLName = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(cell);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.dynSSLName);
            this.dynSSLNameObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, queryAttrs, this.scopeName);
            if (this.dynSSLNameObjName == null) {
                String msg = this.dynSSLName + "object not found.";
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e, e.getMessage());
        }
        catch (Exception e) {
            throw new CommandValidationException(e, e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.dynSSLName);
            AttributeList dynSSLAttrs = cs.getAttributes(session, this.dynSSLNameObjName, null, false);
            result.setResult(dynSSLAttrs);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, "GetDynamicSSLConfigSelection command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

