/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.dynamicSSLConfigSelections;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteDynamicSSLConfigSelection
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteDynamicSSLConfigSelection.class, "SSL", "com.ibm.ws.ssl.commands.keyStores");
    private String dynSSLName = null;
    private String scopeName = null;
    private ObjectName dynSSLObjName = null;

    public DeleteDynamicSSLConfigSelection(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteDynamicSSLConfigSelection(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName pattern = null;
        ObjectName matches = null;
        ObjectName security2 = null;
        boolean dynSSLFound = false;
        try {
            pattern = ConfigServiceHelper.createObjectName(null, "Security");
            matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.dynSSLName = (String)this.getParameter(CommandConstants.DYN_SSL_CFG_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.dynSSLName);
            boolean dynSSLNameFound = commandHelper.exists(cs, session, security2, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, queryAttrs, this.scopeName);
            if (!dynSSLNameFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0600E", new Object[]{this.dynSSLName, this.scopeName}, this.dynSSLName + " does not exist within the management scope " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            this.dynSSLObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, queryAttrs, this.scopeName);
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        Object ksInfo = null;
        boolean dynSSLFound = false;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            cs.deleteConfigData(session, this.dynSSLObjName);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

