/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.security.cert.X509Certificate;

public class ExtractCertificateRequest
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ExtractCertificateRequest.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certAlias = null;
    private String certFilePath = null;
    private String certFilePathExpanded = null;
    private KeyStoreInfo ksInfo = null;

    public ExtractCertificateRequest(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ExtractCertificateRequest(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certFilePath = (String)this.getParameter(CommandConstants.CERT_REQ_FILE_PATH);
            this.certAlias = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " keyStoreScope=" + this.keyStoreScope + " certFilePath=" + this.certFilePath + " certAlias=" + this.certAlias);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            this.certFilePathExpanded = KeyStoreManager.getInstance().expand(this.certFilePath);
            File certFile = new File(this.certFilePathExpanded);
            if (!certFile.isAbsolute()) {
                this.certFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certFilePathExpanded);
                certFile = new File(this.certFilePathExpanded);
            }
            if (certFile.exists()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.exists.CWPKI0621E", new Object[]{this.certFilePathExpanded}, "File " + this.certFilePathExpanded + " already exists.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            this.certificateRequestExtract(this.ksInfo, this.certFilePathExpanded, this.certAlias);
            result.setResult(this.certFilePathExpanded);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void certificateRequestExtract(KeyStoreInfo info, String filePath, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "certificateRequestExtract");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        X509Certificate cert = null;
        String certReqFile = null;
        try {
            CertificationRequest certReq;
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{alias};
            Object[] isKeyEntery = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntery[0]).booleanValue()) {
                method2 = "getCertificate";
                parms = new Object[]{alias};
                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                cert = (X509Certificate)certArray[0];
                certReqFile = CertificateRequestHelper.isKeyCertReq(cert, alias);
                if (certReqFile == null) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{alias}, "Certificate alias \"" + alias + "\" is not a certificate request.");
                    throw new CommandValidationException(msg);
                }
                certReq = new CertificationRequest(certReqFile, true);
                File file = new File(filePath);
                if (!file.exists() && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
            } else {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{alias}, "Certificate alias \"" + alias + "\" is not a certificate request.");
                throw new CommandValidationException(msg);
            }
            certReq.writeBASE64(filePath);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certificateRequestExtract");
        }
    }
}

