/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.ws.ssl.commands.certificateRequests.CertificateRequestHelper;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import javax.management.ObjectName;

public class CreateCertificateRequest
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateCertificateRequest.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");
    private String keyStoreName = null;
    private String keyStoreScope = null;
    private String certLabel = null;
    private String certCommonName = null;
    private String certOrganization = null;
    private String certOrganizationalUnit = null;
    private int certSize = 0;
    private String certZip = null;
    private String certCountry = null;
    private String certLocality = null;
    private String certState = null;
    private String certReqFilePath = null;
    private String certReqFilePathExpanded = null;
    private KeyStoreInfo ksInfo = null;
    private CertReqInfo certInfo = null;
    private ObjectName keyStoreObjName = null;
    private KeyStore keyStore = null;
    private WSKeyStore wsKeyStore = null;
    private String subjectDN = null;

    public CreateCertificateRequest(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateCertificateRequest(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        Object pattern = null;
        Object security2 = null;
        Object keyFileName = null;
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
            this.keyStoreScope = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE);
            this.certLabel = (String)this.getParameter(CommandConstants.CERT_ALIAS);
            this.certCommonName = (String)this.getParameter(CommandConstants.CERT_COMMON_NAME);
            this.certSize = (Integer)this.getParameter(CommandConstants.CERT_SIZE);
            this.certOrganization = (String)this.getParameter(CommandConstants.CERT_ORGANIZATION);
            this.certOrganizationalUnit = (String)this.getParameter(CommandConstants.CERT_ORGANIZATIONAL_UNIT);
            this.certLocality = (String)this.getParameter(CommandConstants.CERT_LOCALITY);
            this.certState = (String)this.getParameter(CommandConstants.CERT_STATE);
            this.certZip = (String)this.getParameter(CommandConstants.CERT_ZIP);
            this.certCountry = (String)this.getParameter(CommandConstants.CERT_COUNTRY);
            this.certReqFilePath = (String)this.getParameter(CommandConstants.CERT_REQ_FILE_PATH);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyStoreName=" + this.keyStoreName + " certlabel=" + this.certLabel + " certCommonName=" + this.certCommonName + " certSize=" + this.certSize + " certOrganization=" + this.certOrganization + " certOrganizationalUnit=" + this.certOrganizationalUnit + " certLocality=" + this.certLocality + " certState=" + this.certState + " certZip=" + this.certZip + " certCountry=" + this.certCountry + " certReqFilePath=" + this.certReqFilePath);
            }
            this.subjectDN = PersonalCertificateHelper.makeSubjectDN(this.certCommonName, this.certOrganization, this.certOrganizationalUnit, this.certLocality, this.certState, this.certZip, this.certCountry);
            CommandHelper commandHelper = new CommandHelper();
            if (this.keyStoreScope == null) {
                this.keyStoreScope = commandHelper.defaultScope();
                Tr.debug(tc, "Default cell scopeName: " + this.keyStoreScope);
            }
            this.ksInfo = PersonalCertificateHelper.getKsInfo(session, cs, this.keyStoreName, this.keyStoreScope);
            if (this.ksInfo.getReadOnly().booleanValue()) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.readonly.keystore.CWPKI0699E", new Object[]{this.keyStoreName}, this.keyStoreName + " is marked as a read only key store.  Unable to perform write operations to the key store file.");
                throw new CommandValidationException(msg);
            }
            this.certReqFilePathExpanded = KeyStoreManager.getInstance().expand(this.certReqFilePath);
            File reqFile = new File(this.certReqFilePathExpanded);
            if (!reqFile.isAbsolute()) {
                this.certReqFilePathExpanded = KeyStoreManager.getInstance().expand("${USER_INSTALL_ROOT}" + File.separator + "etc" + File.separator + this.certReqFilePath);
                reqFile = new File(this.certReqFilePathExpanded);
            }
            if (!reqFile.exists() && !reqFile.getParentFile().exists()) {
                reqFile.getParentFile().mkdirs();
            }
            this.certInfo = new CertReqInfo(this.certLabel, this.certSize, this.subjectDN, 365, this.ksInfo, this.certReqFilePathExpanded);
        }
        catch (ConfigServiceException e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new CommandValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            Session session = this.getConfigSession();
            boolean bl = CertificateRequestHelper.personalCertificateCreate(session, this.certInfo);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

