/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.certificateRequests;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.PkEeCertReqFactory;
import com.ibm.security.certclient.PkEeCertReqTransaction;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.management.AttributeList;

public class CertificateRequestHelper {
    private static TraceComponent tc = Tr.register(CertificateRequestHelper.class, "SSL", "com.ibm.ws.ssl.commands.certificateRequests");

    public static AttributeList certReqAttrlist(String alias, X509Certificate cert, String file) throws Exception {
        AttributeList attrList = new AttributeList();
        attrList.clear();
        if (alias != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "alias", alias);
        }
        if (file != null) {
            ConfigServiceHelper.setAttributeValue(attrList, "filename", file);
        }
        try {
            String fingerPrint;
            PublicKey publickey = cert.getPublicKey();
            X509EncodedKeySpec x509encodedkeyspec = new X509EncodedKeySpec(publickey.getEncoded());
            KeyFactory keyfactory = KeyFactory.getInstance(publickey.getAlgorithm());
            int k = 0;
            PublicKey publickey1 = keyfactory.generatePublic(x509encodedkeyspec);
            k = publickey1 instanceof RSAPublicKey ? ((RSAPublicKey)publickey1).getModulus().bitLength() : ((DSAPublicKey)publickey1).getY().bitLength();
            if (k % 2 != 0) {
                ++k;
            }
            ConfigServiceHelper.setAttributeValue(attrList, "size", String.valueOf(k));
            ConfigServiceHelper.setAttributeValue(attrList, "serialNumber", cert.getSerialNumber());
            Principal issuedBy = cert.getIssuerDN();
            if (issuedBy != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "requestedBy", ((Object)issuedBy).toString());
            }
            if ((fingerPrint = KeyStoreManager.getInstance().generateDigest("SHA-1", cert)) != null) {
                ConfigServiceHelper.setAttributeValue(attrList, "fingerPrint", fingerPrint);
            }
            String signatureAlgorithmName = cert.getSigAlgName();
            String signatureAlgorithmOID = cert.getSigAlgOID();
            if (signatureAlgorithmName != null && signatureAlgorithmOID != null) {
                String signatureAlgorithm = new String(signatureAlgorithmName + "(" + signatureAlgorithmOID + ")");
                ConfigServiceHelper.setAttributeValue(attrList, "signatureAlgorithm", signatureAlgorithm);
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        return attrList;
    }

    public static String isKeyCertReq(X509Certificate cert, String alias) {
        String certReqFile;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isKeyCertReq");
            }
            boolean found = false;
            certReqFile = null;
            Object altName = null;
            try {
                Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
                if (altNames != null) {
                    for (List<?> nameList : altNames) {
                        Integer type = (Integer)nameList.get(0);
                        String name = (String)nameList.get(1);
                        if (type == 1) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Certreq id found for in cert for " + alias);
                            }
                            if (name.equals("certreq@us.ibm.com")) {
                                found = true;
                            }
                        }
                        if (type != 6) continue;
                        certReqFile = name;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Certreq file name, " + certReqFile + " found for " + alias);
                    }
                    if (found && certReqFile != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This is a certificate request return the file name.");
                        }
                    } else {
                        found = false;
                        certReqFile = null;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception checking to certificate.", new Object[]{e});
            }
        }
        if (certReqFile != null) {
            certReqFile = certReqFile.substring(certReqFile.indexOf("file://") + 7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyCertReq");
        }
        return certReqFile;
    }

    public static boolean personalCertificateCreate(Session session, CertReqInfo ssCertInfo) throws Exception {
        boolean certCreated = false;
        String alias = null;
        String subjectDN = null;
        int size = 0;
        boolean validDays = false;
        KeyStoreInfo keyStoreInfo = null;
        String keyStoreProvider = null;
        String password = null;
        String filePath = null;
        String reqFilePath = null;
        String cn = null;
        String dn = null;
        subjectDN = ssCertInfo.getSubjectDN();
        alias = ssCertInfo.getLabel();
        size = ssCertInfo.getSize();
        reqFilePath = ssCertInfo.getFilename();
        filePath = "file://" + reqFilePath;
        keyStoreInfo = ssCertInfo.getKsInfo();
        keyStoreProvider = keyStoreInfo.getProvider();
        password = keyStoreInfo.getPassword();
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(keyStoreInfo);
        PkSsCertificate ssCertificate = null;
        X509Certificate certificate = null;
        PrivateKey privateKey = null;
        String reqName = alias + "_certreq";
        String locKeyType = "RSA";
        String provider = "IBMJCE";
        String randomNoGenerator = "IBMSecureRandom";
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("certreq@us.ibm.com");
        attrs.add("CERTREQUEST");
        attrs.add(filePath);
        if (subjectDN.indexOf(",") != -1) {
            cn = subjectDN.substring(0, subjectDN.indexOf(","));
            dn = subjectDN.substring(subjectDN.indexOf(",") + 1);
        } else {
            cn = subjectDN;
        }
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] containsAlias = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)containsAlias[0]).booleanValue()) {
                String msg = alias + " already exists.";
                throw new CommandValidationException(msg);
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(locKeyType, provider);
            SecureRandom secureRandom = SecureRandom.getInstance(randomNoGenerator, provider);
            keyPairGenerator.initialize(size, secureRandom);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PkEeCertReqTransaction certReqTrans = PkEeCertReqFactory.newCertRequest((int)size, (String)cn, (int)365, (boolean)true, (boolean)false, null, null, null, null, null, (String)dn, (KeyPair)keyPair);
            if (certReqTrans != null) {
                Date deltaDate = new Date();
                deltaDate.setTime(deltaDate.getTime() - 86400000L);
                ssCertificate = PkSsCertFactory.newSsCert((int)size, (String)subjectDN, (int)365, (Date)deltaDate, (boolean)true, (boolean)true, attrs, null, null, (String)"IBMJCE", (KeyPair)keyPair);
                if (ssCertificate != null) {
                    certificate = ssCertificate.getCertificate();
                    privateKey = ssCertificate.getKey();
                    method2 = "setKeyEntry";
                    parms = new Object[]{alias, privateKey, password.toCharArray(), new X509Certificate[]{certificate}};
                    wsksr.invokeKeyStoreCommand(method2, parms);
                    certCreated = true;
                    byte[] certReqBytes = certReqTrans.getPKCS10CertReq();
                    CertificationRequest certReq = new CertificationRequest(certReqBytes);
                    certReq.writeBASE64(reqFilePath);
                    try {
                        Tr.audit(tc, "Self Signed Certificate: notBefore time: " + certificate.getNotBefore().toString() + " notAfter time: " + certificate.getNotAfter().toString());
                    }
                    catch (Throwable t) {}
                } else {
                    String msg = "SelfSigned create failed.";
                    throw new Exception(msg);
                }
                if (certCreated) {
                    PersonalCertificateHelper.setWorkspaceUpdated(session, ssCertInfo.getKsInfo().getLocation());
                }
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.personalCertificates.CertificateRequestHelper", "369");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while marking ssl config changed: " + e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
        return certCreated;
    }

    public static AttributeList getCertificateInfo(KeyStoreInfo info, String alias) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificateInfo");
        }
        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(info);
        AttributeList attrList = null;
        X509Certificate cert = null;
        String certReqFile = null;
        try {
            String method2 = "containsAlias";
            Object[] parms = new Object[]{alias};
            Object[] exists = wsksr.invokeKeyStoreCommand(method2, parms);
            method2 = "isKeyEntry";
            parms = new Object[]{alias};
            Object[] isKeyEntery = wsksr.invokeKeyStoreCommand(method2, parms);
            if (((Boolean)exists[0]).booleanValue() && ((Boolean)isKeyEntery[0]).booleanValue()) {
                method2 = "getCertificate";
                parms = new Object[]{alias};
                Object[] certArray = wsksr.invokeKeyStoreCommand(method2, parms);
                cert = (X509Certificate)certArray[0];
                certReqFile = CertificateRequestHelper.isKeyCertReq(cert, alias);
                if (certReqFile == null) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.not.cert.request.CWPKI0651E", new Object[]{alias}, "Certificate alias \"" + alias + "\" is not a certificate request.");
                    throw new CommandValidationException(msg);
                }
            } else {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.not.exists.CWPKI0678E", new Object[]{alias, info.getName()}, "Certificate request alias \"" + alias + "\" does not exist in key store \"" + info.getName() + "\".");
                throw new CommandValidationException(msg);
            }
            attrList = CertificateRequestHelper.certReqAttrlist(alias, cert, certReqFile);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificateInfo");
        }
        return attrList;
    }
}

