/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.adminagent;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.RSAToken;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.filetransfer.client.FileTransferClientImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.ssl.commands.adminagent.AgentProfileServerIDExchanger;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class AdminAgentSecurityCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(AdminAgentSecurityCommands.class, "SSL", "com.ibm.ws.ssl.resources.sslCommandTask");

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        String cmdName = metadata2.getName();
        if (cmdName.equals("baseToAgentRegistration")) {
            return new BaseToAgentRegistration((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("baseToAgentRegistrationAfterStart")) {
            return new BaseToAgentRegistrationAfterStart((TaskCommandMetadata)metadata2);
        }
        if (cmdName.equals("agentToJobManagerRegistration")) {
            return new AgentToJobManagerRegistration((TaskCommandMetadata)metadata2);
        }
        return super.createCommand(metadata2);
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        String cmdName = cmdData.getName();
        if (cmdName.equals("baseToAgentRegistration")) {
            return new BaseToAgentRegistration(cmdData);
        }
        if (cmdName.equals("baseToAgentRegistrationAfterStart")) {
            return new BaseToAgentRegistrationAfterStart(cmdData);
        }
        if (cmdName.equals("agentToJobManagerRegistration")) {
            return new AgentToJobManagerRegistration(cmdData);
        }
        return super.loadCommand(cmdData);
    }

    public class AgentToJobManagerRegistration
    extends AbstractTaskCommand {
        String profileConfigPath;
        String agentProfilePath;
        String jobManagerHost;
        Integer jobManagerFTSecurePort;
        Integer jobManagerFTPort;
        String jobManagerUserid;
        String jobManagerPassword;
        Boolean register;
        public ConfigService cs;
        public Session session;
        private Subject subject;

        public AgentToJobManagerRegistration(CommandData inCommandData) throws CommandNotFoundException, CommandLoadException {
            super(inCommandData);
            this.profileConfigPath = null;
            this.agentProfilePath = null;
            this.jobManagerHost = null;
            this.jobManagerFTSecurePort = null;
            this.jobManagerFTPort = null;
            this.jobManagerUserid = null;
            this.jobManagerPassword = null;
            this.register = Boolean.TRUE;
            this.cs = null;
            this.session = null;
            this.subject = null;
        }

        public AgentToJobManagerRegistration(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
            super(inMetadata);
            this.profileConfigPath = null;
            this.agentProfilePath = null;
            this.jobManagerHost = null;
            this.jobManagerFTSecurePort = null;
            this.jobManagerFTPort = null;
            this.jobManagerUserid = null;
            this.jobManagerPassword = null;
            this.register = Boolean.TRUE;
            this.cs = null;
            this.session = null;
            this.subject = null;
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            try {
                this.cs = ConfigServiceFactory.getConfigService();
                if (this.cs == null) {
                    Properties props = new Properties();
                    props.put("location", "local");
                    this.cs = ConfigServiceFactory.createConfigService(true, props);
                }
                this.session = this.getConfigSession();
                this.agentProfilePath = (String)this.getParameter("agentProfilePath");
                this.jobManagerHost = (String)this.getParameter("jobManagerHost");
                this.jobManagerFTSecurePort = (Integer)this.getParameter("jobManagerFTSecurePort");
                this.jobManagerFTPort = (Integer)this.getParameter("jobManagerFTPort");
                this.jobManagerUserid = (String)this.getParameter("jobManagerUserid");
                this.jobManagerPassword = (String)this.getParameter("jobManagerPassword");
                this.register = (Boolean)this.getParameter("register");
                StringBuffer sb = new StringBuffer("agentProfilePath=");
                sb.append(this.agentProfilePath);
                sb.append(", jobManagerHost=");
                sb.append(this.jobManagerHost);
                sb.append(", jobManagerFTSecurePort=");
                sb.append(this.jobManagerFTSecurePort);
                sb.append(", jobManagerFTPort=");
                sb.append(this.jobManagerFTPort);
                sb.append(", jobManagerUserid=");
                sb.append(this.jobManagerUserid);
                sb.append(", jobManagerPassword=");
                sb.append(SSLConfigManager.mask(this.jobManagerPassword));
                sb.append(", register=");
                sb.append(this.register);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, sb.toString());
                }
                if (this.agentProfilePath == null) {
                    String msg = "The profile root is not specified for the task parameter agentProfilePath.";
                    throw new CommandValidationException(msg);
                }
                File profile = new File(this.agentProfilePath);
                if (!profile.exists()) {
                    String msg = "Profile " + this.agentProfilePath + " does not exist.";
                    throw new CommandValidationException(msg);
                }
                this.profileConfigPath = this.agentProfilePath + File.separatorChar + "config";
                File agentConfigRootFile = new File(this.profileConfigPath);
                if (!agentConfigRootFile.exists()) {
                    String msg = "The profile \"" + this.profileConfigPath + "\" does not exist.";
                    throw new CommandValidationException(msg);
                }
            }
            catch (ConfigServiceException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigService exception: ", new Object[]{e});
                }
                String msg = e.getMessage();
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in validate: ", new Object[]{e});
                }
                String msg = e.getMessage();
                throw new CommandValidationException(msg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void afterStepsExecuted() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "afterStepsExecuted");
            }
            super.afterStepsExecuted();
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "afterStepsExecuted");
                return;
            }
            try {
                block45: {
                    FileTransferClientImpl client;
                    block42: {
                        block44: {
                            block43: {
                                boolean isGlobalSecurityEnabled = WSSecurityHelper.isGlobalSecurityEnabled();
                                client = new FileTransferClientImpl();
                                FileTransferConfigImpl ftConfig = new FileTransferConfigImpl();
                                Properties props = new Properties();
                                ftConfig.setSecurityEnabled(isGlobalSecurityEnabled);
                                props.setProperty("host", String.valueOf(this.jobManagerHost));
                                props.setProperty("secure_port", String.valueOf(this.jobManagerFTSecurePort));
                                props.setProperty("port", String.valueOf(this.jobManagerFTPort));
                                ftConfig.setProperties(props);
                                client.setFileTransferConfig(ftConfig);
                                String agentProcessType = AdminServiceFactory.getAdminService().getProcessType();
                                if (isGlobalSecurityEnabled && this.jobManagerUserid != null && this.jobManagerUserid.length() > 0 && this.jobManagerPassword != null && this.jobManagerPassword.length() > 0) {
                                    this.subject = SubjectHelper.createBasicAuthSubject(null, this.jobManagerUserid, this.jobManagerPassword);
                                    if (this.subject == null) {
                                        throw new RuntimeException("Subject is null while security is enabled.");
                                    }
                                    AdminDataHolder.setData("wsSubject", this.subject);
                                }
                                if (!this.register.booleanValue()) break block42;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Registering agent with job manager...");
                                }
                                boolean jobManagerSecurityEnabled = false;
                                try {
                                    jobManagerSecurityEnabled = client.isAdminSecurityEnabled();
                                }
                                catch (Exception e) {
                                    Tr.error(tc, "ssl.command.agent.registration.transfer.fail.CWPKI0734E");
                                    String exMsg = e.getMessage();
                                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.agent.registration.transfer.fail.CWPKI0734E", new Object[]{exMsg}, "Could not connect to the job manager. This may be due to a security enablement mismatch with the job manager or due to a incorrect username, password, port number, or hostname. Exception: " + exMsg);
                                    throw new CommandException(msg);
                                }
                                boolean agentSecurityEnabled = isGlobalSecurityEnabled;
                                if (jobManagerSecurityEnabled && !agentSecurityEnabled) {
                                    if (agentProcessType.equals("DeploymentManager")) {
                                        Tr.error(tc, "ssl.command.agent.registration.dmgroff.jmon.CWPKI0733E");
                                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.agent.registration.dmgroff.jmon.CWPKI0733E", null, "The job manager has administrative security enabled but the deployment manager does not.");
                                        throw new CommandException(msg);
                                    }
                                    Tr.error(tc, "ssl.command.agent.registration.agentoff.jmon.CWPKI0723E");
                                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.agent.registration.agentoff.jmon.CWPKI0723E", null, "The job manager has administrative security enabled but the admin agent does not.");
                                    throw new CommandException(msg);
                                }
                                if (!jobManagerSecurityEnabled && agentSecurityEnabled) {
                                    if (agentProcessType.equals("DeploymentManager")) {
                                        Tr.error(tc, "ssl.command.agent.registration.dmgron.jmoff.CWPKI0732E");
                                        String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.agent.registration.dmgron.jmoff.CWPKI0732E", null, "The deployment manager has administrative security enabled but the job manager does not.");
                                        throw new CommandException(msg);
                                    }
                                    Tr.error(tc, "ssl.command.agent.registration.agenton.jmoff.CWPKI0722E");
                                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.agent.registration.agenton.jmoff.CWPKI0722E", null, "The admin agent has administrative security enabled but the job manager does not.");
                                    throw new CommandException(msg);
                                }
                                X509Certificate agent_ssl_root = (X509Certificate)CertificateManager.getInstance().getRootSigner("SSL");
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Retrieved the SSL root signer from the admin agent.");
                                }
                                if (agent_ssl_root == null) break block43;
                                X509Certificate jm_ssl_root = client.exchangeSigners(agent_ssl_root, "SSL");
                                if (jm_ssl_root != null) {
                                    CertificateManager.getInstance().addRootSigner(jm_ssl_root, "SSL");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Added the SSL root signer from the job manager into the admin agent.");
                                    }
                                    break block44;
                                } else {
                                    if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                                        if (!tc.isDebugEnabled()) throw new CommandException("The job manager SSL root signer is null, cannot update agent trust store.");
                                        Tr.debug(tc, "The job manager SSL root signer is null, cannot update agent trust store.");
                                        throw new CommandException("The job manager SSL root signer is null, cannot update agent trust store.");
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "On z/OS, SSL signers already exchanged or need to be exchanged manually.");
                                    }
                                }
                                break block44;
                            }
                            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                                if (!tc.isDebugEnabled()) throw new CommandException("The agent SSL root signer is null, cannot perform signer exchange.");
                                Tr.debug(tc, "The agent SSL root signer is null, cannot perform signer exchange.");
                                throw new CommandException("The agent SSL root signer is null, cannot perform signer exchange.");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "On z/OS, SSL signers already exchanged or need to be exchanged manually.");
                            }
                        }
                        X509Certificate agent_rsa_root = (X509Certificate)CertificateManager.getInstance().getRootSigner("RSA");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Retrieved the RSA root signer from the admin agent.");
                        }
                        if (agent_rsa_root == null) {
                            if (!tc.isDebugEnabled()) throw new CommandException("The agent RSA root signer is null, cannot perform signer exchange.");
                            Tr.debug(tc, "The agent RSA root signer is null, cannot perform signer exchange.");
                            throw new CommandException("The agent RSA root signer is null, cannot perform signer exchange.");
                        }
                        X509Certificate jm_rsa_root = client.exchangeSigners(agent_rsa_root, "RSA");
                        if (jm_rsa_root != null) {
                            CertificateManager.getInstance().addRootSigner(jm_rsa_root, "RSA");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Added the RSA root signer from the job manager into the admin agent.");
                            }
                            break block45;
                        } else {
                            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                                if (!tc.isDebugEnabled()) throw new CommandException("The job manager RSA root signer is null, cannot update agent trust store.");
                                Tr.debug(tc, "The job manager RSA root signer is null, cannot update agent trust store.");
                                throw new CommandException("The job manager RSA root signer is null, cannot update agent trust store.");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "On z/OS, RSA signers may already be exchanged or need to be exchanged manually.");
                            }
                        }
                        break block45;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Un-registering agent with job manager...");
                    }
                    X509Certificate agent_ssl_root = (X509Certificate)CertificateManager.getInstance().getRootSigner("SSL");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrieved the SSL root signer from the admin agent.");
                    }
                    if (agent_ssl_root != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing the agent SSL root signer from the job manager.");
                        }
                        client.removeSigner(agent_ssl_root, "SSL");
                    }
                    X509Certificate agent_rsa_root = (X509Certificate)CertificateManager.getInstance().getRootSigner("RSA");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrieved the RSA root signer from the admin agent.");
                    }
                    if (agent_rsa_root != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing the agent RSA root signer from the job manager.");
                        }
                        client.removeSigner(agent_rsa_root, "RSA");
                    }
                    X509Certificate jm_ssl_root = client.getRootSigner("SSL");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrieved the SSL root signer from the job manager.");
                    }
                    if (jm_ssl_root != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing the job manager SSL root signer from the admin agent.");
                        }
                        CertificateManager.getInstance().deleteRootSigner(jm_ssl_root, "SSL");
                    }
                    X509Certificate jm_rsa_root = client.getRootSigner("RSA");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Retrieved the RSA root signer from the job manager.");
                    }
                    if (jm_rsa_root != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing the job manager RSA root signer from the admin agent.");
                        }
                        CertificateManager.getInstance().deleteRootSigner(jm_rsa_root, "RSA");
                    }
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "afterStepsExecuted");
                return;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in afterStepsExecuted: ", new Object[]{e});
                }
                result.setException(new CommandException(e, e.getMessage()));
            }
        }
    }

    public class BaseToAgentRegistrationAfterStart
    extends AbstractTaskCommand {
        private String profilePath;

        public BaseToAgentRegistrationAfterStart(CommandData inCommandData) throws CommandNotFoundException, CommandLoadException {
            super(inCommandData);
            this.profilePath = null;
        }

        public BaseToAgentRegistrationAfterStart(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
            super(inMetadata);
            this.profilePath = null;
        }

        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            try {
                this.profilePath = (String)this.getParameter("profilePath");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "profilePath=" + this.profilePath);
                }
                if (this.profilePath == null) {
                    String msg = "The profile root is not specified for the task parameter profilePath.";
                    throw new CommandValidationException(msg);
                }
                File profile = new File(this.profilePath);
                if (!profile.exists()) {
                    String msg = "Profile " + this.profilePath + " does not exist.";
                    throw new CommandValidationException(msg);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in validate: ", new Object[]{e});
                }
                String msg = e.getMessage();
                throw new CommandValidationException(msg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate");
            }
        }

        protected void afterStepsExecuted() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "afterStepsExecuted");
            }
            super.afterStepsExecuted();
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            try {
                String agentPath = System.getProperty("user.install.root");
                AgentProfileServerIDExchanger idExchanger = new AgentProfileServerIDExchanger();
                idExchanger.exchangeServerIDs(this.profilePath, agentPath, null, true);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in afterStepsExecuted: ", new Object[]{e});
                }
                result.setException(new CommandException(e, e.getMessage()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BaseToAgentRegistration
    extends AbstractTaskCommand {
        private String baseProfilePath;
        private Boolean removeSigners;
        String agentProfilePath;
        KeyStoreInfo agentKeyStoreInfo;
        KeyStoreInfo agentRSATokenKeyStoreInfo;
        Security agentSecurityXML;
        ArrayList<X509Certificate> agentDefaultSignerCertificates;
        ArrayList<X509Certificate> agentRSATokenSignerCertificates;
        KeyStoreInfo profileRootKeyStoreInfo;
        String profileConfigPath;
        String profileCellName;
        String profileNodeName;
        Properties profileNodeProperties;
        String profileVersion;
        String profileSSLConfigURL;
        String agentSSLConfigURL;
        Security profileSecurityXML;
        WorkSpace profileWorkSpace;
        ArrayList<X509Certificate> defaultProfileSignerCertificates;
        ArrayList<X509Certificate> rsaTokenProfileSignerCertificates;
        public ConfigService cs;
        public Session session;
        ArrayList<String> certsExchanged;

        public BaseToAgentRegistration(CommandData inCommandData) throws CommandNotFoundException, CommandLoadException {
            super(inCommandData);
            this.baseProfilePath = null;
            this.removeSigners = Boolean.TRUE;
            this.agentProfilePath = null;
            this.agentKeyStoreInfo = null;
            this.agentRSATokenKeyStoreInfo = null;
            this.agentSecurityXML = null;
            this.agentDefaultSignerCertificates = new ArrayList();
            this.agentRSATokenSignerCertificates = new ArrayList();
            this.profileRootKeyStoreInfo = null;
            this.profileConfigPath = null;
            this.profileCellName = null;
            this.profileNodeName = null;
            this.profileNodeProperties = new Properties();
            this.profileVersion = null;
            this.profileSSLConfigURL = null;
            this.agentSSLConfigURL = null;
            this.profileSecurityXML = null;
            this.profileWorkSpace = null;
            this.defaultProfileSignerCertificates = new ArrayList();
            this.rsaTokenProfileSignerCertificates = new ArrayList();
            this.cs = null;
            this.session = null;
            this.certsExchanged = new ArrayList();
        }

        public BaseToAgentRegistration(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
            super(inMetadata);
            this.baseProfilePath = null;
            this.removeSigners = Boolean.TRUE;
            this.agentProfilePath = null;
            this.agentKeyStoreInfo = null;
            this.agentRSATokenKeyStoreInfo = null;
            this.agentSecurityXML = null;
            this.agentDefaultSignerCertificates = new ArrayList();
            this.agentRSATokenSignerCertificates = new ArrayList();
            this.profileRootKeyStoreInfo = null;
            this.profileConfigPath = null;
            this.profileCellName = null;
            this.profileNodeName = null;
            this.profileNodeProperties = new Properties();
            this.profileVersion = null;
            this.profileSSLConfigURL = null;
            this.agentSSLConfigURL = null;
            this.profileSecurityXML = null;
            this.profileWorkSpace = null;
            this.defaultProfileSignerCertificates = new ArrayList();
            this.rsaTokenProfileSignerCertificates = new ArrayList();
            this.cs = null;
            this.session = null;
            this.certsExchanged = new ArrayList();
        }

        @Override
        public void validate() throws CommandValidationException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            try {
                File agentSSLConfig;
                File baseSSLConfig;
                this.cs = ConfigServiceFactory.getConfigService();
                if (this.cs == null) {
                    Properties props = new Properties();
                    props.put("location", "local");
                    this.cs = ConfigServiceFactory.createConfigService(true, props);
                }
                this.session = this.getConfigSession();
                this.baseProfilePath = (String)this.getParameter("profilePath");
                this.removeSigners = (Boolean)this.getParameter("removeSigners");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "profilePath=" + this.baseProfilePath + " removeSigners=" + this.removeSigners);
                }
                if (this.baseProfilePath == null) {
                    String msg = "The profile root is not specified for the task parameter profilePath.";
                    throw new CommandValidationException(msg);
                }
                File profile = new File(this.baseProfilePath);
                if (!profile.exists()) {
                    String msg = "Profile " + this.baseProfilePath + " does not exist.";
                    throw new CommandValidationException(msg);
                }
                this.profileConfigPath = this.baseProfilePath + File.separatorChar + "config";
                File baseConfigRootFile = new File(this.profileConfigPath);
                if (!baseConfigRootFile.exists()) {
                    String msg = "The profile \"" + this.profileConfigPath + "\" does not exist.";
                    throw new CommandValidationException(msg);
                }
                this.getProfileCellAndNodeName();
                String baseSSLConfigPath = null;
                baseSSLConfigPath = this.baseProfilePath + File.separator + "properties" + File.separator + "ssl.client.props";
                this.profileSSLConfigURL = "file:" + baseSSLConfigPath;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Base Client Config: " + this.profileConfigPath + " ClientSSL: " + this.profileSSLConfigURL);
                }
                if (!(baseSSLConfig = new File(baseSSLConfigPath)).exists()) {
                    String msg = "The node's ssl.client.props file \"" + this.profileSSLConfigURL + "\" does not exist.";
                    throw new CommandValidationException(msg);
                }
                String agentSSLConfigPath = null;
                this.agentProfilePath = KeyStoreManager.getUserInstallRoot();
                if (this.agentProfilePath == null) {
                    this.agentProfilePath = SSLConfigManager.getInstance().getGlobalProperty("user.root");
                    if (this.agentProfilePath == null) {
                        this.agentProfilePath = SSLConfigManager.getInstance().getGlobalProperty("user.install.root");
                    }
                }
                agentSSLConfigPath = this.agentProfilePath + File.separator + "properties" + File.separator + "ssl.client.props";
                this.agentSSLConfigURL = "file:" + agentSSLConfigPath;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Admin Agent Client Config: " + agentSSLConfigPath + " ClientSSL: " + this.agentSSLConfigURL);
                }
                if (!(agentSSLConfig = new File(agentSSLConfigPath)).exists()) {
                    String msg = "The Admin Agent's ssl.client.props file \"" + this.agentSSLConfigURL + "\" does not exist.";
                    throw new CommandValidationException(msg);
                }
            }
            catch (ConfigServiceException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigService exception: ", new Object[]{e});
                }
                String msg = e.getMessage();
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.adminagent.AdminAgentSecurityCommands.validate", "277", this);
                throw new CommandValidationException(msg);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in validate: ", new Object[]{e});
                }
                String msg = e.getMessage();
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.adminagent.AdminAgentSecurityCommands.validate", "284", this);
                throw new CommandValidationException(msg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterStepsExecuted() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "afterStepsExecuted");
            }
            super.afterStepsExecuted();
            TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!result.isSuccessful()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
                return;
            }
            try {
                String msg;
                String msg2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UUID: " + AdminContext.peek());
                }
                ObjectName pattern = null;
                ObjectName security2 = null;
                boolean agentSecurityEnabled = false;
                boolean profileSecurityEnabled = false;
                AuthMechanism agentActiveAuthMechanism = null;
                AuthMechanism profileActiveAuthMechanism = null;
                String agentActiveAuthMechanismOid = null;
                String profileActiveAuthMechanismOid = null;
                if (this.cs != null && this.session != null) {
                    pattern = ConfigServiceHelper.createObjectName(null, "Security");
                    ObjectName cell = this.cs.resolve(this.session, "Cell=")[0];
                    ObjectName node = this.cs.resolve(this.session, "Cell=:Node=")[0];
                    String nodeScope = null;
                    if (cell != null) {
                        security2 = this.cs.queryConfigObjects(this.session, cell, pattern, null)[0];
                    }
                    this.agentSecurityXML = (Security)MOFUtil.convertToEObject((Session)this.session, security2);
                    agentSecurityEnabled = this.agentSecurityXML.isEnabled();
                    agentActiveAuthMechanism = this.agentSecurityXML.getActiveAuthMechanism();
                    if (agentActiveAuthMechanism != null) {
                        agentActiveAuthMechanismOid = agentActiveAuthMechanism.getOID();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Admin agent security enabled: " + agentSecurityEnabled);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Active auth mechanism: " + agentActiveAuthMechanism.getOID());
                    }
                    if (!SSLConfigManager.getInstance().isServerProcess()) {
                        nodeScope = "(cell):" + ConfigServiceHelper.getDisplayName(cell) + ":(node):" + ConfigServiceHelper.getDisplayName(node);
                    }
                    this.agentKeyStoreInfo = PersonalCertificateHelper.getKsInfo(this.session, this.cs, "NodeDefaultKeyStore", nodeScope);
                    this.agentRSATokenKeyStoreInfo = PersonalCertificateHelper.getKsInfo(this.session, this.cs, "NodeRSATokenKeyStore", nodeScope);
                    this.agentDefaultSignerCertificates = this.getCertificates(this.agentKeyStoreInfo);
                    this.agentRSATokenSignerCertificates = this.getCertificates(this.agentRSATokenKeyStoreInfo);
                    if (this.agentDefaultSignerCertificates.size() == 0) {
                        String msg3 = "AdminAgent default signer certificates could not be found.";
                        throw new CommandValidationException(msg3);
                    }
                    if (this.agentRSATokenSignerCertificates.size() == 0) {
                        String msg4 = "AdminAgent RSAToken signer certificates could not be found.";
                        throw new CommandValidationException(msg4);
                    }
                } else {
                    String msg5 = "ConfigService and/or Session is null.";
                    throw new CommandValidationException(msg5);
                }
                WorkSpace baseWorkSpace = this.getWorkSpace(this.baseProfilePath + File.separatorChar + "config");
                this.profileSecurityXML = this.getCellSecurityObject(this.baseProfilePath, baseWorkSpace);
                WorkSpaceManagerImpl wmgr = (WorkSpaceManagerImpl)WorkSpaceManagerFactory.getManager();
                wmgr.releaseWorkSpace(baseWorkSpace.getUserName());
                profileSecurityEnabled = this.profileSecurityXML.isEnabled();
                profileActiveAuthMechanism = this.profileSecurityXML.getActiveAuthMechanism();
                if (profileActiveAuthMechanism != null) {
                    profileActiveAuthMechanismOid = profileActiveAuthMechanism.getOID();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Profile security enabled: " + profileSecurityEnabled);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Profile active auth mechanism: " + profileActiveAuthMechanism.getOID());
                }
                if (profileSecurityEnabled && !agentSecurityEnabled) {
                    Tr.error(tc, "ssl.command.agent.registration.agentoff.profileon.CWPKI0725E");
                    msg2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.agent.registration.agentoff.profileon.CWPKI0725E", null, "The profile has administrative security enabled but the admin agent does not.  Make sure security is either enabled on both or disabled on both profiles.");
                    throw new CommandValidationException(msg2);
                }
                if (!profileSecurityEnabled && agentSecurityEnabled) {
                    Tr.error(tc, "ssl.command.agent.registration.agenton.profileoff.CWPKI0724E");
                    msg2 = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.agent.registration.agenton.profileoff.CWPKI0724E", null, "The admin agent has administrative security enabled but the profile does not.  Make sure security is either enabled on both or disabled on both profiles.");
                    throw new CommandValidationException(msg2);
                }
                String krb5AuthMechOid = "oid:1.2.840.113554.1.2.2";
                if (profileActiveAuthMechanismOid != null && OID.compareOIDs(profileActiveAuthMechanismOid, krb5AuthMechOid)) {
                    throw new CommandValidationException("The profile has kerberos enabled as the active authentication mechanism, however is not currently supported in an administrative agent topology.  Make sure kerberos is not set as the active authentication mechanism and retry registration.");
                }
                if (agentActiveAuthMechanismOid != null && OID.compareOIDs(agentActiveAuthMechanismOid, krb5AuthMechOid)) {
                    throw new CommandValidationException("The administrative agent has kerberos enabled as the active authentication mechanism, however is not currently supported in an administrative agent topology.  Make sure kerberos is not set as the active authentication mechanism and retry registration.");
                }
                boolean nodeKeyStoreRACFType = false;
                if (this.profileSecurityXML.getRepertoire() != null && this.profileSecurityXML.getRepertoire().size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loading the node's signer from the DefaultKeyStore");
                    }
                    EList keyStoreEntries = this.profileSecurityXML.getKeyStores();
                    ArrayList keyStoreAliases = null;
                    if (keyStoreEntries != null && keyStoreEntries.size() > 0) {
                        keyStoreAliases = new ArrayList(keyStoreEntries.size());
                        for (com.ibm.websphere.models.config.ipc.ssl.KeyStore entry : keyStoreEntries) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Current KeyStore: " + entry.getName());
                            }
                            if (entry == null) continue;
                            String location = this.expand(entry.getLocation(), this.profileConfigPath);
                            String keyStoreName = entry.getName();
                            if (keyStoreName == null || !keyStoreName.equals("NodeDefaultKeyStore") && !keyStoreName.equals("NodeRSATokenKeyStore")) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found KeyStore: " + keyStoreName);
                            }
                            File keyStoreFile = new File(location);
                            KeyStoreInfo info = this.makeKsInfo(entry, this.profileConfigPath);
                            if (info.getType().equals("JCERACFKS") || info.getType().equals("JCECCARACFKS")) {
                                Tr.debug(tc, "KeyStore is RACF type, skipping: " + keyStoreName + ", " + info.getType());
                                nodeKeyStoreRACFType = true;
                                continue;
                            }
                            WSKeyStoreRemotable wsks = new WSKeyStoreRemotable(info);
                            if (wsks == null) continue;
                            String method2 = "aliases";
                            Object[] parms = null;
                            Object[] aliasArray = wsks.invokeKeyStoreCommand(method2, parms);
                            for (int i = 0; i < aliasArray.length; ++i) {
                                method2 = "isKeyEntry";
                                String alias = (String)aliasArray[i];
                                parms = new Object[]{alias};
                                Object[] isKeyEntry = wsks.invokeKeyStoreCommand(method2, parms);
                                if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                                method2 = "getCertificateChain";
                                parms = new Object[]{alias};
                                Object[] certArray = wsks.invokeKeyStoreCommand(method2, parms);
                                Certificate[] certChain = (Certificate[])certArray[0];
                                if (keyStoreName.equals("NodeDefaultKeyStore")) {
                                    this.defaultProfileSignerCertificates.add((X509Certificate)certChain[certChain.length - 1]);
                                }
                                if (!keyStoreName.equals("NodeRSATokenKeyStore")) continue;
                                this.rsaTokenProfileSignerCertificates.add((X509Certificate)certChain[certChain.length - 1]);
                            }
                        }
                    }
                }
                if (this.defaultProfileSignerCertificates.size() == 0 && !nodeKeyStoreRACFType) {
                    msg = "A signer certificate for the base application server node's Default SSL could not be found.";
                    throw new CommandValidationException(msg);
                }
                if (this.rsaTokenProfileSignerCertificates.size() == 0 && !nodeKeyStoreRACFType) {
                    msg = "A signer certificate for the base application server node's RSA Token Framework could not be found.";
                    throw new CommandValidationException(msg);
                }
                this.storeSignersInTrustStores(this.profileSecurityXML, this.agentDefaultSignerCertificates, "agent_signer", this.profileConfigPath, "DefaultTrustStore");
                this.storeSignersInTrustStores(this.profileSecurityXML, this.agentRSATokenSignerCertificates, "agent_signer", this.profileConfigPath, "RSATokenTrustStore");
                this.storeSignersInTrustStores(this.agentSecurityXML, this.defaultProfileSignerCertificates, this.profileNodeName + "_signer", null, "DefaultTrustStore");
                this.storeSignersInTrustStores(this.agentSecurityXML, this.rsaTokenProfileSignerCertificates, this.profileNodeName + "_signer", null, "RSATokenTrustStore");
                this.storeSignersInClientTrustStore(this.agentDefaultSignerCertificates, "agent_signer", this.profileSSLConfigURL, this.baseProfilePath);
                this.storeSignersInClientTrustStore(this.agentRSATokenSignerCertificates, "agent_signer", this.profileSSLConfigURL, this.baseProfilePath);
                this.storeSignersInClientTrustStore(this.defaultProfileSignerCertificates, this.profileNodeName + "_signer", this.agentSSLConfigURL, this.agentProfilePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CERTIFICATES EXCHANGED");
                    Iterator<String> cI = this.certsExchanged.iterator();
                    while (cI.hasNext()) {
                        Tr.debug(tc, cI.next());
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "afterStepsExecuted");
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in afterStepsExecuted: ", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.adminagent.AdminAgentSecurityCommands.afterStepsExecuted", "544", this);
                result.setException(new CommandException(e, e.getMessage()));
            }
            finally {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clearing SSL context and keyStoreMap");
                }
                KeyStoreManager.getInstance().clearJavaKeyStoresFromKeyStoreMap();
                AbstractJSSEProvider.clearSSLContextCache();
            }
        }

        /*
         * Unable to fully structure code
         */
        private void storeSignersInClientTrustStore(ArrayList certs, String alias, String sslConfigURL, String profilePath) throws Exception, KeyStoreException {
            if (AdminAgentSecurityCommands.access$000().isEntryEnabled()) {
                Tr.entry(AdminAgentSecurityCommands.access$000(), "storeSignersInClientTrustStore", new Object[]{certs, alias, sslConfigURL});
            }
            if (sslConfigURL.indexOf("ssl.client.props") != -1) {
                tempSSLConfig = new SSLConfig();
                sslConfigArray = tempSSLConfig.loadPropertiesFile(sslConfigURL, true);
                trustStoreInfo = null;
                try {
                    defaultAlias = null;
                    for (i = 0; i < sslConfigArray.length; ++i) {
                        if (i == 0 && sslConfigArray[i] != null) {
                            defaultAlias = sslConfigArray[i].getProperty("com.ibm.ssl.defaultAlias");
                            if (defaultAlias != null) continue;
                            defaultAlias = "DefaultSSLSettings";
                            continue;
                        }
                        if (sslConfigArray[i] == null || !(sslAlias = sslConfigArray[i].getProperty("com.ibm.ssl.alias")).equalsIgnoreCase(defaultAlias)) continue;
                        sslConfig = sslConfigArray[i];
                        sslConfig.decodePasswords();
                        trustStoreInfo = new KeyStoreInfo();
                        trustStoreInfo.setName(sslConfig.getProperty("com.ibm.ssl.trustStoreName"));
                        trustStoreInfo.setLocation(this.expand(sslConfig.getProperty("com.ibm.ssl.trustStore"), profilePath));
                        trustStoreInfo.setPassword(sslConfig.getProperty("com.ibm.ssl.trustStorePassword"));
                        trustStoreInfo.setType(sslConfig.getProperty("com.ibm.ssl.trustStoreType"));
                        trustStoreInfo.setProvider(sslConfig.getProperty("com.ibm.ssl.trustStoreProvider"));
                        trustStoreInfo.setFileBased(new Boolean(sslConfig.getProperty("com.ibm.ssl.trustStoreFileBased")));
                        trustStoreInfo.setReadOnly(new Boolean(sslConfig.getProperty("com.ibm.ssl.trustStoreReadOnly")));
                    }
                }
                catch (Exception e) {
                    Tr.error(AdminAgentSecurityCommands.access$000(), "ssl.client.config.parse.CWPKI0019E", new Object[]{sslConfigURL, e.getMessage()});
                    if (AdminAgentSecurityCommands.access$000().isDebugEnabled()) {
                        Tr.debug(AdminAgentSecurityCommands.access$000(), "Exception parsing SSL properties from ConfigURL.", new Object[]{e});
                    }
                    throw new Exception(e.getMessage());
                }
                try {
                    if (trustStoreInfo == null) ** GOTO lbl62
                    clientTrustStore = new WSKeyStoreRemotable(trustStoreInfo);
                    this.storeSigners(certs, alias, trustStoreInfo, clientTrustStore);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            } else if (sslConfigURL.indexOf("soap.client.props") != -1) {
                trustStoreInfo = null;
                try {
                    sslConfig = new SSLConfig(sslConfigURL);
                    sslConfig.decodePasswords();
                    trustStoreInfo = new KeyStoreInfo();
                    trustStoreInfo.setLocation(this.expand(sslConfig.getProperty("com.ibm.ssl.trustStore"), profilePath));
                    trustStoreInfo.setPassword(sslConfig.getProperty("com.ibm.ssl.trustStorePassword"));
                    trustStoreInfo.setType(sslConfig.getProperty("com.ibm.ssl.trustStoreType") == null ? "JKS" : sslConfig.getProperty("com.ibm.ssl.trustStoreType"));
                }
                catch (Exception e) {
                    Tr.error(AdminAgentSecurityCommands.access$000(), "ssl.client.config.parse.CWPKI0019E", new Object[]{sslConfigURL, e.getMessage()});
                    if (AdminAgentSecurityCommands.access$000().isDebugEnabled()) {
                        Tr.debug(AdminAgentSecurityCommands.access$000(), "Exception parsing SSL properties from ConfigURL.", new Object[]{e});
                    }
                    throw new Exception(e.getMessage());
                }
                try {
                    if (trustStoreInfo != null) {
                        clientTrustStore = new WSKeyStoreRemotable(trustStoreInfo);
                        this.storeSigners(certs, alias, trustStoreInfo, clientTrustStore);
                    }
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
lbl62:
            // 5 sources

            if (AdminAgentSecurityCommands.access$000().isEntryEnabled()) {
                Tr.exit(AdminAgentSecurityCommands.access$000(), "storeSignersInClientTrustStore");
            }
        }

        /*
         * Unable to fully structure code
         */
        private void storeSigners(ArrayList<X509Certificate> certs, String alias, KeyStoreInfo trustStoreInfo, WSKeyStoreRemotable wsks) throws Exception, KeyStoreException {
            if (AdminAgentSecurityCommands.access$000().isEntryEnabled()) {
                Tr.entry(AdminAgentSecurityCommands.access$000(), "storeSigners");
            }
            if (wsks != null) {
                keyStoreModified = false;
                trustStore = wsks.getKeyStore(false, false);
                ** if (trustStore == null || trustStoreInfo.getType().equals((Object)"JCERACFKS") || trustStoreInfo.getType().equals((Object)"JCECCARACFKS")) goto lbl50
                for (j = 0; j < certs.size(); ++j) {
                    cert = certs.get(j);
                    if (cert != null) {
                        if (!trustStoreInfo.getReadOnly().booleanValue()) {
                            exists = KeyStoreManager.getInstance().checkIfSignerAlreadyExistsInTrustStore(cert, trustStore);
                            if (!exists && !trustStore.containsAlias(alias)) {
                                trustStore.setCertificateEntry(alias, cert);
                                digest = KeyStoreManager.getInstance().generateDigest("SHA", cert);
                                if (AdminAgentSecurityCommands.access$000().isDebugEnabled()) {
                                    Tr.debug(AdminAgentSecurityCommands.access$000(), "Added signer certificate with \"" + alias + "\" and serial \"" + cert.getSerialNumber() + "\" to keystore" + "\"" + wsks.getLocation() + "\"" + "with the following SHA digest: " + digest);
                                    this.certsExchanged.add("Added signer certificate with \"" + alias + "\" and serial \"" + cert.getSerialNumber() + "\" to keystore" + "\"" + wsks.getLocation() + "\"" + "with the following SHA digest: " + digest);
                                }
                                keyStoreModified = true;
                            } else if (!exists) {
                                num = 1;
                                newAlias = null;
                                while (trustStore.containsAlias(newAlias = alias + "_" + num++)) {
                                }
                                if (!trustStore.containsAlias(newAlias)) {
                                    trustStore.setCertificateEntry(newAlias, cert);
                                    digest = KeyStoreManager.getInstance().generateDigest("SHA", cert);
                                    if (AdminAgentSecurityCommands.access$000().isDebugEnabled()) {
                                        Tr.debug(AdminAgentSecurityCommands.access$000(), "Added signer certificate with \"" + newAlias + "\" and serial \"" + cert.getSerialNumber() + "\" to keystore" + "\"" + wsks.getLocation() + "\"" + "with the following SHA digest: " + digest);
                                        this.certsExchanged.add("Added signer certificate with \"" + newAlias + "\" and serial \"" + cert.getSerialNumber() + "\" to keystore" + "\"" + wsks.getLocation() + "\"" + "with the following SHA digest: " + digest);
                                    }
                                    keyStoreModified = true;
                                }
                            } else if (exists && this.removeSigners.booleanValue()) {
                                if (this.removeSignerFromTrustStore(cert, trustStore)) {
                                    keyStoreModified = true;
                                }
                                agentPath = System.getProperty("user.install.root");
                                idExchanger = new AgentProfileServerIDExchanger();
                                idExchanger.exchangeServerIDs(this.baseProfilePath, agentPath, null, false);
                            }
                        } else if (AdminAgentSecurityCommands.access$000().isDebugEnabled()) {
                            Tr.debug(AdminAgentSecurityCommands.access$000(), "Trust Store is read-only, unable to exchange signers.");
                        }
                    }
                    if (keyStoreModified) {
                        wsks.store();
                        continue;
                    }
                    if (!AdminAgentSecurityCommands.access$000().isDebugEnabled()) continue;
                    Tr.debug(AdminAgentSecurityCommands.access$000(), "All signers from remote keystore already exist in local keystore.");
lbl-1000:
                    // 2 sources

                    {
                        continue;
                    }
                }
            }
lbl50:
            // 4 sources

            if (AdminAgentSecurityCommands.access$000().isEntryEnabled()) {
                Tr.exit(AdminAgentSecurityCommands.access$000(), "storeSigners");
            }
        }

        private void storeSignersInTrustStores(Security security2, ArrayList<X509Certificate> certs, String signerAlias, String configRoot, String keyStoreSuffix) throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "storeSignersInTrustStores", new Object[]{security2, certs, signerAlias, configRoot, keyStoreSuffix});
            }
            try {
                EList authMechs;
                if (security2.getRepertoire() != null && security2.getRepertoire().size() > 0) {
                    EList sslEntries = security2.getRepertoire();
                    ArrayList sslAliases = null;
                    if (sslEntries != null && sslEntries.size() > 0) {
                        sslAliases = new ArrayList(sslEntries.size());
                        for (com.ibm.websphere.models.config.security.SSLConfig entry : sslEntries) {
                            com.ibm.websphere.models.config.ipc.ssl.KeyStore trustStoreObject;
                            String alias = entry.getAlias();
                            if (alias == null || (trustStoreObject = entry.getSetting().getTrustStore()) == null) continue;
                            String location = null;
                            location = configRoot != null ? this.expand(trustStoreObject.getLocation(), configRoot) : KeyStoreManager.getInstance().expand(trustStoreObject.getLocation());
                            String trustStoreName = trustStoreObject.getName();
                            if (trustStoreName == null || !trustStoreName.endsWith(keyStoreSuffix)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "TrustStore: " + trustStoreObject.getName());
                            }
                            File trustStoreFile = new File(location);
                            KeyStoreInfo trustStoreInfo = this.makeKsInfo(trustStoreObject, configRoot);
                            WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(trustStoreInfo);
                            this.storeSigners(certs, signerAlias, trustStoreInfo, wsksr);
                        }
                    }
                }
                if (security2.getAuthMechanisms() != null && security2.getAuthMechanisms().size() > 0 && (authMechs = security2.getAuthMechanisms()) != null && authMechs.size() > 0) {
                    for (AuthMechanism entry : authMechs) {
                        RSAToken rsaTokenMech;
                        com.ibm.websphere.models.config.ipc.ssl.KeyStore trustStoreObject;
                        if (!(entry instanceof RSAToken) || (trustStoreObject = (rsaTokenMech = (RSAToken)entry).getAdminCertificateTrustStore()) == null) continue;
                        String location = null;
                        location = configRoot != null ? this.expand(trustStoreObject.getLocation(), configRoot) : KeyStoreManager.getInstance().expand(trustStoreObject.getLocation());
                        String trustStoreName = trustStoreObject.getName();
                        if (trustStoreName == null || !trustStoreName.endsWith(keyStoreSuffix)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TrustStore: " + trustStoreObject.getName());
                        }
                        File trustStoreFile = new File(location);
                        KeyStoreInfo trustStoreInfo = this.makeKsInfo(trustStoreObject, configRoot);
                        WSKeyStoreRemotable wsksr = new WSKeyStoreRemotable(trustStoreInfo);
                        this.storeSigners(certs, signerAlias, trustStoreInfo, wsksr);
                    }
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "storeSignersInTrustStores");
            }
        }

        private boolean removeSignerFromTrustStore(X509Certificate signer, KeyStore trustStore) {
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "removeSignerFromTrustStore");
                }
                try {
                    String signerMD5Digest = KeyStoreManager.getInstance().generateDigest("MD5", signer);
                    if (signerMD5Digest == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "removeSignerFromTrustStore -> false (could not generate digest)");
                        }
                        return false;
                    }
                    Enumeration<String> aliases = trustStore.aliases();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        if (!trustStore.containsAlias(alias)) continue;
                        X509Certificate cert = (X509Certificate)trustStore.getCertificate(alias);
                        String certMD5Digest = KeyStoreManager.getInstance().generateDigest("MD5", cert);
                        if (!signerMD5Digest.equals(certMD5Digest) || this.isLastCertificate(trustStore)) continue;
                        trustStore.deleteEntry(alias);
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Deleted signer certificate with \"" + alias + "\" and serial \"" + cert.getSerialNumber() + "\"" + "with the following SHA digest: " + certMD5Digest);
                            this.certsExchanged.add("Deleted signer certificate with \"" + alias + "\" and serial \"" + cert.getSerialNumber() + "\"" + "with the following SHA digest: " + certMD5Digest);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "removeSignerFromTrustStore -> true (digest matches)");
                        }
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "Exception while removing signers from the trustStore.", new Object[]{e});
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeMatchingSignersFromTrustStore -> false (no digest matches)");
            }
            return false;
        }

        private boolean isLastCertificate(KeyStore trustStore) throws KeyStoreException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isLastCertificate");
            }
            Enumeration<String> aliases = trustStore.aliases();
            int count = 0;
            while (aliases.hasMoreElements()) {
                ++count;
                aliases.nextElement();
            }
            if (count <= 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isLastCertificate", true);
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isLastCertificate", false);
            }
            return false;
        }

        private Security getCellSecurityObject(String path, WorkSpace ws) throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCellSecurityObject", new Object[]{path, ws});
            }
            Resource resource = null;
            RepositoryContextType cellType = ws.getMetaData().getContextType("cells");
            Collection cellContexts = ws.findContext(cellType);
            Iterator cellContextsItr = cellContexts.iterator();
            RepositoryContext cellContext = (RepositoryContext)cellContextsItr.next();
            cellContext = ws.findContext(cellContext.getURI());
            URI uri = URI.createURI("security.xml");
            resource = cellContext.getResourceSet().getResource(uri, true);
            resource.load(new HashMap());
            Security security2 = (Security)resource.getContents().get(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCellSecurityObject", security2);
            }
            return security2;
        }

        public KeyStoreInfo makeKsInfo(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String configRoot) throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "makeKsInfo");
            }
            KeyStoreInfo ksInfo = new KeyStoreInfo();
            Object props = null;
            try {
                ksInfo.setName(keyStore.getName());
                ksInfo.setType(keyStore.getType());
                ksInfo.setPassword(keyStore.getPassword());
                ksInfo.setProvider(keyStore.getProvider());
                if (configRoot != null) {
                    ksInfo.setLocation(this.expand(keyStore.getLocation(), configRoot));
                } else {
                    ksInfo.setLocation(KeyStoreManager.getInstance().expand(keyStore.getLocation()));
                }
                ksInfo.setFileBased(keyStore.isFileBased());
                ksInfo.setHostList(keyStore.getHostList());
                ksInfo.setInitializeAtStartup(keyStore.isInitializeAtStartup());
                ksInfo.setStashFile(keyStore.isCreateStashFileForCMS());
                ksInfo.setReadOnly(keyStore.isReadOnly());
                ksInfo.setScopeName(MOFUtil.createObjectName((EObject)keyStore.getManagementScope()));
                ksInfo.setSlot(keyStore.getSlot());
                ksInfo.setAccelerator(keyStore.isUseForAcceleration());
                ksInfo.setDescription(keyStore.getDescription());
                String scopeString = keyStore.getManagementScope().getScopeName();
                if (scopeString != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Management scope name going into the ksinfo is " + scopeString);
                    }
                    ksInfo.setScopeNameString(scopeString);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while create KeyStoreInfo " + e.getMessage());
                }
                throw e;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "makeKsInfo");
            }
            return ksInfo;
        }

        public X509Certificate getCertificate(KeyStoreInfo info, String alias) throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCertificate");
            }
            WSKeyStoreRemotable wsks = new WSKeyStoreRemotable(info);
            X509Certificate cert = null;
            try {
                String method2 = "containsAlias";
                Object[] parms = new Object[]{alias};
                Object[] exists = wsks.invokeKeyStoreCommand(method2, parms);
                method2 = "isKeyEntry";
                parms = new Object[]{alias};
                Object[] isKeyEntry = wsks.invokeKeyStoreCommand(method2, parms);
                if (!((Boolean)exists[0]).booleanValue() || !((Boolean)isKeyEntry[0]).booleanValue()) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.cert.alias.not.exists.CWPKI0650E", new Object[]{alias, info.getName()}, "Signer certificate alias \"" + alias + "\" does not exist in key store \"" + info.getName() + "\".");
                    throw new CommandValidationException(msg);
                }
                method2 = "getCertificate";
                parms = new Object[]{alias};
                Object[] certArray = wsks.invokeKeyStoreCommand(method2, parms);
                cert = (X509Certificate)certArray[0];
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertificate");
            }
            return cert;
        }

        public ArrayList<X509Certificate> getCertificates(KeyStoreInfo info) throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCertificates");
            }
            WSKeyStoreRemotable wsks = new WSKeyStoreRemotable(info);
            ArrayList<X509Certificate> signerCerts = new ArrayList<X509Certificate>();
            try {
                String method2 = "aliases";
                Object[] parms = null;
                Object[] aliasArray = wsks.invokeKeyStoreCommand(method2, parms);
                for (int i = 0; i < aliasArray.length; ++i) {
                    String alias = (String)aliasArray[i];
                    method2 = "isKeyEntry";
                    parms = new Object[]{alias};
                    Object[] isKeyEntry = wsks.invokeKeyStoreCommand(method2, parms);
                    if (!((Boolean)isKeyEntry[0]).booleanValue()) continue;
                    method2 = "getCertificateChain";
                    parms = new Object[]{alias};
                    Object[] certArray = wsks.invokeKeyStoreCommand(method2, parms);
                    Certificate[] certChain = (Certificate[])certArray[0];
                    signerCerts.add((X509Certificate)certChain[certChain.length - 1]);
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCertificates");
            }
            return signerCerts;
        }

        public String expand(String input, String replaceString) {
            String output;
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "expand");
                }
                String tempInput = input;
                output = null;
                try {
                    String lastPart;
                    String firstPart;
                    int index = tempInput.indexOf("${CONFIG_ROOT}");
                    if (index != -1) {
                        firstPart = tempInput.substring(0, index);
                        lastPart = tempInput.substring(index + "${CONFIG_ROOT}".length());
                        if (replaceString == null) {
                            throw new Exception("replace string is null.");
                        }
                        if (replaceString != null) {
                            output = firstPart != null && !firstPart.equals("") ? firstPart + replaceString + lastPart : replaceString + lastPart;
                            tempInput = output;
                        }
                    }
                    if ((index = tempInput.indexOf("${user.root}")) != -1) {
                        firstPart = tempInput.substring(0, index);
                        lastPart = tempInput.substring(index + "${user.root}".length());
                        if (replaceString == null) {
                            throw new Exception("replace string is null.");
                        }
                        if (replaceString != null) {
                            output = firstPart != null && !firstPart.equals("") ? firstPart + replaceString + lastPart : replaceString + lastPart;
                            tempInput = output;
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.adminagent.AdminAgentSecurityCommands.expand", "1198", this);
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Expand exception: ", new Object[]{e});
                }
            }
            if (output != null) {
                output = output.replace('\\', '/');
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "expand -> " + output);
                }
                return output;
            }
            input = input.replace('\\', '/');
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "expand -> (not expanded)");
            }
            return input;
        }

        private WorkSpace getWorkSpace(String location) throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWorkSpace", location);
            }
            WorkSpace workSpace = null;
            int MAX_ATTEMPTS = 10;
            int attempts = 0;
            while (workSpace == null) {
                Properties props = new Properties();
                String wsId = "baseToAgent" + System.currentTimeMillis();
                props.setProperty("workspace.user.id", wsId);
                props.setProperty("workspace.repository.adapter", "com.ibm.ws.sm.workspace.impl.WorkSpaceSelfRepositoryAdapter");
                String metadata_dir = location + "/.repository";
                props.setProperty("workspace.root", location);
                props.setProperty("workspace.metadata.root", metadata_dir);
                try {
                    WorkSpaceManagerImpl wmgr = (WorkSpaceManagerImpl)WorkSpaceManagerFactory.getManager();
                    workSpace = wmgr.createUniqueWorkSpace(props);
                }
                catch (Exception e) {
                    Tr.debug(tc, "Caught exception creating the workspace: ", new Object[]{e});
                }
                if (workSpace == null) {
                    ++attempts;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                }
                if (attempts <= 10) continue;
                throw new Exception("Failed to create workspace ");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getWorkSpace", workSpace);
            }
            return workSpace;
        }

        private void getNodeProperties() throws AdminException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getNodeProperties");
            }
            if (this.profileCellName != null && this.profileNodeName != null) {
                ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
                Properties tmpProperties = new Properties();
                tmpProperties.setProperty("local.cell", this.profileCellName);
                tmpProperties.setProperty("was.repository.root", this.profileConfigPath);
                managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(tmpProperties);
                this.profileNodeProperties = managedObjectMetadataAccessor.getMetadataProperties(this.profileNodeName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeProperties", this.profileNodeProperties);
            }
        }

        private void getProfileCellAndNodeName() throws Exception {
            block5: {
                String[] nodeList;
                block4: {
                    String nodePath;
                    File nodePathFile;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "getProfileCellAndNodeName");
                    }
                    String cellPath = this.baseProfilePath + File.separator + "config" + File.separator + "cells";
                    File cellPathFile = new File(cellPath);
                    int cellPathFileNum = cellPathFile.list().length;
                    for (int k = 0; k <= cellPathFileNum; ++k) {
                        String file = cellPathFile.list()[k];
                        if (file.endsWith(".xml")) continue;
                        this.profileCellName = cellPathFile.list()[k];
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Profile cell name is " + this.profileCellName);
                        break;
                    }
                    if ((nodeList = (nodePathFile = new File(nodePath = cellPath + File.separator + this.profileCellName + File.separator + "nodes")).list()).length != 1) break block4;
                    this.profileNodeName = nodeList[0];
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Profile node name is " + this.profileNodeName);
                    break block5;
                }
                for (int i = 0; i < nodeList.length; ++i) {
                    String nName = nodeList[i];
                    if (nName.indexOf("Manager") == -1) continue;
                    this.profileNodeName = nName;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Profile node name is " + this.profileNodeName);
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getProfileCellAndNodeName");
            }
        }

        private boolean checkVersion(String version) throws AdminException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkVersion");
            }
            boolean match = false;
            this.getNodeProperties();
            this.profileVersion = this.profileNodeProperties.getProperty("com.ibm.websphere.baseProductVersion");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "profile version is " + this.profileVersion);
            }
            if (this.profileVersion.indexOf(version) != -1) {
                match = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkVersion " + match);
            }
            return match;
        }
    }
}

