/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfigGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifySSLConfigGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifySSLConfigGroup.class, "SSL", "com.ibm.ws.ssl.commands");
    private String sslConfigGroupName = null;
    private String direction = null;
    private String certificateAlias = null;
    private String sslConfigGroupScopeName = null;
    private String sslConfigAliasName = null;
    private String sslConfigScopeName = null;
    private ObjectName sslConfigGroupObjName = null;
    private ObjectName scopeObjName = null;
    private ObjectName sslConfigObjName = null;

    public ModifySSLConfigGroup(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifySSLConfigGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName security2 = null;
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ObjectName matches = cs.resolve(session, "Cell=")[0];
                if (matches != null) {
                    security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
                }
                this.sslConfigGroupName = (String)this.getParameter(CommandConstants.NAME);
                this.direction = (String)this.getParameter(CommandConstants.DIRECTION);
                this.certificateAlias = (String)this.getParameter(CommandConstants.CERTIFICATE_ALIAS);
                this.sslConfigGroupScopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
                this.sslConfigAliasName = (String)this.getParameter(CommandConstants.SSL_CONFIG_ALIAS_NAME);
                this.sslConfigScopeName = (String)this.getParameter(CommandConstants.SSL_CONFIG_SCOPE_NAME);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLConfigGroupName: " + this.sslConfigGroupName);
                    Tr.debug(tc, "direction: " + this.direction);
                    Tr.debug(tc, "sslConfigGroupScopeName: " + this.sslConfigGroupScopeName);
                    Tr.debug(tc, "sslConfigAliasName: " + this.sslConfigAliasName);
                    Tr.debug(tc, "sslConfigScopeName: " + this.sslConfigScopeName);
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.sslConfigGroupScopeName == null) {
                    this.sslConfigGroupScopeName = commandHelper.defaultCellScope(matches);
                }
                if (this.sslConfigScopeName == null) {
                    this.sslConfigScopeName = commandHelper.defaultCellScope(matches);
                }
                if (this.direction != null && !this.direction.equalsIgnoreCase("inbound") && !this.direction.equalsIgnoreCase("outbound")) {
                    String msg = "Invalid direction value: " + this.direction;
                    throw new CommandValidationException(msg);
                }
                AttributeList queryAttrs = new AttributeList();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.sslConfigGroupName);
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.DIRECTION, this.direction);
                this.sslConfigGroupObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.SSL_CONFIG_GROUPS, queryAttrs, this.sslConfigGroupScopeName);
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.sslConfigGroupScopeName);
                this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (this.sslConfigAliasName == null) break block14;
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.sslConfigAliasName);
                this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.sslConfigScopeName);
                AttributeList attrList = cs.getAttributes(session, this.sslConfigObjName, null, true);
                if (attrList != null) {
                    boolean inScope = commandHelper.withInScope(cs, session, attrList, this.sslConfigGroupScopeName);
                    if (!inScope) {
                        String msg = "SSLConfig is not within the SSLConfigGroup mananagementScope.";
                        throw new CommandValidationException(msg);
                    }
                    break block14;
                }
                String msg = "Attribute list for SSLConfig is null.";
                throw new CommandValidationException(msg);
            }
            catch (ConfigServiceException e) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.modifySSLConfigGroup.validate", "197", this);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration: ", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.sslConfigGroupName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.DIRECTION, this.direction);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            if (this.certificateAlias != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.CERTIFICATE_ALIAS, this.certificateAlias);
            }
            if (this.sslConfigObjName != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SSL_CONFIG, this.sslConfigObjName);
            }
            cs.setAttributes(session, this.sslConfigGroupObjName, attrList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

