/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListSSLConfigProperties
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListSSLConfigProperties.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String scopeName = null;
    private Boolean displayObjectName = null;
    private ObjectName scopeObjName = null;
    private ObjectName sslConfigObjName = null;

    public ListSSLConfigProperties(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListSSLConfigProperties(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig aliasName: ", this.aliasName);
                Tr.debug(tc, "scopeName: ", this.scopeName);
                Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.aliasName);
            this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.listSSLConfigProperties.validate", "151");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            AttributeList setting;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            String[] displayAttrs = new String[]{CommandConstants.NAME, CommandConstants.VALUE};
            AttributeList repertoire = cs.getAttributes(session, this.sslConfigObjName, null, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "repertoire: " + repertoire);
            }
            ArrayList<Serializable> propList = new ArrayList<Serializable>();
            if (repertoire != null && (setting = (AttributeList)ConfigServiceHelper.getAttributeValue(repertoire, CommandConstants.SETTING)).size() > 0) {
                List properties = (List)ConfigServiceHelper.getAttributeValue(setting, CommandConstants.PROPERTIES);
                for (AttributeList property : properties) {
                    ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(property), null);
                    if (matches.length == 1) {
                        if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                            propList.add(matches[0]);
                            continue;
                        }
                        propList.add(commandHelper.getDisplayAttrs(cs, session, matches, property, displayAttrs));
                        continue;
                    }
                    throw new InvalidParameterValueException(this.getName(), CommandConstants.PROPERTIES, property);
                }
            }
            result.setResult(propList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

