/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.SSLConfig;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteSSLConfig
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(DeleteSSLConfig.class, "SSL", "com.ibm.ws.ssl.commands");
    private String aliasName = null;
    private String scopeName = null;
    private ObjectName sslConfigObjName = null;
    private String sslConfigType = null;

    public DeleteSSLConfig(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public DeleteSSLConfig(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            AttributeList dynRef;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            boolean defaultScope = false;
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.aliasName = (String)this.getParameter(CommandConstants.ALIAS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLConfig aliasName: " + this.aliasName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                defaultScope = true;
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeName is null, got defaultCellScope: " + this.scopeName);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.ALIAS, this.aliasName);
            try {
                this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, this.scopeName);
            }
            catch (Exception e) {
                if (defaultScope) {
                    this.sslConfigObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.REPERTOIRE, queryAttrs, null);
                }
                throw e;
            }
            if (this.sslConfigObjName != null) {
                this.sslConfigType = (String)cs.getAttribute(session, this.sslConfigObjName, CommandConstants.TYPE);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslConfigType: " + this.sslConfigType);
            }
            AttributeList ref = commandHelper.getReference(cs, session, security2, CommandConstants.SSL_CONFIG_GROUPS, CommandConstants.SSL_CONFIG, this.sslConfigObjName);
            AttributeList referenceList = new AttributeList();
            if (ref.size() > 0) {
                referenceList.addAll(ref);
            }
            if ((dynRef = commandHelper.getReference(cs, session, security2, CommandConstants.DYNAMIC_SSL_CONFIG_SELECTIONS, CommandConstants.SSL_CONFIG, this.sslConfigObjName)).size() > 0) {
                referenceList.addAll(dynRef);
            }
            if (referenceList.size() > 0) {
                ArrayList<String> references = new ArrayList<String>();
                for (int i = 0; i < referenceList.size(); ++i) {
                    Attribute attrs = (Attribute)referenceList.get(i);
                    if (attrs.getValue() == null) continue;
                    String objectAndValue = attrs.getName() + ":" + attrs.getValue();
                    references.add(objectAndValue);
                }
                String msg = "This object is referenced by " + references;
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.deleteSSLConfig.validate", "155", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        Session session = this.getConfigSession();
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
        ConfigService cs = ConfigServiceFactory.getConfigService();
        try {
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            cs.deleteConfigData(session, this.sslConfigObjName);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.updateSSLConfigMap(session, this.sslConfigObjName, this.aliasName);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    void updateSSLConfigMap(Session session, ObjectName repertoire, String aliasName) throws Exception {
        boolean reinitialize = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSSLConfigMap: repertoire=" + repertoire + " aliasName=" + aliasName);
        }
        try {
            com.ibm.websphere.models.config.security.SSLConfig SecurityConfigObject2 = (com.ibm.websphere.models.config.security.SSLConfig)MOFUtil.convertToEObject((Session)session, (ObjectName)repertoire);
            SSLConfig sslConfig = SSLConfigManager.getInstance().parseSSLConfig(SecurityConfigObject2, reinitialize);
            if (sslConfig != null) {
                SSLConfigManager.getInstance().removeSSLConfigFromMap(aliasName, sslConfig);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createSSLConfig.validate", "659", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSSLConfigMap");
        }
    }
}

