/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ManagementScope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.ArrayList;
import javax.management.ObjectName;

public class ListManagementScopeOptions
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListManagementScopeOptions.class, "SSL", "com.ibm.ws.ssl.commands");

    public ListManagementScopeOptions(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListManagementScopeOptions(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ArrayList<String> managementScopeList = new ArrayList<String>();
        ObjectName cell = null;
        String cellName = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                cellName = (String)cs.getAttribute(session, cell, "name");
            }
            String cellScope = "(cell):" + cellName;
            if (!ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess")) {
                managementScopeList.add(cellScope);
            }
            ObjectName[] nodes = cs.resolve(session, "Node=");
            for (int i = 0; i < nodes.length; ++i) {
                String nodeName = (String)cs.getAttribute(session, nodes[i], "name");
                String nodeScope = cellScope + ":(node):" + nodeName;
                managementScopeList.add(nodeScope);
                ObjectName serverObj = ConfigServiceHelper.createObjectName(null, "Server");
                ObjectName[] servers = cs.queryConfigObjects(session, nodes[i], serverObj, null);
                for (int j = 0; j < servers.length; ++j) {
                    String serverName = (String)cs.getAttribute(session, servers[j], "name");
                    String serverScope = nodeScope + ":(server):" + serverName;
                    managementScopeList.add(serverScope);
                }
            }
            ObjectName[] clusters = cs.resolve(session, "ServerCluster=");
            for (int i = 0; i < clusters.length; ++i) {
                String clusterName = (String)cs.getAttribute(session, clusters[i], "name");
                String clusterScope = cellScope + ":(cluster):" + clusterName;
                managementScopeList.add(clusterScope);
            }
            ObjectName[] nodeGroups = cs.resolve(session, "NodeGroup=");
            for (int i = 0; i < nodeGroups.length; ++i) {
                String nodeGroupName = (String)cs.getAttribute(session, nodeGroups[i], "name");
                String nodeGroupScope = cellScope + ":(nodeGroup):" + nodeGroupName;
                managementScopeList.add(nodeGroupScope);
            }
            result.setResult(managementScopeList);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.ManagementScope.beforeStepsExecuted", "143", this);
            result.setException(new CommandException(e, e.getMessage()));
        }
        this.setCommandResult(result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

