/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import javax.net.ssl.SSLEngineResult;

public class SSLHandshakeIOCallback
implements TCPReadCompletedCallback,
TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(SSLHandshakeIOCallback.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private SSLConnectionLink connLink;
    private WsByteBuffer netBuffer;
    private WsByteBuffer decryptedNetBuffer;
    private WsByteBuffer encryptedAppBuffer;
    private SSLEngineResult result;
    private SSLHandshakeCompletedCallback callback;

    public SSLHandshakeIOCallback(SSLConnectionLink _connLink, WsByteBuffer _netBuffer, WsByteBuffer _decryptedNetBuffer, WsByteBuffer _encryptedAppBuffer, SSLEngineResult _result, SSLHandshakeCompletedCallback _callback) {
        this.connLink = _connLink;
        this.netBuffer = _netBuffer;
        this.decryptedNetBuffer = _decryptedNetBuffer;
        this.encryptedAppBuffer = _encryptedAppBuffer;
        this.result = _result;
        this.callback = _callback;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete(read)");
        }
        try {
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, this.result, this.callback, true);
        }
        catch (IOException ioe) {
            this.error(vc, rsc, ioe);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete(read)");
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Error occured during a read, exception:" + ioe);
        }
        this.callback.error(ioe);
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "complete(write)");
        }
        this.encryptedAppBuffer.clear();
        try {
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, this.result, this.callback, true);
        }
        catch (IOException ioe) {
            this.error(vc, wsc, ioe);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "complete(write)");
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Error occured during a write, exception:" + ioe);
        }
        this.callback.error(ioe);
    }
}

