/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLChannel;
import com.ibm.ws.ssl.channel.impl.SSLChannelData;
import com.ibm.ws.ssl.channel.impl.SSLConnectionContextImpl;
import com.ibm.ws.ssl.channel.impl.SSLDiscriminatorState;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLReadServiceContext;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.ws.ssl.channel.impl.SSLWriteServiceContext;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.OutboundConnectionLink;
import com.ibm.wsspi.channel.base.OutboundProtocolLink;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ReadOnlyBufferException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLConnectionLink
extends OutboundProtocolLink
implements InboundConnectionLink,
TCPConnectionContext {
    protected static final TraceComponent tc = Tr.register(SSLConnectionLink.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.impl.SSLConnectionLink";
    public static final String LINKCONFIG = "SSLLINKCONFIG";
    private SSLChannel sslChannel = null;
    private SSLChannelData sslConfig = null;
    private SSLLinkConfig linkConfig = null;
    private SSLEngine sslEngine = null;
    private SSLReadServiceContext readInterface = null;
    private SSLWriteServiceContext writeInterface = null;
    private TCPConnectionContext deviceServiceContext = null;
    protected TCPReadRequestContext deviceReadInterface = null;
    private TCPWriteRequestContext deviceWriteInterface = null;
    private SSLConnectionContext sslConnectionContext = null;
    private SSLDiscriminatorState discState = null;
    private boolean connected = false;
    private boolean closed = false;
    private int vcHashCode = 0;
    private ThreadPool threadPool = null;
    private SSLContext sslContext = null;
    private TCPConnectRequestContext targetAddress = null;
    private boolean queuedHandshake = false;

    public SSLConnectionLink(SSLChannel inputChannel) {
        this.sslChannel = inputChannel;
        this.sslConfig = inputChannel.getConfig();
    }

    public void init(VirtualConnection inVC) {
        this.vcHashCode = inVC.hashCode();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init, vc=" + this.getVCHash());
        }
        this.sslConnectionContext = new SSLConnectionContextImpl(this, !this.sslConfig.isInbound());
        super.init(inVC);
        this.readInterface = new SSLReadServiceContext(this);
        this.writeInterface = new SSLWriteServiceContext(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close, vc=" + this.getVCHash());
        }
        this.closed = true;
        this.cleanup();
        if (this.getDeviceLink() != null) {
            this.getDeviceLink().close(inVC, e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy, vc=" + this.getVCHash());
        }
        this.connected = false;
        this.cleanup();
        this.getVirtualConnection().getStateMap().remove(LINKCONFIG);
        super.destroy(e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void cleanup() {
        if (null != this.writeInterface) {
            this.writeInterface.close();
        }
        if (null != this.readInterface) {
            this.readInterface.close();
        }
        if (null != this.getSSLEngine()) {
            SSLUtils.shutDownSSLEngine(this, this.sslConfig.isInbound(), this.connected);
        }
        this.connected = false;
        this.queuedHandshake = false;
    }

    public Object getChannelAccessor() {
        return this;
    }

    public void setDeviceLink(ConnectionLink next) {
        super.setDeviceLink(next);
        this.deviceServiceContext = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        this.deviceReadInterface = this.deviceServiceContext.getReadInterface();
        this.deviceWriteInterface = this.deviceServiceContext.getWriteInterface();
    }

    public void ready(VirtualConnection inVC) {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "ready, vc=" + this.getVCHash());
            }
            if (!this.closed) {
                try {
                    if (this.sslConfig.isInbound()) {
                        Map stateMap = inVC.getStateMap();
                        this.discState = (SSLDiscriminatorState)stateMap.remove("SSLDiscState");
                        if (this.discState != null) {
                            this.sslEngine = this.discState.getEngine();
                            this.sslContext = this.discState.getSSLContext();
                            this.setLinkConfig((SSLLinkConfig)stateMap.get(LINKCONFIG));
                        } else if (this.sslContext == null || this.getSSLEngine() == null) {
                            this.sslContext = this.getChannel().getSSLContextForInboundLink(this, inVC);
                            this.sslEngine = SSLUtils.getSSLEngine(this.sslContext, this.sslConfig.getFlowType(), this.getLinkConfig());
                        }
                    } else if (this.sslContext == null || this.getSSLEngine() == null) {
                        this.sslContext = this.getChannel().getSSLContextForOutboundLink(this, inVC, this.targetAddress);
                        this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.getLinkConfig(), this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort());
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "SSL engine hc=" + this.getSSLEngine().hashCode() + " associated with vc=" + this.getVCHash());
                    }
                    this.connected = true;
                    if (this.sslConfig.isInbound()) {
                        this.readyInbound(inVC);
                        break block16;
                    }
                    this.readyOutbound(inVC, true);
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caught exception during ready, " + e, e);
                    }
                    FFDCFilter.processException((Throwable)e, CLASS_NAME, "238", (Object)this);
                    this.close(inVC, e);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ready called after close so do nothing");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ready");
        }
    }

    protected ThreadPool getThreadPool() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool");
        }
        if (this.threadPool == null) {
            String threadPoolName = (String)this.getVirtualConnection().getStateMap().get("TCP_THREADPOOL_NAME");
            ChannelFramework channelFramework = this.sslConfig.getChannelFramework();
            if (threadPoolName != null) {
                this.threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(threadPoolName);
                if (this.threadPool == null) {
                    String message = "Could not obtain named thread pool from the Channel Framework, thread pool name: " + threadPoolName;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, message);
                    }
                    throw new ChannelException(message);
                }
            } else {
                this.threadPool = channelFramework.getDefaultThreadPool();
                if (this.threadPool == null) {
                    String message = "Could not obtain default thread pool from the Channel Framework";
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, message);
                    }
                    throw new ChannelException(message);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool");
        }
        return this.threadPool;
    }

    private void readyInbound(VirtualConnection inVC) {
        WsByteBuffer netBuffer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readyInbound, vc=" + this.getVCHash());
        }
        if ((netBuffer = this.getDeviceReadInterface().getBuffer()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received null buffer so closing connection.");
            }
            this.close(inVC, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "readyInbound, vc=" + this.getVCHash());
            }
            return;
        }
        netBuffer.flip();
        WsByteBuffer decryptedNetBuffer = null;
        WsByteBuffer encryptedAppBuffer = null;
        SSLEngineResult result = null;
        boolean errorOccurred = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Initial read bytes: " + netBuffer.limit());
        }
        if (this.discState == null) {
            decryptedNetBuffer = SSLUtils.allocateByteBuffer(this.getAppBufferSize(), this.sslConfig.getDecryptBuffersDirect());
        } else {
            result = this.discState.getEngineResult();
            decryptedNetBuffer = this.discState.getDecryptedNetBuffer();
            netBuffer.position(this.discState.getNetBufferPosition());
            netBuffer.limit(this.discState.getNetBufferLimit());
        }
        encryptedAppBuffer = SSLUtils.allocateByteBuffer(this.getPacketBufferSize(), true);
        try {
            MyHandshakeCompletedCallback callback;
            if (this.discState == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Before unwrap\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer));
                }
                int savedLimit = SSLUtils.adjustBufferForJSSE(netBuffer, this.getPacketBufferSize());
                result = this.getSSLEngine().unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                if (0 < result.bytesProduced()) {
                    decryptedNetBuffer.flip();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "After unwrap\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " HSstatus=" + (Object)((Object)result.getHandshakeStatus()) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced());
                }
                if (-1 != savedLimit) {
                    netBuffer.limit(savedLimit);
                }
                if (netBuffer.remaining() == 0) {
                    netBuffer.clear();
                }
            }
            if ((result = SSLUtils.handleHandshake(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, result, callback = new MyHandshakeCompletedCallback(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, FlowType.INBOUND), false)) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "readyInbound");
                }
                return;
            }
            this.readyInboundPostHandshake(netBuffer, decryptedNetBuffer, encryptedAppBuffer, result.getHandshakeStatus());
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught ioexception, " + ioe);
            }
            errorOccurred = true;
            this.getChannel().getHandshakeErrorTracker().noteHandshakeError(ioe);
            this.close(inVC, ioe);
        }
        catch (ReadOnlyBufferException robe) {
            FFDCFilter.processException((Throwable)robe, CLASS_NAME, "359", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught read-only exception, " + robe);
            }
            errorOccurred = true;
            this.close(inVC, robe);
        }
        if (errorOccurred) {
            if (decryptedNetBuffer != null) {
                decryptedNetBuffer.release();
                decryptedNetBuffer = null;
            }
            netBuffer.release();
            netBuffer = null;
            this.getDeviceReadInterface().setBuffers(null);
            if (encryptedAppBuffer != null) {
                encryptedAppBuffer.release();
                encryptedAppBuffer = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readyInbound");
        }
    }

    protected void readyInboundPostHandshake(WsByteBuffer netBuffer, WsByteBuffer decryptedNetBuffer, WsByteBuffer encryptedAppBuffer, SSLEngineResult.HandshakeStatus hsStatus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readyInboundPostHandshake, vc=" + this.getVCHash());
        }
        encryptedAppBuffer.release();
        if (hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.getChannel().onHandshakeFinish(this.getSSLEngine());
            if (netBuffer.remaining() == 0 || netBuffer.position() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Releasing netBuffer: " + netBuffer.hashCode());
                }
                netBuffer.release();
                this.getDeviceReadInterface().setBuffers(null);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "App data exists in netBuffer after handshake: " + netBuffer.remaining());
            }
            this.readInterface.setBuffer(decryptedNetBuffer);
            MyReadCompletedCallback readCallback = new MyReadCompletedCallback(decryptedNetBuffer);
            if (null != this.readInterface.read(1L, readCallback, false, 0)) {
                this.determineNextChannel();
            }
        } else {
            netBuffer.release();
            this.getDeviceReadInterface().setBuffers(null);
            decryptedNetBuffer.release();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unhandled result from SSL engine: " + (Object)((Object)hsStatus));
            }
            SSLException ssle = new SSLException("Unhandled result from SSL engine: " + (Object)((Object)hsStatus));
            FFDCFilter.processException((Throwable)ssle, CLASS_NAME, "401", (Object)this);
            this.close(this.getVirtualConnection(), ssle);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readyInboundPostHandshake");
        }
    }

    private void readyOutbound(VirtualConnection inVC, boolean async) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readyOutbound, vc=" + this.getVCHash());
        }
        boolean encryptDirect = this.sslConfig.getEncryptBuffersDirect();
        boolean decryptDirect = this.sslConfig.getDecryptBuffersDirect();
        WsByteBuffer netBuffer = SSLUtils.allocateByteBuffer(this.getPacketBufferSize(), encryptDirect);
        WsByteBuffer decryptedNetBuffer = SSLUtils.allocateByteBuffer(this.getAppBufferSize(), decryptDirect);
        WsByteBuffer encryptedAppBuffer = SSLUtils.allocateByteBuffer(this.getPacketBufferSize(), true);
        SSLEngineResult sslResult = null;
        MyHandshakeCompletedCallback callback = null;
        IOException exception = null;
        if (async) {
            callback = new MyHandshakeCompletedCallback(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, FlowType.OUTBOUND);
        }
        try {
            sslResult = SSLUtils.handleHandshake(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, sslResult, callback, false);
            if (sslResult != null) {
                this.readyOutboundPostHandshake(netBuffer, decryptedNetBuffer, encryptedAppBuffer, sslResult.getHandshakeStatus(), async);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        catch (ReadOnlyBufferException e) {
            exception = new IOException("Caught exception: " + e);
        }
        if (exception != null) {
            FFDCFilter.processException((Throwable)exception, CLASS_NAME, "540", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during handshake after connect, " + exception);
            }
            if (netBuffer != null) {
                netBuffer.release();
                netBuffer = null;
                this.getDeviceReadInterface().setBuffers(null);
            }
            if (decryptedNetBuffer != null) {
                decryptedNetBuffer.release();
                decryptedNetBuffer = null;
            }
            if (encryptedAppBuffer != null) {
                encryptedAppBuffer.release();
                encryptedAppBuffer = null;
            }
            if (async) {
                this.close(inVC, exception);
            } else {
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readyOutbound");
        }
    }

    protected void readyOutboundPostHandshake(WsByteBuffer netBuffer, WsByteBuffer decryptedNetBuffer, WsByteBuffer encryptedAppBuffer, SSLEngineResult.HandshakeStatus hsStatus, boolean async) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readyOutboundPostHandshake, vc=" + this.getVCHash());
        }
        IOException exception = null;
        if (hsStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected results of handshake after connect, " + (Object)((Object)hsStatus));
            }
            exception = new IOException("Unexpected results of handshake after connect, " + (Object)((Object)hsStatus));
        }
        this.getChannel().onHandshakeFinish(this.getSSLEngine());
        this.getDeviceReadInterface().setBuffers(null);
        netBuffer.release();
        decryptedNetBuffer.release();
        encryptedAppBuffer.release();
        if (async) {
            if (exception != null) {
                this.close(this.getVirtualConnection(), exception);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling ready method.");
                }
                super.ready(this.getVirtualConnection());
            }
        } else if (exception != null) {
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readyOutboundPostHandshake");
        }
    }

    private void handleRedundantConnect() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRedundantConnect, vc=" + this.getVCHash());
        }
        this.cleanup();
        this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.getLinkConfig(), this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "New SSL engine=" + this.getSSLEngine().hashCode() + " for vc=" + this.getVCHash());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRedundantConnect");
        }
    }

    public void connectAsynch(Object address) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectAsynch, vc=" + this.getVCHash());
        }
        if (this.connected) {
            this.handleRedundantConnect();
        }
        this.targetAddress = (TCPConnectRequestContext)address;
        ((OutboundConnectionLink)this.getDeviceLink()).connectAsynch(address);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectAsynch");
        }
    }

    public void connect(Object address) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connect, vc=" + this.getVCHash());
        }
        if (this.connected) {
            this.handleRedundantConnect();
        }
        this.targetAddress = (TCPConnectRequestContext)address;
        ((OutboundConnectionLink)this.getDeviceLink()).connect(address);
        this.connected = true;
        if (this.sslContext == null || this.getSSLEngine() == null) {
            this.sslContext = this.getChannel().getSSLContextForOutboundLink(this, this.getVirtualConnection(), address);
            this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.getLinkConfig(), this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL engine hc=" + this.getSSLEngine().hashCode() + " associated with vc=" + this.getVCHash());
        }
        this.readyOutbound(this.getVirtualConnection(), false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connect");
        }
    }

    protected void determineNextChannel() {
        ConnectionReadyCallback linkOnApplicationSide;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "determineNextChannel, vc=" + this.getVCHash());
        }
        if ((linkOnApplicationSide = this.getApplicationCallback()) != null) {
            linkOnApplicationSide.ready(this.getVirtualConnection());
        } else {
            int discriminationResult = 1;
            try {
                discriminationResult = this.getChannel().getDiscriminationProcess().discriminate(this.getVirtualConnection(), (Object)this.readInterface.getBuffers(), (ConnectionLink)this);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught doing discriminate, " + e);
                }
                FFDCFilter.processException((Throwable)e, CLASS_NAME, "346", (Object)this);
                throw new RuntimeException("Exception caught doing discriminate, " + e);
            }
            switch (discriminationResult) {
                case 1: {
                    this.getApplicationCallback().ready(this.getVirtualConnection());
                    break;
                }
                case 0: {
                    WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.getDeviceReadInterface().getBuffers());
                    this.close(this.getVirtualConnection(), new Exception("Failure response from discrimination process."));
                    break;
                }
                case 2: {
                    this.readInterface.setBuffer(this.readInterface.getBuffer());
                    MoreDataNeededCallback callback = new MoreDataNeededCallback();
                    if (null == this.readInterface.read(1L, callback, false, 0)) break;
                    this.determineNextChannel();
                    break;
                }
                default: {
                    WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.getDeviceReadInterface().getBuffers());
                    this.close(this.getVirtualConnection(), new Exception("Unknown response from discrimination process, " + discriminationResult));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "determineNextChannel");
        }
    }

    public void postConnectProcessing(VirtualConnection inVC) {
    }

    public SSLChannel getChannel() {
        return this.sslChannel;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public int getAppBufferSize() {
        return this.getSSLEngine().getSession().getApplicationBufferSize();
    }

    public int getPacketBufferSize() {
        return this.getSSLEngine().getSession().getPacketBufferSize();
    }

    public TCPReadRequestContext getDeviceReadInterface() {
        return this.deviceReadInterface;
    }

    public TCPWriteRequestContext getDeviceWriteInterface() {
        return this.deviceWriteInterface;
    }

    public TCPReadRequestContext getReadInterface() {
        return this.readInterface;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writeInterface;
    }

    public InetAddress getRemoteAddress() {
        return this.deviceServiceContext.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.deviceServiceContext.getRemotePort();
    }

    public InetAddress getLocalAddress() {
        return this.deviceServiceContext.getLocalAddress();
    }

    public int getLocalPort() {
        return this.deviceServiceContext.getLocalPort();
    }

    public SSLConnectionContext getSSLContext() {
        return this.sslConnectionContext;
    }

    protected void setLinkConfig(SSLLinkConfig config) {
        this.linkConfig = config;
    }

    public SSLLinkConfig getLinkConfig() {
        return this.linkConfig;
    }

    protected int getVCHash() {
        return this.vcHashCode;
    }

    public void setQueuedHandshake(boolean flag) {
        this.queuedHandshake = flag;
    }

    public boolean isQueuedHandshake() {
        return this.queuedHandshake;
    }

    public class MoreDataNeededCallback
    implements TCPReadCompletedCallback {
        public void complete(VirtualConnection inVC, TCPReadRequestContext rsc) {
            SSLConnectionLink.this.determineNextChannel();
        }

        public void error(VirtualConnection inVC, TCPReadRequestContext rsc, IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception reading more data to determine next channel, " + ioe);
            }
            FFDCFilter.processException((Throwable)ioe, SSLConnectionLink.CLASS_NAME, "2360", this);
            SSLConnectionLink.this.close(inVC, ioe);
        }
    }

    public class MyReadCompletedCallback
    implements TCPReadCompletedCallback {
        private WsByteBuffer decryptedNetBuffer;

        public MyReadCompletedCallback(WsByteBuffer _decryptedNetBuffer) {
            this.decryptedNetBuffer = _decryptedNetBuffer;
        }

        public void complete(VirtualConnection inVC, TCPReadRequestContext rsc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "complete (read), vc=" + SSLConnectionLink.this.getVCHash());
            }
            SSLConnectionLink.this.determineNextChannel();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete (read), vc=" + SSLConnectionLink.this.getVCHash());
            }
        }

        public void error(VirtualConnection inVC, TCPReadRequestContext rsc, IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "error (read), vc=" + SSLConnectionLink.this.getVCHash());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught IOException during read, " + ioe);
            }
            if (this.decryptedNetBuffer != null) {
                this.decryptedNetBuffer.release();
            }
            this.decryptedNetBuffer = null;
            SSLConnectionLink.this.close(inVC, ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "error (read), vc=" + SSLConnectionLink.this.getVCHash());
            }
        }
    }

    class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private SSLConnectionLink connLink;
        private WsByteBuffer netBuffer;
        private WsByteBuffer decryptedNetBuffer;
        private WsByteBuffer encryptedAppBuffer;
        private FlowType flowType;

        public MyHandshakeCompletedCallback(SSLConnectionLink _connLink, WsByteBuffer _netBuffer, WsByteBuffer _decryptedNetBuffer, WsByteBuffer _encryptedAppBuffer, FlowType _flowType) {
            this.connLink = _connLink;
            this.netBuffer = _netBuffer;
            this.decryptedNetBuffer = _decryptedNetBuffer;
            this.encryptedAppBuffer = _encryptedAppBuffer;
            this.flowType = _flowType;
        }

        public void complete(SSLEngineResult sslResult) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "complete (handshake), vc=" + SSLConnectionLink.this.getVCHash());
            }
            SSLEngineResult.HandshakeStatus sslStatus = sslResult.getHandshakeStatus();
            if (this.flowType == FlowType.INBOUND) {
                this.connLink.readyInboundPostHandshake(this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, sslStatus);
            } else {
                try {
                    this.connLink.readyOutboundPostHandshake(this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, sslStatus, true);
                }
                catch (IOException e) {
                    SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), e);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "complete (handshake), vc=" + SSLConnectionLink.this.getVCHash());
            }
        }

        public void error(IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "error (handshake), vc=" + SSLConnectionLink.this.getVCHash());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception during unwrap, " + ioe);
            }
            if (this.decryptedNetBuffer != null) {
                this.decryptedNetBuffer.release();
                this.decryptedNetBuffer = null;
            }
            if (this.netBuffer != null) {
                this.netBuffer.release();
                this.netBuffer = null;
                SSLConnectionLink.this.getDeviceReadInterface().setBuffers(null);
            }
            if (this.encryptedAppBuffer != null) {
                this.encryptedAppBuffer.release();
                this.encryptedAppBuffer = null;
            }
            if (this.flowType == FlowType.INBOUND) {
                SSLConnectionLink.this.close(this.connLink.getVirtualConnection(), ioe);
            } else if (ioe == null) {
                SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), null);
            } else {
                SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), ioe);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "error (handshake), vc=" + SSLConnectionLink.this.getVCHash());
            }
        }
    }
}

