/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.metadata.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryValidatorDef;
import com.ibm.ws.sm.workspace.metadata.impl.MetaDataParserHandler;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class MetaDataParser
extends DefaultHandler {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(MetaDataParser.class);
    private MetaDataParserHandler handler = null;

    public static void main(String[] argv) {
        MetaDataParser parser2 = new MetaDataParser();
        parser2.parse("c:/websphere/appserver/config/.repository");
        RepositoryMetaData metaData = parser2.getMetaData();
        MetaDataParser.display(metaData);
        System.exit(0);
    }

    RepositoryMetaData getMetaData() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getMetaData();
    }

    void parse(String dirName) {
        this.handler = new MetaDataParserHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            File dir = new File(dirName);
            if (dir.isDirectory()) {
                File[] files = dir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Parsing " + files[i]);
                    }
                    SAXParser saxParser = factory.newSAXParser();
                    this.parse(saxParser, files[i]);
                }
            } else {
                SAXParser saxParser = factory.newSAXParser();
                this.parse(saxParser, dir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parse(SAXParser saxParser, File file) throws Exception {
        saxParser.parse(file, (DefaultHandler)this.handler);
    }

    static void display(RepositoryMetaData metaData) {
        if (metaData == null) {
            return;
        }
        System.out.println("Meta Data:");
        System.out.println("\tName:" + metaData.getName());
        RepositoryContextType type = metaData.getRootContextType();
        System.out.println("\tRootContextType:" + type.getName());
        System.out.println("\tContext Type:");
        Iterator itr = metaData.getContextTypeAccess();
        while (itr.hasNext()) {
            MetaDataParser.display((RepositoryContextType)itr.next());
        }
        System.out.println();
        System.out.println("\tDocument Type:");
        itr = metaData.getDocumentTypeAccess();
        while (itr.hasNext()) {
            MetaDataParser.display((RepositoryDocumentType)itr.next());
        }
        System.out.println();
        System.out.println("\tValidator Type:");
        itr = metaData.getValidatorDefAccess();
        while (itr.hasNext()) {
            MetaDataParser.display((RepositoryValidatorDef)itr.next());
        }
    }

    static void display(RepositoryContextType type) {
        int i;
        System.out.println("\t\tContext:" + type.getName());
        System.out.println("\t\t\tHandle Class name:" + type.getHandlerClassName());
        System.out.println("\t\t\tChild Context Type:");
        List list = type.getChildContextTypes();
        for (i = 0; i < list.size(); ++i) {
            System.out.println("\t\t\t\t" + ((RepositoryContextType)list.get(i)).getName());
        }
        System.out.println("\t\t\tDocument Type:");
        list = type.getChildDocumentTypes();
        for (i = 0; i < list.size(); ++i) {
            System.out.println("\t\t\t\t" + ((RepositoryDocumentType)list.get(i)).getDisplayName());
        }
        if (type.getRootDocumentType() != null) {
            System.out.println("\t\t\tRoot Doc Type:" + type.getRootDocumentType().getDisplayName());
        }
    }

    static void display(RepositoryDocumentType type) {
        System.out.println("\t\tDocument:" + type.getDisplayName());
        System.out.println("\t\t\tFile Pattern:" + type.getFilePattern());
        System.out.println("\t\t\tFile Type:" + type.getFileType());
        System.out.println("\t\t\tRoot RefObject Types:");
        for (int i = 0; i < type.getRootRefObjectTypes().length; ++i) {
            System.out.println("\t\t\t\t" + type.getRootRefObjectTypes()[i]);
        }
        System.out.println("\t\t\tValidator Type:");
        List list = type.getValidatorDefs();
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("\t\t\t\t" + ((RepositoryValidatorDef)list.get(i)).getDisplayName());
        }
    }

    static void display(RepositoryValidatorDef type) {
        System.out.println("\t\tValidator:" + type.getDisplayName());
        System.out.println("\t\t\tClass Name:" + type.getClassName());
        System.out.println("\t\t\tDescription:" + type.getDescription());
        System.out.println("\t\t\tType:" + type.getValidatorType());
    }
}

