/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceContextState;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.ZosValidationException;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapter;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapterManager;
import com.ibm.ws.sm.workspace.impl.RepositoryContextPluggable;
import com.ibm.ws.sm.workspace.impl.WorkSpaceCatalogManager;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceEventImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceFileImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkSpacePersistentObjectImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.migration.MOFContextImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class RepositoryContextImpl
extends MOFContextImpl
implements RepositoryContextPluggable,
WorkSpaceConstant,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(RepositoryContextImpl.class);
    private ResourceBundle resBundle = ResourceBundle.getBundle("com.ibm.ws.sm.workspace.impl.workspaceNLS");
    private WorkSpacePersistentObjectImpl data;
    private String relativeURI;
    private String fullPath;
    private String fullURI;
    private int childTypesToLoad = 0;
    private String invalidCharSet = "=[]~<>*?";
    private boolean needTrace = true;
    protected RepositoryContextType type;
    protected RepositoryContext parent = null;
    protected WorkSpaceImpl workSpace = null;
    protected RepositoryContextAdapter adapter = null;
    private boolean fullFileList = false;
    protected HashMap files = new HashMap();
    protected HashMap childTypeMap = new HashMap();
    protected List children = new ArrayList();

    public RepositoryContextImpl(WorkSpace workSpace, RepositoryContextType type, String name, RepositoryContext parent) {
        super(workSpace);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RepositoryContextImpl", new Object[]{workSpace, type, name, parent});
        }
        this.workSpace = (WorkSpaceImpl)workSpace;
        this.type = type;
        this.setParent(parent);
        this.data = new WorkSpacePersistentObjectImpl(name);
        this.setState(WorkSpaceContextState.UPDATED_UNLOADED);
        this.initChildTypesToLoad();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RepositoryContextImpl");
        }
    }

    private void loadContext() throws WorkSpaceException {
        RepositoryContextType childType2 = null;
        if (this.getState().equals(WorkSpaceContextState.UPDATED_UNLOADED)) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "> loadContext, all types, Context: (" + this.getState() + ") " + this.getURI());
            }
            for (RepositoryContextType childType2 : this.getType().getChildContextTypes()) {
                this.loadContext(childType2, false);
            }
            if (childType2 == null && this.childTypesToLoad == 0) {
                this.setState(WorkSpaceContextState.UPDATED_LOADED);
            }
            this.save(false, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "< loadContext, all types, Context: (" + this.getState() + ") " + this.getURI());
            }
        }
    }

    private void loadContext(RepositoryContextType type, boolean saveCtx) throws WorkSpaceException {
        ChildrenMap typeMap = this.getChildTypeMap(type.getName());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "> loadContext,type: " + type.getName() + " (" + typeMap.full + "), Context: (" + this.getState() + ") " + this.getURI() + " [" + this.childTypesToLoad + "]");
        }
        if (this.getState().equals(WorkSpaceContextState.UPDATED_UNLOADED) && !typeMap.full) {
            Map childContextMap = this.getAdapter().getChildContextsInRepository(type);
            for (String name : childContextMap.keySet()) {
                String uri = (String)childContextMap.get(name);
                RepositoryContextImpl childContext = this.loadLocal(type, name, uri, false);
            }
            this.setChildTypeToLoaded(typeMap);
            if (saveCtx) {
                this.save(false, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "< loadContext,type: " + type.getName() + " (" + typeMap.full + "), Context: (" + this.getState() + ") " + this.getURI() + " [" + this.childTypesToLoad + "]");
        }
    }

    private void disableSave() {
        this.workSpace.disableSave();
    }

    private void enableSave() {
        this.workSpace.enableSave();
    }

    private boolean isEnableSave() {
        return this.workSpace.isEnableSave();
    }

    public Map checkSynchState() throws WorkSpaceException {
        WorkSpaceRepositoryAdapter wsra = this.getRepositoryAdapter();
        if (wsra instanceof WorkSpaceMasterRepositoryAdapter && ((WorkSpaceMasterRepositoryAdapter)wsra).isSelfCorrection()) {
            Collection srvCtxs = this.findContext(this.workSpace.getMetaData().getContextType("servers"));
            Collection collection = this.findContext(this.workSpace.getMetaData().getContextType("deployments"));
        }
        return this.checkSynchState(false);
    }

    public Map checkSynchStateForRefresh() throws WorkSpaceException {
        WorkSpaceRepositoryAdapter wsra = this.getRepositoryAdapter();
        if (wsra instanceof WorkSpaceMasterRepositoryAdapter && ((WorkSpaceMasterRepositoryAdapter)wsra).isSelfCorrection()) {
            Collection srvCtxs = this.findContext(this.workSpace.getMetaData().getContextType("servers"));
            Collection collection = this.findContext(this.workSpace.getMetaData().getContextType("deployments"));
        }
        return this.checkSynchStateForRefresh(false);
    }

    Map checkSynchState(boolean all) throws WorkSpaceException {
        this.workSpace.checkValid();
        HashMap<String, Integer> stateMap = new HashMap<String, Integer>();
        for (WorkSpaceFileImpl file : this.getAllFiles()) {
            Integer conflictState = this.checkSynchState(file);
            if (conflictState == ConflictState.UN_MODIFIED) continue;
            stateMap.put(file.getURI(), conflictState);
        }
        Object[] childrenCtx = this.children.toArray();
        for (int i = 0; i < childrenCtx.length; ++i) {
            Map map = ((RepositoryContextImpl)childrenCtx[i]).checkSynchState(all);
            if (map.size() <= 0) continue;
            stateMap.putAll(map);
        }
        return stateMap;
    }

    Map checkSynchStateForRefresh(boolean all) throws WorkSpaceException {
        this.workSpace.checkValid();
        HashMap<String, Integer> stateMap = new HashMap<String, Integer>();
        for (WorkSpaceFileImpl file : this.getAllFiles()) {
            Integer conflictState = this.checkSynchStateForRefresh(file);
            if (conflictState == ConflictState.UN_MODIFIED) continue;
            stateMap.put(file.getURI(), conflictState);
        }
        Object[] childrenCtx = this.children.toArray();
        for (int i = 0; i < childrenCtx.length; ++i) {
            Map map = ((RepositoryContextImpl)childrenCtx[i]).checkSynchStateForRefresh(all);
            if (map.size() <= 0) continue;
            stateMap.putAll(map);
        }
        return stateMap;
    }

    private Integer checkSynchState(WorkSpaceFile file) throws WorkSpaceException {
        return this.getRepositoryAdapter().checkSynchState(file);
    }

    private Integer checkSynchStateForRefresh(WorkSpaceFile file) throws WorkSpaceException {
        WorkSpaceRepositoryAdapter wsra = this.getRepositoryAdapter();
        if (wsra instanceof WorkSpaceMasterRepositoryAdapter) {
            return ((WorkSpaceMasterRepositoryAdapter)wsra).checkSynchStateForRefresh(file);
        }
        return wsra.checkSynchState(file);
    }

    void clearAll() {
        for (RepositoryContextImpl child : this.children) {
            child.clearAll();
        }
        this.setState(WorkSpaceContextState.NONE);
        this.clearLocalFile(null);
    }

    private void clearLocalFile(List files) {
        if (files == null) {
            this.getAllFiles().clear();
        } else {
            this.getAllFiles().removeAll(files);
        }
        this.fullFileList = false;
    }

    void finalizeAll() throws WorkSpaceException {
        ArrayList<RepositoryContextImpl> deletedChildren = new ArrayList<RepositoryContextImpl>();
        for (RepositoryContextImpl child : this.children) {
            if (child.getState().equals(WorkSpaceContextState.NONE)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CHILD: " + child.getURI() + " is NONE!!");
                }
                deletedChildren.add(child);
                this.getChildTypeMap((String)child.getType().getName()).map.remove(child.getName());
            }
            child.finalizeAll();
        }
        this.children.removeAll(deletedChildren);
    }

    private void validateContextName(String name) throws WorkSpaceException {
        boolean isInvalid = false;
        for (int i = 0; i < this.invalidCharSet.length(); ++i) {
            char currentChar = this.invalidCharSet.charAt(i);
            boolean bl = isInvalid = name.indexOf(currentChar) != -1;
            if (!isInvalid) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found invalid char '" + currentChar + "' in context name: " + name);
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0024E Found unsupported character \"{0}\" in context name: {1}", new Object[]{new Character(currentChar), name});
        }
    }

    public RepositoryContext create(RepositoryContextType type, String name) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (type: " + type.getName() + ", name: " + name + ")");
        }
        String uri = this.getAdapter().getChildContextURI(type, name);
        RepositoryContext context = this.create(type, name, uri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create (type: " + type.getName() + ", name: " + name + ") return: " + context);
        }
        return context;
    }

    public RepositoryContext create(RepositoryContextType type, String name, String relativeUri) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (type: " + type.getName() + ", name: " + name + ", relativeUri: " + relativeUri + ")");
        }
        this.workSpace.checkValid();
        this.validateContextName(name);
        RepositoryContextImpl context = this.createLocal(type, name, relativeUri);
        context.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create (type: " + type.getName() + ", name: " + name + ", relativeUri: " + relativeUri + ") return: " + context);
        }
        return context;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RepositoryContextImpl createLocal(RepositoryContextType type, String name, String relativeUri) throws WorkSpaceException {
        ChildrenMap typeMap = this.getChildTypeMap(type.getName());
        RepositoryContextImpl context = (RepositoryContextImpl)typeMap.map.get(name);
        if (context != null) {
            if (context.isDeleted()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createLocal, Context: (" + context.getState() + ") " + context.getURI() + " @" + Integer.toHexString(context.hashCode()) + " reusing deleted context.");
                }
                context.setState(WorkSpaceContextState.ADDED);
                context.initChildTypesToLoad();
                return context;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createLocal, Context: (" + context.getState() + ") " + context.getURI() + " already created.");
            }
            throw WorkSpaceLogger.createException(tc, "WKSP0003E Context {0} already exists", new Object[]{name});
        }
        String childURI = this.getURI().length() > 0 ? this.getURI() + '/' + relativeUri : relativeUri;
        if (!this.getRepositoryAdapter().exist(this.workSpace, childURI)) {
            context = new RepositoryContextImpl(this.workSpace, type, name, this);
            typeMap.map.put(name, context);
            this.children.add(context);
            context.setRelativeURI(relativeUri);
            context.setState(WorkSpaceContextState.ADDED);
            this.save(false, false);
            if (!tc.isDebugEnabled()) return context;
            Tr.debug(tc, "createLocal, Context: (" + context.getState() + ") " + context.getURI() + " @" + Integer.toHexString(context.hashCode()));
            return context;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createLocal, Context: " + childURI + " already exist in master repository.");
        }
        throw WorkSpaceLogger.createException(tc, "WKSP0003E Context {0} already exists", new Object[]{name});
    }

    private RepositoryContextImpl loadLocal(RepositoryContextType type, String name, String relativeUri, boolean saveCtx) throws WorkSpaceException {
        ChildrenMap typeMap = this.getChildTypeMap(type.getName());
        RepositoryContextImpl context = (RepositoryContextImpl)typeMap.map.get(name);
        if (context != null) {
            if (!context.isDeleted() && tc.isDebugEnabled()) {
                Tr.debug(tc, " loadLocal,Context: (" + context.getState() + ") " + context.getURI() + " @" + Integer.toHexString(context.hashCode()) + " already loaded.");
            }
        } else {
            String childURI = this.getURI().length() > 0 ? this.getURI() + '/' + relativeUri : relativeUri;
            if (this.getRepositoryAdapter().exist(this.workSpace, childURI)) {
                context = new RepositoryContextImpl(this.workSpace, type, name, this);
                typeMap.map.put(name, context);
                this.children.add(context);
                context.setRelativeURI(relativeUri);
                context.setOldState(context.getState());
                if (saveCtx) {
                    this.save(false, false);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " loadLocal,Context: (" + context.getState() + ") " + context.getURI() + " @" + Integer.toHexString(context.hashCode()));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, " loadLocal,Context: (" + WorkSpaceContextState.NONE + ") " + childURI + " doesn't exist in master repository.");
            }
        }
        return context;
    }

    void setRelativeURI(String relativeURI) {
        this.relativeURI = relativeURI;
        this.fullPath = null;
        this.fullURI = null;
        this.getWorkSpaceResourceSet().refreshPath();
    }

    public synchronized void delete(String name) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (" + name + ")");
        }
        this.workSpace.checkValid();
        this.deleteOnly(name);
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete (" + name + ")");
        }
    }

    private synchronized void deleteOnly(String name) throws WorkSpaceException {
        String fileName = name.replace(FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(fileName)) {
            this.extractOnly(fileName, false);
            this.getWorkSpaceResourceSet().release(name);
            this.notifyChangedOnly(2, fileName);
        }
    }

    private WorkSpaceResourceSet getWorkSpaceResourceSet() {
        return (WorkSpaceResourceSet)((Object)this.getResourceSet());
    }

    public synchronized void delete(boolean deep) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (deep: " + deep + ")");
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.deleteOnly(deep);
        this.enableSave();
        this.save(deep, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete (deep: " + deep + ")");
        }
    }

    void deleteOnly(boolean deep) throws WorkSpaceException {
        this.loadContext();
        if (deep) {
            for (RepositoryContextImpl child : this.children) {
                child.deleteOnly(deep);
            }
        }
        this.checkFullList();
        for (WorkSpaceFileImpl file : this.getAllFiles()) {
            this.deleteOnly(file.getName());
        }
        this.setState(WorkSpaceContextState.DELETED);
        this.delete();
    }

    private void checkFullList() throws WorkSpaceException {
        if (this.fullFileList) {
            return;
        }
        this.fullFileList = true;
        this.loadContext();
        String[] files = this.getRepositoryAdapter().getCatalog(this.workSpace, this.getURI(), 1, -1);
        for (int i = 0; i < files.length; ++i) {
            this.addLocalFile(files[i]);
        }
    }

    private void addLocalFile(String uri) throws WorkSpaceException {
        boolean isLocal = true;
        for (RepositoryContextImpl context : this.children) {
            if (!uri.startsWith(context.getRelativeURI())) continue;
            isLocal = false;
            break;
        }
        if (isLocal && this.getFileForRebuild(uri) == null) {
            this.setFileState(uri, WorkSpaceFileState.CLEAN);
        }
    }

    public synchronized void extract(String name, boolean overwrite) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (name: " + name + ", overwrite: " + new Boolean(overwrite) + ")");
        }
        this.workSpace.checkValid();
        this.extractOnly(name, overwrite);
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (name: " + name + ", overwrite: " + new Boolean(overwrite) + ")");
        }
    }

    private synchronized void extractOnly(String name, boolean overwrite) throws WorkSpaceException {
        WorkSpaceFileImpl file;
        String fileName = name.replace(FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(fileName) && (!this.isExtracted(fileName) || overwrite) && (file = this.getFileForRebuild(fileName)).getState() != WorkSpaceFileState.ADDED) {
            this.extract(file);
            this.notifyChangedOnly(3, file.getName());
        }
    }

    public synchronized void extract(boolean overwrite) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extract (overwrite: " + new Boolean(overwrite) + ")");
        }
        this.workSpace.checkValid();
        this.checkFullList();
        for (WorkSpaceFileImpl file : this.getAllFiles()) {
            this.extractOnly(file.getName(), overwrite);
        }
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extract (overwrite: " + new Boolean(overwrite) + ")");
        }
    }

    private void extract(WorkSpaceFile file) throws WorkSpaceException {
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (aa != null && aa.isFineGrainedAdminSecurity() && !aa.checkAccess(file.getURI(), "monitor")) {
            throw WorkSpaceLogger.createAccessDeniedException(tc, "WKSP0025E Access checking failed when perform {0} operation on file, {1}", new Object[]{"EXTRACTING", file}, null);
        }
        this.getRepositoryAdapter().extract(file);
    }

    private String getCallStack() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        String callStack = "";
        for (int i = 0; i < ste.length; ++i) {
            callStack = callStack + "    " + ste[i] + "\n";
        }
        return callStack;
    }

    private void setTrace(boolean needTrace) {
        this.needTrace = needTrace;
    }

    public Collection findContext(RepositoryContextType type) throws WorkSpaceException {
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.entry(tc, "findContext (type: " + type.getName() + "), from " + this.getURI());
        }
        ArrayList result = new ArrayList();
        RepositoryContextImpl context2 = null;
        String typeName = type.getName();
        RepositoryContextType curType = this.getType();
        Set matchedChildTypes = curType.findReachableChildrenTo(typeName);
        for (RepositoryContextType childCtxType : matchedChildTypes) {
            List children;
            if (childCtxType.getName().equals(typeName)) {
                children = this.getChildren(childCtxType);
                if (children.size() <= 0) continue;
                result.addAll(children);
                continue;
            }
            children = this.getChildren(childCtxType);
            for (RepositoryContextImpl context2 : children) {
                context2.setTrace(false);
                Collection list = context2.findContext(type);
                context2.setTrace(true);
                if (list.size() <= 0) continue;
                result.addAll(list);
            }
        }
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.exit(tc, "findContext (type: " + type.getName() + "), from " + this.getURI() + ", return: " + result);
        }
        return result;
    }

    public Collection findContext(String type, String name) throws WorkSpaceException {
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.entry(tc, "findContext (type: " + type + ", name: " + name + "), from " + this.getURI());
        }
        ArrayList<RepositoryContextImpl> result = new ArrayList<RepositoryContextImpl>();
        RepositoryContextImpl context2 = null;
        RepositoryContextType curType = this.getType();
        Set matchedChildTypes = curType.findReachableChildrenTo(type);
        name = name.replace(FILE_SEPERATOR_CHAR, '/');
        for (RepositoryContextType childCtxType : matchedChildTypes) {
            if (childCtxType.getName().equals(type)) {
                context2 = (RepositoryContextImpl)this.getChild(childCtxType, name);
                if (context2 == null) continue;
                result.add(context2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "     Found context: " + context2);
                continue;
            }
            List children = this.getChildren(childCtxType);
            for (RepositoryContextImpl context2 : children) {
                context2.setTrace(false);
                result.addAll(context2.findContext(type, name));
                context2.setTrace(true);
            }
        }
        if (tc.isEntryEnabled() && this.needTrace) {
            Tr.exit(tc, "findContext (type: " + type + ", name: " + name + "), from " + this.getURI() + ", return: " + result);
        }
        return result;
    }

    public RepositoryContext findContext(String uri) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findContext (uri: " + uri + ")");
        }
        uri = uri.replace(FILE_SEPERATOR_CHAR, '/');
        RepositoryContext ctx = this.getAdapter().findContext(uri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findContext (uri: " + uri + "), return: " + ctx);
        }
        return ctx;
    }

    public RepositoryContextAdapter getAdapter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdapter");
        }
        if (this.adapter == null) {
            this.adapter = RepositoryContextAdapterManager.getManager().getAdapter(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdapter", this.adapter);
        }
        return this.adapter;
    }

    public List getAllList(boolean deep) {
        ArrayList<WorkSpaceFile> result;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAllList", new Boolean(deep));
            }
            result = new ArrayList<WorkSpaceFile>();
            try {
                this.checkFullList();
                for (WorkSpaceFile file : this.getAllFiles()) {
                    if (!this.isAvailable(file)) continue;
                    result.add(file);
                }
                if (deep) {
                    for (RepositoryContextImpl child : this.children) {
                        List list = child.getAllList(deep);
                        if (list.size() <= 0) continue;
                        result.addAll(list);
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception when getting all the files:" + this.getURI(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllList", result);
        }
        return result;
    }

    public RepositoryContext getChild(RepositoryContextType type, String name) throws WorkSpaceException {
        RepositoryContextImpl context;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChild (type: " + type.getName() + ", name: " + name + ")");
        }
        if ((context = (RepositoryContextImpl)this.getChildForRebuild(type, name)) != null && context.isDeleted()) {
            context = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChild (type: " + type.getName() + ", name: " + name + ") return: " + context);
        }
        return context;
    }

    public RepositoryContext getChildForRebuild(RepositoryContextType type, String name) throws WorkSpaceException {
        Map childContextMap;
        String relativeUri;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildForRebuild (type: " + type.getName() + ", name: " + name + ")");
        }
        ChildrenMap typeMap = this.getChildTypeMap(type.getName());
        RepositoryContextImpl context = (RepositoryContextImpl)typeMap.map.get(name);
        if (context == null && (relativeUri = (String)(childContextMap = this.getAdapter().getChildContextsInRepository(type)).get(name)) != null) {
            context = this.loadLocal(type, name, relativeUri, true);
            if (childContextMap.size() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getChildForRebuild, for type: " + type.getName() + ", context: " + this.getURI() + " only has one child: " + relativeUri);
                }
                this.setChildTypeToLoaded(typeMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildForRebuild (type: " + type.getName() + ", name: " + name + ") return: " + context);
        }
        return context;
    }

    private RepositoryContext getChildForRestore(RepositoryContextType type, String name) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildForRestore (type: " + type.getName() + ", name: " + name + ")");
        }
        ChildrenMap typeMap = this.getChildTypeMap(type.getName());
        RepositoryContextImpl context = (RepositoryContextImpl)typeMap.map.get(name);
        if (context == null) {
            Map childContextMap = this.getAdapter().getChildContextsForRestore(type);
            String relativeUri = (String)childContextMap.get(name);
            if (relativeUri != null) {
                context = this.loadLocal(type, name, relativeUri, true);
                if (childContextMap.size() == 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getChildForRestore, for type: " + type.getName() + ", context: " + this.getURI() + " only has one child: " + relativeUri);
                    }
                    if (this.getState().equals(WorkSpaceContextState.UPDATED_LOADED) || this.getState().equals(WorkSpaceContextState.UPDATED_UNLOADED)) {
                        this.setChildTypeToLoaded(typeMap);
                    }
                }
            } else {
                relativeUri = this.getAdapter().getChildContextURI(type, name);
                context = this.createLocal(type, name, relativeUri);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildForRestore (type: " + type.getName() + ", name: " + name + ") return: " + context);
        }
        return context;
    }

    private void setChildTypeToLoaded(ChildrenMap typeMap) {
        typeMap.full = true;
        --this.childTypesToLoad;
        if (this.childTypesToLoad == 0) {
            this.setState(WorkSpaceContextState.UPDATED_LOADED);
        } else if (this.childTypesToLoad < 0 && tc.isDebugEnabled()) {
            Tr.debug(tc, " setChildTypeToLoaded, childTypesToLoad is less than 0.");
        }
    }

    public List getChildren() {
        ArrayList<RepositoryContextImpl> result = new ArrayList<RepositoryContextImpl>();
        try {
            this.loadContext();
        }
        catch (WorkSpaceException wse) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getChildren", result);
            }
            return result;
        }
        for (RepositoryContextImpl context : this.children) {
            if (context.isDeleted()) continue;
            result.add(context);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, " --    Found child: (" + context.getState() + ") " + context + " @" + Integer.toHexString(context.hashCode()));
        }
        return result;
    }

    public List getChildren(RepositoryContextType type) {
        ArrayList<RepositoryContextImpl> result = new ArrayList<RepositoryContextImpl>();
        try {
            this.loadContext(type, true);
        }
        catch (WorkSpaceException wse) {
            return result;
        }
        for (RepositoryContextImpl context : this.getChildTypeMap((String)type.getName()).map.values()) {
            if (context.isDeleted()) continue;
            result.add(context);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, " ##    Found child: (" + context.getState() + ") " + context + " @" + Integer.toHexString(context.hashCode()));
        }
        return result;
    }

    private List getLoadedChildren() {
        return this.children;
    }

    boolean isDeleted() {
        return this.getState().equals(WorkSpaceContextState.DELETED) || this.getState().equals(WorkSpaceContextState.NONE);
    }

    private ChildrenMap getChildTypeMap(String type) {
        ChildrenMap map = (ChildrenMap)this.childTypeMap.get(type);
        if (map == null) {
            map = new ChildrenMap();
            this.childTypeMap.put(type, map);
        }
        return map;
    }

    public WorkSpaceRepositoryAdapter getRepositoryAdapter() throws WorkSpaceException {
        return this.workSpace.getRepositoryAdapter();
    }

    private WorkSpaceCatalogManager getCatalogManager() {
        return this.workSpace.getCatalogManager();
    }

    public boolean contentsChangedInRepository() throws WorkSpaceException {
        return this.getDeltaChangesInRepository().size() > 0;
    }

    public Map getDeltaChangesInRepository() throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeltaChangesInRepository");
        }
        Map result = this.getCatalogManager().getDeltaChangesInRepository(this);
        Map map = this.checkSynchState(true);
        for (String name : map.keySet()) {
            Integer conflictState = (Integer)map.get(name);
            if (conflictState == ConflictState.ADDED) {
                result.put(name, WorkSpaceFileState.ADDED);
                continue;
            }
            if (conflictState == ConflictState.REMOVED) {
                result.put(name, WorkSpaceFileState.DELETED);
                continue;
            }
            if (conflictState != ConflictState.MODIFIED) continue;
            result.put(name, WorkSpaceFileState.UPDATED);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeltaChangesInRepository", result);
        }
        return result;
    }

    private RepositoryContextType getContextType(String name) {
        return this.getMetaData().getContextType(name);
    }

    private WorkSpaceFileImpl getFileForRebuild(String fileName) {
        fileName = fileName.replace(FILE_SEPERATOR_CHAR, '/');
        WorkSpaceFileImpl file = (WorkSpaceFileImpl)this.files.get(fileName);
        return file;
    }

    public WorkSpaceFile getFile(String fileName) {
        if (this.isAvailable(fileName)) {
            return this.getFileForRebuild(fileName);
        }
        return null;
    }

    public Set getFiles() {
        HashSet<String> result;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFiles");
            }
            result = new HashSet<String>();
            try {
                this.checkFullList();
                for (WorkSpaceFile file : this.getAllFiles()) {
                    if (!this.isAvailable(file)) continue;
                    result.add(file.getName());
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception when getting all the files: " + this.getURI(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFiles", result);
        }
        return result;
    }

    public Set getFilesInWorkspace() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFilesInWorkspace, context: " + this.getPath());
        }
        TreeSet<String> result = new TreeSet<String>();
        for (WorkSpaceFileImpl file : this.getAllFiles()) {
            String filePath = file.getURI().replace(FILE_SEPERATOR_CHAR, '/');
            if (FileAccessorUtil.exist(this.workSpace.getFileAccessor(), filePath)) {
                result.add(file.getName());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "File: (T) " + file.getName());
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "File: (F) " + file.getName() + ", state: " + file.getState());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFilesInWorkspace, return: " + result);
        }
        return result;
    }

    Collection getAllFiles() {
        return this.files.values();
    }

    private void getFiles(boolean deep, Map[] synchList, Map conflictResolutions) throws WorkSpaceException {
        this.getFilesOnly(deep, synchList, conflictResolutions);
        this.save(deep, false);
    }

    private void getFilesOnly(boolean deep, Map[] synchList, Map conflictResolutions) throws WorkSpaceException {
        for (WorkSpaceFileImpl file : this.getAllFiles()) {
            this.collectFile((WorkSpaceFile)file, synchList, conflictResolutions);
        }
        if (deep) {
            for (RepositoryContextImpl child : this.children) {
                child.getFilesOnly(deep, synchList, conflictResolutions);
            }
        }
    }

    private void collectFile(WorkSpaceFile file, Map[] synchList, Map conflictResolutions) throws WorkSpaceException {
        if (file.getState() == WorkSpaceFileState.ADDED) {
            this.collectFile(file, synchList[0], conflictResolutions);
        } else if (file.getState() == WorkSpaceFileState.UPDATED) {
            this.collectFile(file, synchList[1], conflictResolutions);
        } else if (file.getState() == WorkSpaceFileState.DELETED) {
            this.collectFile(file, synchList[2], conflictResolutions);
        }
    }

    private void collectFile(WorkSpaceFile file, Map targetList, Map conflictResolutions) throws WorkSpaceException {
        if (conflictResolutions.containsKey(file.getURI())) {
            Integer conflictResolution = (Integer)conflictResolutions.get(file.getURI());
            if (conflictResolution == ConflictResolution.OVER_WRITE) {
                targetList.put(file, conflictResolution);
            } else if (conflictResolution == ConflictResolution.DISCARD) {
                if (file.getState() == WorkSpaceFileState.ADDED) {
                    this.setFileState(file.getName(), WorkSpaceFileState.NONE);
                } else {
                    this.setFileState(file.getName(), WorkSpaceFileState.CLEAN);
                }
            }
        } else {
            targetList.put(file, null);
        }
    }

    private RepositoryMetaData getMetaData() {
        return this.workSpace.getMetaData();
    }

    public List getModifiedList(boolean deep) {
        ArrayList<WorkSpaceFile> modifiedList = new ArrayList<WorkSpaceFile>();
        for (WorkSpaceFile file : this.getAllFiles()) {
            Integer state = file.getState();
            if (state != WorkSpaceFileState.ADDED && state != WorkSpaceFileState.UPDATED && state != WorkSpaceFileState.DELETED) continue;
            modifiedList.add(file);
        }
        if (deep) {
            for (RepositoryContextImpl child : this.children) {
                List list = child.getModifiedList(deep);
                if (list.size() <= 0) continue;
                modifiedList.addAll(list);
            }
        }
        return modifiedList;
    }

    public String getName() {
        return this.data.getName();
    }

    public RepositoryContext getParentContext() {
        return this.parent;
    }

    public RepositoryContext getParent() {
        return this.parent;
    }

    public String getPath() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPath");
        }
        if (this.fullPath == null) {
            StringBuffer path = new StringBuffer(this.workSpace.getPath());
            String uriPath = this.getURI().replace('/', FILE_SEPERATOR_CHAR);
            if (path.length() > 0 && uriPath.length() > 0) {
                path.append(FILE_SEPERATOR);
            }
            path.append(uriPath);
            this.fullPath = path.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPath", this.fullPath);
        }
        return this.fullPath;
    }

    public String getURI() {
        if (this.fullURI == null) {
            StringBuffer uri = new StringBuffer();
            if (this.getParentContext() != null) {
                uri.append(this.getParentContext().getURI());
            }
            if (uri.length() != 0) {
                uri.append('/');
            }
            uri.append(this.getRelativeURI());
            this.fullURI = uri.toString();
        }
        return this.fullURI;
    }

    String getRelativeURI() {
        return this.relativeURI;
    }

    public String getProperty(String name) {
        return this.data.getProperty(name);
    }

    public Enumeration getPropertyNames() {
        return this.data.getPropertyNames();
    }

    public Integer getState() {
        return this.data.getState();
    }

    private void setState(Integer state) {
        if (tc.isDebugEnabled() && this.data.getState() >= 0) {
            Tr.debug(tc, "  setState,Context: " + this.data.getState() + ">" + state + " " + this.getURI());
        }
        this.data.setState(state);
    }

    public Integer getOldState() {
        return this.data.getOldState();
    }

    private void setOldState(Integer state) {
        if (tc.isDebugEnabled() && this.data.getOldState() >= 0) {
            Tr.debug(tc, "  setOldState,Context: " + this.data.getOldState() + ">" + state + " " + this.getURI());
        }
        this.data.setOldState(state);
    }

    private void initChildTypesToLoad() {
        this.childTypesToLoad = this.type.getChildContextTypes().size();
    }

    public RepositoryContextType getType() {
        return this.type;
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    private boolean isSpecialXML(String file) {
        boolean result = false;
        if (file.endsWith("deployment.xml") || file.endsWith("serverindex.xml")) {
            result = true;
        }
        return result;
    }

    public boolean isAvailable(String fileName) {
        boolean exist;
        boolean specialXML = this.isSpecialXML(fileName);
        if (tc.isEntryEnabled() && specialXML) {
            Tr.entry(tc, "isAvailable(String), Context: " + this.getPath() + ", File: " + fileName);
        }
        WorkSpaceFileImpl file = this.getFileForRebuild(fileName);
        if (tc.isDebugEnabled() && specialXML) {
            Tr.debug(tc, "isAvailable(String), WorkSpaceFile: " + file);
        }
        if (exist = this.isAvailable(file)) {
            if (tc.isEntryEnabled() && specialXML) {
                Tr.exit(tc, "isAvailable(String), Context: " + this.getPath() + ", File: " + fileName + ", Available: " + exist);
            }
            return true;
        }
        if (file == null && !this.fullFileList) {
            exist = this.checkExist(fileName);
        }
        if (tc.isEntryEnabled() && specialXML) {
            Tr.exit(tc, "isAvailable(String), Context: " + this.getPath() + ", File: " + fileName + ", Available: " + exist + ", fullFileList: " + this.fullFileList);
        }
        return exist;
    }

    private boolean isAvailable(WorkSpaceFile file) {
        boolean exist;
        boolean bl = exist = file != null && file.getState() != WorkSpaceFileState.NONE && file.getState() != WorkSpaceFileState.DELETED;
        if (file != null) {
            boolean specialXML = this.isSpecialXML(file.toString());
            if (tc.isDebugEnabled() && specialXML) {
                Tr.debug(tc, "isAvailable(WorkSpaceFile),   File: " + file + ", State: " + file.getState());
            }
        }
        return exist;
    }

    private boolean checkExist(String fileName) {
        boolean exist;
        StringBuffer uri;
        block5: {
            uri = new StringBuffer(this.getURI());
            if (uri.length() > 0 && fileName.length() > 0) {
                uri.append('/');
            }
            uri.append(fileName.replace(FILE_SEPERATOR_CHAR, '/'));
            exist = false;
            try {
                exist = this.getRepositoryAdapter().exist(this.workSpace, uri.toString());
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Check exist error:" + uri, e);
            }
        }
        boolean specialXML = this.isSpecialXML(fileName);
        if (tc.isDebugEnabled() && specialXML) {
            Tr.debug(tc, "checkExist(String),     File: " + uri + ", Exist (in master config): " + exist);
        }
        if (exist) {
            this.setFileState(fileName, WorkSpaceFileState.CLEAN);
        }
        return exist;
    }

    public boolean isExtracted(String fileName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExtracted (fileName: " + fileName + ")");
        }
        boolean extracted = false;
        if (this.isAvailable(fileName)) {
            Integer state = this.getFileForRebuild(fileName).getState();
            boolean bl = extracted = state != WorkSpaceFileState.CLEAN;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isExtracted (fileName: " + fileName + ") return: " + new Boolean(extracted));
        }
        return extracted;
    }

    public void notifyChanged(int type, String name) throws WorkSpaceException {
        this.notifyChangedOnly(type, name);
        this.save(false, false);
    }

    private void notifyChangedOnly(int type, String name) throws WorkSpaceException {
        WorkSpaceFile file = null;
        int eventType = 0;
        String fileName = name.replace(FILE_SEPERATOR_CHAR, '/');
        if (type == 0) {
            if (!this.isAvailable(fileName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + fileName + " to " + this.getURI());
                }
                file = this.setFileState(fileName, WorkSpaceFileState.ADDED);
                eventType = 20;
            }
        } else if (type == 2) {
            if (this.isAvailable(fileName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing " + fileName + " from " + this.getURI());
                }
                file = this.setFileState(fileName, WorkSpaceFileState.DELETED);
                eventType = 21;
                this.delete(file);
            }
        } else if (type == 1) {
            if (this.isAvailable(fileName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating " + fileName + " from " + this.getURI());
                }
                file = this.setFileState(fileName, WorkSpaceFileState.UPDATED);
                eventType = 22;
            }
        } else if (type == 3 && this.isAvailable(fileName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracted " + fileName + " from " + this.getURI());
            }
            file = this.setFileState(fileName, WorkSpaceFileState.EXTRACTED);
            eventType = 23;
        }
        if (file != null) {
            this.workSpace.notify(new WorkSpaceEventImpl(file, eventType));
        }
    }

    private void delete(WorkSpaceFile file) throws WorkSpaceException {
        this.getRepositoryAdapter().delete(file);
    }

    private void delete() throws WorkSpaceException {
        this.getRepositoryAdapter().delete(this);
    }

    public synchronized void notifyChanged(int type, List files) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyChanged", new Object[]{new Integer(type), files});
        }
        if (files.size() > 0) {
            for (int i = 0; i < files.size(); ++i) {
                this.notifyChangedOnly(type, (String)files.get(i));
            }
        }
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyChanged");
        }
    }

    public synchronized void release(boolean deep) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release (deep: " + new Boolean(deep) + ")");
        }
        if (!deep) {
            throw new UnsupportedOperationException();
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseOnly(deep);
        this.enableSave();
        this.save(deep, false);
        this.clearMe(deep);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release (deep: " + new Boolean(deep) + ")");
        }
    }

    void releaseOnly(boolean deep) throws WorkSpaceException {
        if (deep) {
            for (RepositoryContextImpl child : this.children) {
                child.releaseOnly(deep);
            }
        }
        this.resetAdapterNotifier(false);
        try {
            for (WorkSpaceFileImpl file : this.getAllFiles()) {
                this.release(file, false);
            }
            this.workSpace.notify(new WorkSpaceEventImpl(this, 11));
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), e}, e);
        }
        finally {
            Integer curState = this.getState();
            Integer oldState = this.getOldState();
            if (curState.equals(WorkSpaceContextState.ADDED)) {
                if (oldState.equals(WorkSpaceContextState.NONE)) {
                    this.setState(WorkSpaceContextState.DELETED);
                } else {
                    this.setState(oldState);
                }
            } else if (curState.equals(WorkSpaceContextState.DELETED) && !oldState.equals(WorkSpaceContextState.NONE)) {
                this.setState(oldState);
            }
            this.clearLocalFile(null);
            this.resetAdapterNotifier(true);
        }
    }

    private synchronized void releaseInSynch(boolean deep) throws WorkSpaceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Releasing context(s) after synch ..., deep: " + deep);
        }
        if (!deep) {
            throw new UnsupportedOperationException();
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseInSynchOnly(deep);
        this.enableSave();
        this.save(deep, true);
        this.clearMe(deep);
    }

    private void releaseInSynchOnly(boolean deep) throws WorkSpaceException {
        if (deep) {
            for (RepositoryContextImpl child : this.children) {
                child.releaseInSynchOnly(deep);
            }
        }
        this.resetAdapterNotifier(false);
        try {
            for (WorkSpaceFileImpl file : this.getAllFiles()) {
                this.release(file, false);
            }
            this.workSpace.notify(new WorkSpaceEventImpl(this, 11));
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), e}, e);
        }
        finally {
            this.clearLocalFile(null);
            this.resetAdapterNotifier(true);
        }
    }

    private void clearMe(boolean deep) throws WorkSpaceException {
        if (deep) {
            for (RepositoryContextImpl child : this.children) {
                child.clearMe(deep);
            }
        }
        String uri = this.getURI();
        if (!this.getRepositoryAdapter().exist(this.workSpace, uri)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Context " + uri + " is gone from master repository. Setting context state to DELETED");
            }
            this.setState(WorkSpaceContextState.DELETED);
        } else if (this.getState().equals(WorkSpaceContextState.UPDATED_LOADED) || this.getState().equals(WorkSpaceContextState.ADDED)) {
            this.setState(WorkSpaceContextState.UPDATED_UNLOADED);
        }
        this.initChildTypesToLoad();
        for (ChildrenMap typeMap : this.childTypeMap.values()) {
            typeMap.full = false;
        }
    }

    void resetAdapterNotifier(boolean on) {
        this.getWorkSpaceResourceSet().setAdapterNotifier(on);
    }

    public synchronized void releaseUnchanged(boolean deep, boolean keep) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseUnchanged (deep: " + new Boolean(deep) + ", keep: " + new Boolean(keep) + ")");
        }
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseUnchangedOnly(deep, keep);
        this.enableSave();
        this.save(deep, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseUnchanged (deep: " + new Boolean(deep) + ", keep: " + new Boolean(keep) + ")");
        }
    }

    void releaseUnchangedOnly(boolean deep, boolean keep) throws WorkSpaceException {
        if (deep) {
            for (RepositoryContextImpl child : this.children) {
                child.releaseUnchangedOnly(deep, keep);
            }
        }
        this.resetAdapterNotifier(false);
        ArrayList<WorkSpaceFileImpl> noneList = new ArrayList<WorkSpaceFileImpl>();
        try {
            for (WorkSpaceFileImpl file : this.getAllFiles()) {
                if (file.getState() == WorkSpaceFileState.EXTRACTED) {
                    this.release(file, keep);
                }
                if (file.getState() != WorkSpaceFileState.CLEAN && file.getState() != WorkSpaceFileState.NONE && (file.getState() != WorkSpaceFileState.EXTRACTED || keep)) continue;
                noneList.add(file);
            }
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), e}, e);
        }
        finally {
            this.clearLocalFile(noneList);
            this.resetAdapterNotifier(true);
        }
    }

    private void release(WorkSpaceFileImpl file, boolean keep) throws WorkSpaceException {
        this.getWorkSpaceResourceSet().release(file.getName());
        if (!keep) {
            this.release(file);
            this.workSpace.notify(new WorkSpaceEventImpl(file, 24));
        }
    }

    private void release(WorkSpaceFile file) throws WorkSpaceException {
        this.getRepositoryAdapter().release(file);
    }

    void remove() throws WorkSpaceException {
        this.delete(true);
    }

    public String removeProperty(String name) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProperty (name: " + name + ")");
        }
        String value = this.data.removeProperty(name);
        this.save(false, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProperty (name: " + name + ") return: " + value);
        }
        return value;
    }

    void restore() throws WorkSpaceException {
        this.disableSave();
        String value = this.getRepositoryAdapter().restore(this);
        if (value != null) {
            StringTokenizer st = new StringTokenizer(value, "~");
            while (st.hasMoreTokens()) {
                int index1;
                String token = st.nextToken();
                int index = token.indexOf("=");
                if (index == -1) continue;
                String tokenName = token.substring(0, index);
                String tokenValue = "";
                if (index + 1 < token.length()) {
                    tokenValue = token.substring(index + 1);
                }
                if (tokenName.equals("data")) {
                    this.data.restore(tokenValue);
                    continue;
                }
                if (tokenName.equals("uri")) {
                    this.relativeURI = tokenValue;
                    continue;
                }
                if (tokenName.equals("file")) {
                    index = tokenValue.indexOf("[");
                    if (index == -1) continue;
                    String fileName = tokenValue.substring(0, index);
                    WorkSpaceFile file = this.setFileState(fileName, WorkSpaceFileState.CLEAN);
                    ((WorkSpaceFileImpl)file).restore(tokenValue);
                    if (file.getState() == WorkSpaceFileState.CLEAN || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "   Restore file tokenValue = " + tokenValue + ", File state: " + file.getState());
                    continue;
                }
                if (!tokenName.equals("child") || (index = tokenValue.indexOf("[")) == -1 || (index1 = tokenValue.indexOf("[", index + 1)) == -1) continue;
                String childName = tokenValue.substring(0, index);
                String childTypeName = tokenValue.substring(index + 1, index1);
                String uri = tokenValue.substring(index1 + 1);
                RepositoryContextType childType = this.getContextType(childTypeName);
                if (childType == null) {
                    throw WorkSpaceLogger.createException(tc, "WKSP0021E Error getting context type: {0}.", new Object[]{childTypeName});
                }
                RepositoryContext childContext = this.getChildForRestore(childType, childName);
                if (childContext == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unable to restore child context, type: " + childType + ", name: " + childName + ", from " + this.getURI());
                    continue;
                }
                ((RepositoryContextImpl)childContext).restore();
            }
        }
        this.enableSave();
    }

    void save(boolean deep, boolean fromSynch) throws WorkSpaceException {
        if (!this.isEnableSave()) {
            return;
        }
        Integer ctxState = this.getState();
        if (fromSynch) {
            this.setOldState(ctxState);
        }
        if (ctxState.equals(WorkSpaceContextState.ADDED) || ctxState.equals(WorkSpaceContextState.DELETED) || ctxState.equals(WorkSpaceContextState.UPDATED_LOADED) || ctxState.equals(WorkSpaceContextState.UPDATED_UNLOADED)) {
            this.getRepositoryAdapter().save(this);
            if (deep) {
                for (RepositoryContextImpl child : this.children) {
                    child.save(true, fromSynch);
                }
            }
        }
    }

    private WorkSpaceFile setFileState(String name, Integer state) {
        String fileName;
        WorkSpaceFileImpl file;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setFileState: " + name + ", " + state);
        }
        if ((file = this.getFileForRebuild(fileName = name.replace(FILE_SEPERATOR_CHAR, '/'))) == null) {
            file = new WorkSpaceFileImpl(this, fileName);
            this.files.put(fileName, file);
        }
        if (file.getState() == WorkSpaceFileState.ADDED) {
            if (state == WorkSpaceFileState.UPDATED) {
                state = file.getState();
            } else if (state == WorkSpaceFileState.DELETED) {
                state = WorkSpaceFileState.NONE;
            }
        } else if (file.getState() == WorkSpaceFileState.DELETED) {
            if (state == WorkSpaceFileState.ADDED) {
                state = WorkSpaceFileState.UPDATED;
            }
        } else if (file.getState() == WorkSpaceFileState.UPDATED && state == WorkSpaceFileState.EXTRACTED) {
            state = WorkSpaceFileState.UPDATED;
        }
        file.setState(state);
        return file;
    }

    protected void setParent(RepositoryContext parent) {
        this.parent = parent;
    }

    public void setProperty(String name, String value) throws WorkSpaceException {
        this.data.setProperty(name, value);
        this.save(false, false);
    }

    public synchronized void synch(Map conflictResolutions) throws WorkSpaceException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "synch", conflictResolutions);
        }
        this.workSpace.checkValid();
        Map[] synchList = new HashMap[3];
        for (i = 0; i < 3; ++i) {
            synchList[i] = new HashMap();
        }
        this.getFiles(true, synchList, conflictResolutions);
        this.removeUnauthorizedFiles(synchList);
        this.zosValidation(synchList);
        this.update(synchList);
        this.workSpace.notify(new WorkSpaceEventImpl(this, 12));
        for (i = 0; i < 3; ++i) {
            Iterator itr = synchList[i].keySet().iterator();
            while (itr.hasNext()) {
                this.workSpace.notify(new WorkSpaceEventImpl((WorkSpaceFile)itr.next(), 25));
            }
        }
        this.releaseInSynch(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "synch");
        }
    }

    public String getPersistData() {
        StringBuffer s = new StringBuffer();
        s.append("data");
        s.append("=");
        s.append(this.data.getPersistData());
        s.append("~");
        s.append("uri");
        s.append("~");
        s.append(this.getRelativeURI());
        for (WorkSpaceFileImpl file : this.getAllFiles()) {
            s.append("~");
            s.append("file");
            s.append("=");
            s.append(file.getPersistData());
        }
        for (RepositoryContextImpl child : this.children) {
            s.append("~");
            s.append("child");
            s.append("=");
            s.append(child.getName());
            s.append("[");
            s.append(child.getType().getName());
            s.append("[");
            s.append(child.getRelativeURI());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPersistData " + s.toString());
        }
        return s.toString();
    }

    private void update(Map[] files) throws WorkSpaceException {
        this.getRepositoryAdapter().update(files);
    }

    public String toString() {
        return this.getURI();
    }

    public void dumpContextTree(RepositoryContextImpl ctx, ContextCount cc) {
        int total = cc.getTotal();
        if (total == 0) {
            System.out.println(">>> --- [Context] vvv -----------------------------");
        }
        this.dumpContext(ctx, total);
        for (RepositoryContextImpl child : ctx.getLoadedChildren()) {
            if (child.isDeleted()) continue;
            cc.increase();
            this.dumpContextTree(child, cc);
        }
        if (total == 0) {
            System.out.println(">>> --- [Context] ^^^------------------------------");
        }
    }

    public void dumpContext(RepositoryContextImpl ctx, int count) {
        String ctxHex = "@" + Integer.toHexString(ctx.hashCode());
        System.out.println(">>> (" + count + ")" + "\n\t Ctx State: (" + ctx.getState() + ")" + ", Type: " + ctx.getType().getName() + ", Context..: " + ctxHex + " " + ctx.getName() + "\n\t Parent...: " + ctx.getParent() + ", Workspace: " + ctx.getWorkSpace() + "\n\t FullURI..: " + ctx.getURI() + "\n\t Relative.: " + ctx.getRelativeURI() + "\n\t FullPath.: " + ctx.getPath());
    }

    public void dumpContextTypeTree(RepositoryContextType type, boolean detail, String indent, ContextCount cc) {
        int total = cc.getTotal();
        if (total == 0) {
            System.out.println(">>> --- [Context Type] vvv ------------------------");
        }
        indent = indent + "   ";
        this.dumpContextType(type, detail, indent, total);
        for (RepositoryContextType childType : type.getChildContextTypes()) {
            cc.increase();
            this.dumpContextTypeTree(childType, detail, indent, cc);
        }
        if (total == 0) {
            if (!detail) {
                System.out.println("");
            }
            System.out.println(">>> --- [Context Type] ^^^ ------------------------");
        }
    }

    public void dumpContextType(RepositoryContextType type, boolean detail, String indent, int count) {
        String childDocs = "";
        if (detail) {
            for (RepositoryDocumentType rdt : type.getChildDocumentTypes()) {
                childDocs = childDocs + "\n\t\t File: " + rdt.getFilePattern() + "\t\t - " + rdt.getDisplayName();
            }
            System.out.println(">>> (" + count + ")" + "\n\t Name.....: " + type.getName() + "\n\t Child Doc: " + childDocs);
        } else if (type.getName().equals("")) {
            System.out.print("\n\t Context type: " + indent + "ROOT");
        } else {
            System.out.print("\n\t Context type: " + indent + type.getName());
        }
    }

    public OutputStream getOutputStream(String name) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (name: " + name + ")");
        }
        OutputStream os2 = null;
        String fileName = name.replace(FILE_SEPERATOR_CHAR, '/');
        this.extract(fileName, false);
        int type = this.isAvailable(fileName) ? 1 : 0;
        this.notifyChanged(type, fileName);
        WorkSpaceFileImpl file = this.getFileForRebuild(fileName);
        try {
            File dir = new File(file.getURI());
            WorkSpaceImpl ws = (WorkSpaceImpl)this.getWorkSpace();
            FileAccessorUtil.makeDir(ws.getFileAccessor(), dir.getParentFile().getPath());
            os2 = FileAccessorUtil.getOutputStream(ws.getFileAccessor(), file.getURI());
        }
        catch (FileNotFoundException e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0015E Unable to get OutputStream for {0} --{1}", new Object[]{fileName}, e);
        }
        catch (IOException e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0015E Unable to get OutputStream for {0} --{1}", new Object[]{fileName}, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream (name: " + name + ")", os2);
        }
        return os2;
    }

    public InputStream getInputStream(String name) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream (name: " + name + ")");
        }
        InputStream is = null;
        String fileName = name.replace(FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(fileName)) {
            this.extract(fileName, false);
            try {
                WorkSpaceFileImpl file = this.getFileForRebuild(fileName);
                WorkSpaceImpl ws = (WorkSpaceImpl)this.getWorkSpace();
                is = FileAccessorUtil.getInputStream(ws.getFileAccessor(), file.getURI());
            }
            catch (FileNotFoundException e) {
                throw WorkSpaceLogger.createException(tc, "WKSP0014E Unable to get InputStream for {0} --{1}", new Object[]{name}, e);
            }
            catch (IOException e) {
                throw WorkSpaceLogger.createException(tc, "WKSP0014E Unable to get InputStream for {0} --{1}", new Object[]{name}, e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream (name: " + name + ")", is);
        }
        return is;
    }

    private void zosValidation(Map[] files) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "zosValidation");
        }
        WorkSpaceFile file = null;
        ResourceSet resourceSet = null;
        RepositoryContext context = null;
        Server server = null;
        ProcessDef processDef2 = null;
        String fileUri = "server.xml";
        String resUri = null;
        String contextUri = null;
        Object iter = null;
        int index = -1;
        Iterator itr = files[1].keySet().iterator();
        while (itr.hasNext()) {
            server = null;
            processDef2 = null;
            file = (WorkSpaceFile)itr.next();
            resUri = file.getURI();
            index = resUri.indexOf("/server.xml");
            if (index <= -1) continue;
            contextUri = resUri.substring(0, index);
            try {
                context = this.workSpace.findContext(contextUri);
                resourceSet = context.getResourceSet();
                Resource resource = resourceSet.createResource(URI.createURI(fileUri));
                resource.load(new HashMap());
                EList collection = resource.getContents();
                for (Object obj : collection) {
                    if (!(obj instanceof Server)) continue;
                    server = (Server)obj;
                    break;
                }
                if (server == null) continue;
                for (ProcessDef processDef2 : server.getProcessDefinitions()) {
                    if (processDef2 == null || processDef2.getProcessType() == null || !processDef2.getProcessType().equalsIgnoreCase("Servant") && !processDef2.getProcessType().equalsIgnoreCase("Adjunct")) continue;
                    this.validateJobNames(processDef2);
                }
            }
            catch (Exception e) {
                if (e instanceof WorkSpaceException) {
                    throw (WorkSpaceException)e;
                }
                throw WorkSpaceLogger.createException(tc, "WKSP0100E An error occurred getting a resource object during z/OS validation --{0}.", new Object[]{e}, e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zosValidation");
        }
    }

    private void validateJobNames(ProcessDef processDef) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateJobNames");
        }
        String startCmdArg = null;
        Iterator iter = null;
        int index = -1;
        int i = 0;
        iter = processDef.getStartCommandArgs().iterator();
        while (iter.hasNext()) {
            startCmdArg = ((String)iter.next()).toLowerCase();
            index = startCmdArg.indexOf("jobname");
            if (index <= -1) continue;
            for (i = index + 7; i < startCmdArg.length() && Character.isWhitespace(startCmdArg.charAt(i)); ++i) {
            }
            String msg = MessageFormat.format(this.resBundle.getString("error.zos.invalid.jobname"), processDef.getProcessType());
            ZosValidationException zve = new ZosValidationException(msg);
            if (i == startCmdArg.length() || startCmdArg.charAt(i) != '=') {
                Tr.error(tc, "error.zos.invalid.jobname", new Object[]{processDef.getProcessType()});
                throw new WorkSpaceException(msg, zve);
            }
            for (i = index = i + 1; i < startCmdArg.length() && startCmdArg.charAt(i) != ','; ++i) {
            }
            String jobName = startCmdArg.substring(index, i).trim();
            if (jobName != null && !jobName.equals("") && jobName.indexOf("<insert jobname here>") <= -1 && !this.isJobNameEqualToAnyServerShortName(jobName, null)) continue;
            Tr.error(tc, "error.zos.invalid.jobname", new Object[]{processDef.getProcessType()});
            throw new WorkSpaceException(msg, zve);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateJobNames");
        }
    }

    private boolean isJobNameEqualToAnyServerShortName(String jobname, RepositoryContext repContext) {
        RepositoryContext context = repContext;
        try {
            RepositoryMetaData metaData;
            Collection rootContexts;
            Iterator contextIter;
            if (context == null && (contextIter = (rootContexts = this.workSpace.findContext((metaData = RepositoryMetaDataFactory.getRepositoryMetaData()).getContextType("cells"))).iterator()).hasNext()) {
                context = (RepositoryContext)contextIter.next();
            }
            String contextName = context.getType().getName();
            RepositoryContext nodeContext = null;
            List contextList = context.getChildren();
            for (RepositoryContext subContext : contextList) {
                if (!subContext.getType().getName().equalsIgnoreCase("nodes")) continue;
                nodeContext = subContext;
                RepositoryContextType serverContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
                Collection serverContexts = nodeContext.findContext(serverContextType);
                for (RepositoryContext serverContext : serverContexts) {
                    ResourceSet resourceSet = serverContext.getResourceSet();
                    Resource resource = null;
                    Object refId = null;
                    String fileName = "server.xml";
                    try {
                        if (!serverContext.isExtracted(fileName)) {
                            serverContext.extract(fileName, false);
                        }
                        resource = resourceSet.createResource(URI.createURI(fileName));
                        resource.load(new HashMap());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    EList collection = resource.getContents();
                    Iterator collectionIter = collection.iterator();
                    Server server = null;
                    while (collectionIter.hasNext()) {
                        Object obj = collectionIter.next();
                        if (!(obj instanceof Server)) continue;
                        server = (Server)obj;
                        break;
                    }
                    if (server.getShortName() == null || !server.getShortName().toString().equalsIgnoreCase(jobname)) continue;
                    return true;
                }
            }
        }
        catch (WorkSpaceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void removeUnauthorizedFiles(Map[] fileLists) {
        AdminAuthorizer aa = AdminAuthorizerFactory.getAdminAuthorizer();
        if (aa != null && aa.isFineGrainedAdminSecurity()) {
            for (int i = 0; i < 3; ++i) {
                Iterator itr = fileLists[i].keySet().iterator();
                while (itr.hasNext()) {
                    WorkSpaceFile file = (WorkSpaceFile)itr.next();
                    if (aa == null || aa.checkAccess(file.getURI(), "configurator")) continue;
                    itr.remove();
                }
            }
        }
    }

    private class ChildrenMap {
        boolean full = false;
        HashMap map = new HashMap();

        private ChildrenMap() {
        }
    }

    public class ContextCount {
        private int total = 0;

        int getTotal() {
            return this.total;
        }

        void increase() {
            ++this.total;
        }

        void decrease() {
            --this.total;
        }
    }
}

