/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.authz;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.authz.AccessLevel;
import com.ibm.ws.security.zOS.authz.AuthorizationDeniedException;
import com.ibm.ws.security.zOS.authz.InactiveClassException;
import com.ibm.ws.security.zOS.authz.InvalidCredentialException;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationManager;
import com.ibm.ws.security.zOS.authz.SAFAuthorizationOptions;
import com.ibm.ws.security.zOS.authz.SAFRoleMapperFactory;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.Subject;

public class SAFAuthorizationTableImpl
implements AuthorizationTable {
    private static final TraceComponent tc = Tr.register(SAFAuthorizationTableImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String SUBJECT_KEY = "AUTHZ_SUBJECT";
    private static boolean _roleClassInactive = false;
    private SAFRoleMapper _roleMapper = null;
    private boolean _suppressMessages = false;
    private SAFAuthorizationOptions.LogOption _logOption = null;

    public SAFAuthorizationTableImpl() {
        Properties topLevelProps;
        String property;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if ((property = (topLevelProps = SecurityObjectLocator.getSecurityConfig().getProperties()).getProperty("com.ibm.security.SAF.Authz.Log.Option")) != null && property.length() > 0) {
            if (property.equals(SAFAuthorizationOptions.NONE.toString())) {
                this._logOption = SAFAuthorizationOptions.NONE;
            } else if (property.equals(SAFAuthorizationOptions.ASIS.toString())) {
                this._logOption = SAFAuthorizationOptions.ASIS;
            } else if (property.equals(SAFAuthorizationOptions.NOFAIL.toString())) {
                this._logOption = SAFAuthorizationOptions.NOFAIL;
            }
        }
        property = topLevelProps.getProperty("com.ibm.security.SAF.EJBROLE.Audit.Messages.Suppress");
        this._suppressMessages = "true".equalsIgnoreCase(property);
        this._roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();
        Tr.audit(tc, "security.zos.saf.authz.enabled");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", this);
        }
    }

    public boolean isEveryoneGranted(HashMap ctx, String[] reqRoles) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{ctx, reqRoles});
        }
        boolean everyoneGranted = SAFAuthorizationTableImpl.isRoleClassInactive();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(everyoneGranted));
        }
        return everyoneGranted;
    }

    public boolean isGrantedRole(HashMap context, String roleName, Principal principal) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{context, roleName, principal});
        }
        String[] roles = new String[]{roleName};
        boolean inRole = this.isGrantedAnyRole(context, roles, principal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(inRole));
        }
        return inRole;
    }

    public boolean isGrantedAnyRole(HashMap context, String[] reqRoles, Principal principal) throws SecurityProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{context, reqRoles, principal});
        }
        boolean inRole = false;
        PlatformCredential pc = null;
        try {
            final Subject subject = (Subject)context.get(SUBJECT_KEY);
            pc = (PlatformCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                    Object cred = null;
                    if (wsCred != null) {
                        cred = wsCred.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    if (cred == null) {
                        cred = PlatformCredentialManager.instance().createDefaultCredential();
                    }
                    return cred;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae.getException(), "com.ibm.ws.security.zOS.authz.SAFAuthorizationTableImpl", "243", this);
            String msg = "Unable to acquire credential for authorization";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to acquire credential for authorization", pae.getException());
            }
            throw new SecurityProviderException("Unable to acquire credential for authorization", pae.getException());
        }
        if (reqRoles == null || reqRoles.length == 0) {
            throw new IllegalArgumentException("Target role is required");
        }
        String appName = (String)context.get("APPLICATION_NAME");
        boolean isAdmin = "admin-authz".equals(appName);
        String[] profiles = this.getProfilesFromRoles(context, reqRoles);
        boolean suppressMessages = isAdmin && this._logOption == null || this._suppressMessages;
        inRole = this.isCredentialInAnyRole(pc, profiles, this._logOption, suppressMessages);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(inRole));
        }
        return inRole;
    }

    private boolean isCredentialInAnyRole(PlatformCredential platformCred, String[] profiles, SAFAuthorizationOptions.LogOption logOption, boolean suppressMessages) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCredentialInAnyRole", new Object[]{platformCred, profiles, logOption, new Boolean(suppressMessages)});
        }
        boolean inRole = false;
        SAFAuthorizationManager authzMgr = SAFAuthorizationManager.instance();
        String className = "EJBROLE";
        for (int i = 0; i < profiles.length && !inRole; ++i) {
            boolean isLastProfile;
            boolean bl = isLastProfile = i == profiles.length - 1;
            if (logOption == null) {
                SAFAuthorizationOptions.LogOption logOption2 = logOption = isLastProfile ? SAFAuthorizationOptions.ASIS : SAFAuthorizationOptions.NOFAIL;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "On the last profile, The log option is null so setting it to: " + logOption);
                }
            }
            try {
                inRole = authzMgr.checkAccess(platformCred, className, profiles[i], null, AccessLevel.READ, logOption, suppressMessages);
                continue;
            }
            catch (AuthorizationDeniedException e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "SAF has explicitly denied READ access to the profile " + profiles[i] + " in the resource class  " + className + ".", e);
                continue;
            }
            catch (InactiveClassException e) {
                inRole = true;
                SAFAuthorizationTableImpl.setRoleClassInactive();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The resource class " + className + " has not been activated.  As a result, access will be allowed.", e);
                continue;
            }
            catch (InvalidCredentialException e) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "The Subject associated with the current thread of execution does not contain a valid PlatformCredential.", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCredentialInAnyRole", new Boolean(inRole));
        }
        return inRole;
    }

    protected String[] getProfilesFromRoles(HashMap context, String[] roles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProfilesFromRoles", new Object[]{context, roles});
        }
        String[] profiles = new String[roles.length];
        String appName = (String)context.get("APPLICATION_NAME");
        for (int i = 0; i < roles.length; ++i) {
            profiles[i] = this._roleMapper.getProfileFromRole(appName, roles[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProfilesFromRoles", profiles);
        }
        return profiles;
    }

    private static synchronized void setRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRoleClassInactive");
        }
        if (!_roleClassInactive) {
            _roleClassInactive = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRoleClassInactive");
        }
    }

    private static boolean isRoleClassInactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRoleClassInactive");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRoleClassInactive", new Boolean(_roleClassInactive));
        }
        return _roleClassInactive;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(";_logOption=").append(this._logOption);
        sb.append(";_suppressMessages=").append(this._suppressMessages);
        sb.append(";_roleMapper=").append(this._roleMapper);
        sb.append(";_roleClassInactive").append(_roleClassInactive);
        return sb.toString();
    }
}

