/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.PermissionRoleMap;
import java.util.List;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;

public class WebResourceCollectionConstraints {
    private static final TraceComponent tc = Tr.register(WebResourceCollectionConstraints.class);
    public static String[] ALL_HTTP_METHODS = null;
    public static HTTPMethodTypeEnum[] ALL_HTTP_METHODS_ENUM = null;
    public static final int NO_TRANSPORT_GUARANTEE_REQUIRED = 0;
    public static final int SSL_TRANSPORT_GUARANTEE_REQUIRED = 1;
    public static int NO_MATCH = -1;
    public static int EXACT_MATCH = 0;
    public static int PATHNAME_MATCH = 1;
    public static int EXTENSION_MATCH = 2;
    private static String NO_MATCHING_URI = "";
    private List URIPatternsList = null;
    private String[] Methods = null;
    private int transportGuarantee = 0;
    private SecurityRole[] requiredRoles = PermissionRoleMap.NO_REQUIRED_ROLES;

    public WebResourceCollectionConstraints(List urls, String[] methods) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WebResourceCollectionConstraints: ", new Object[]{urls, methods});
        }
        int cnt = urls.size();
        this.URIPatternsList = urls;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of URIPatterns: " + cnt);
        }
        if (methods == null || methods.length == 0) {
            this.Methods = WebResourceCollectionConstraints.getAllHttpMethods();
        } else {
            cnt = methods.length;
            this.Methods = new String[cnt];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of Methods: " + cnt);
            }
            for (int i = 0; i < cnt; ++i) {
                this.Methods[i] = methods[i];
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Methods[" + i + "] = " + this.Methods[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WebResourceCollectionConstraints");
        }
    }

    public static int getMatchType(String pattern) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchType", new Object[]{pattern});
        }
        int matchType = pattern.startsWith("/") && pattern.endsWith("/*") ? PATHNAME_MATCH : (pattern.startsWith("*.") ? EXTENSION_MATCH : EXACT_MATCH);
        if (tc.isDebugEnabled()) {
            StringBuffer b = new StringBuffer("URI Match type = ");
            if (matchType == PATHNAME_MATCH) {
                b.append("PATHNAME");
            } else if (matchType == EXTENSION_MATCH) {
                b.append("EXTENSION");
            } else {
                b.append("EXACT");
            }
            Tr.debug(tc, b.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchType");
        }
        return matchType;
    }

    public String matches(String uriName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matches", new Object[]{uriName, methodName});
        }
        String[] url_list = this.URIPatternsList.toArray(new String[this.URIPatternsList.size()]);
        String currentMatchingPathNameURI = NO_MATCHING_URI;
        String currentMatchingExtensionURI = NO_MATCHING_URI;
        if (!this.memberOfMethodList(methodName)) {
            return null;
        }
        for (int i = 0; i < url_list.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking URL: " + url_list[i]);
            }
            if (url_list[i].equals(uriName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "matches");
                }
                return url_list[i];
            }
            if (this.matches_pathname(uriName, url_list[i])) {
                if (url_list[i].length() <= currentMatchingPathNameURI.length()) continue;
                currentMatchingPathNameURI = url_list[i];
                continue;
            }
            if (!this.matches_extension(uriName, url_list[i])) continue;
            currentMatchingExtensionURI = url_list[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matches");
        }
        if (currentMatchingPathNameURI != NO_MATCHING_URI) {
            return currentMatchingPathNameURI;
        }
        if (currentMatchingExtensionURI != NO_MATCHING_URI) {
            return currentMatchingExtensionURI;
        }
        return null;
    }

    public List getURIPatterns() {
        return this.URIPatternsList;
    }

    public String[] getMethods() {
        return this.Methods;
    }

    public void setRequiredRoles(SecurityRole[] r) {
        this.requiredRoles = r;
    }

    public void setTransportGuarantee(int g) {
        this.transportGuarantee = g;
    }

    public SecurityRole[] getRequiredRoles() {
        return this.requiredRoles;
    }

    public int getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void removeUri(String uri) {
        this.URIPatternsList.remove(uri);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removed uri: " + uri + " from the list " + this.URIPatternsList);
        }
    }

    private boolean matches_pathname(String incomingPattern, String storedPattern) {
        if (storedPattern.startsWith("/") && storedPattern.endsWith("/*")) {
            String s = storedPattern.substring(0, storedPattern.length() - 1);
            if (s.equalsIgnoreCase(incomingPattern)) {
                return true;
            }
            if (incomingPattern.equalsIgnoreCase(s.substring(0, s.length() - 1))) {
                return true;
            }
            if (incomingPattern.startsWith(s)) {
                return true;
            }
        }
        return false;
    }

    private boolean matches_extension(String incomingPattern, String storedPattern) {
        String ext;
        return storedPattern.startsWith("*.") && incomingPattern.endsWith(ext = storedPattern.substring(1));
    }

    private boolean memberOfMethodList(String methodName) {
        String[] method_list = this.Methods;
        for (int i = 0; i < method_list.length; ++i) {
            if (!methodName.equalsIgnoreCase(method_list[i])) continue;
            return true;
        }
        return false;
    }

    public static final HTTPMethodTypeEnum[] getAllHttpMethodEnum() {
        if (ALL_HTTP_METHODS_ENUM != null) {
            return ALL_HTTP_METHODS_ENUM;
        }
        List httpMeths = HTTPMethodTypeEnum.VALUES;
        Object[] h = httpMeths.toArray();
        int len = h.length;
        ALL_HTTP_METHODS_ENUM = new HTTPMethodTypeEnum[len];
        for (int i = 0; i < len; ++i) {
            WebResourceCollectionConstraints.ALL_HTTP_METHODS_ENUM[i] = (HTTPMethodTypeEnum)h[i];
        }
        return ALL_HTTP_METHODS_ENUM;
    }

    public static final String[] getAllHttpMethods() {
        if (ALL_HTTP_METHODS != null) {
            return ALL_HTTP_METHODS;
        }
        List httpMeths = HTTPMethodTypeEnum.VALUES;
        Object[] h = httpMeths.toArray();
        int len = h.length;
        ALL_HTTP_METHODS = new String[len];
        for (int i = 0; i < len; ++i) {
            WebResourceCollectionConstraints.ALL_HTTP_METHODS[i] = ((HTTPMethodTypeEnum)h[i]).toString();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "ALL_HTTP_METHODS[" + i + "]=" + ALL_HTTP_METHODS[i]);
        }
        return ALL_HTTP_METHODS;
    }
}

