/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebReply;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

public class RedirectReply
extends WebReply {
    private ArrayList cookieList = null;
    private static TraceComponent tc = Tr.register(RedirectReply.class, "Security", "com.ibm.ejs.resources.security");
    private static String LOCATION_HDR = "Location";
    private static int replyCode = 0;

    public RedirectReply(String url) {
        super(RedirectReply.getReplyCode(), url);
    }

    public RedirectReply(String url, ArrayList list) {
        super(RedirectReply.getReplyCode(), url);
        this.cookieList = list;
    }

    public void writeResponse(HttpServletResponse rsp) throws IOException {
        if (this.cookieList != null && this.cookieList.size() > 0) {
            WebAttributes.addCookiesToResponse(this.cookieList, rsp);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security redirect code: " + this.getStatusCode());
        }
        if (this.getStatusCode() != 303) {
            rsp.sendRedirect(rsp.encodeURL(this.message));
        } else if (rsp instanceof IExtendedResponse) {
            ((IExtendedResponse)rsp).sendRedirect303(rsp.encodeURL(this.message));
        } else {
            rsp.sendRedirect(rsp.encodeURL(this.message));
            Tr.debug(tc, "Response is not of type IExtendedResponse.");
        }
    }

    private static int getReplyCode() {
        if (replyCode == 0) {
            replyCode = 302;
            String rc = System.getProperty("com.ibm.ws.security.RedirectCode");
            if (rc != null && rc.equalsIgnoreCase("SC_SEE_OTHER")) {
                replyCode = 303;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security redirect code set to: " + replyCode);
            }
        }
        return replyCode;
    }
}

