/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;

public class AuthenticationResult {
    public static final int UNKNOWN = 0;
    public static final int SUCCESS = 1;
    public static final int FAILURE = 2;
    public static final int SEND_401 = 3;
    public static final int REDIRECT = 4;
    public static final int TAI_CHALLENGE = 5;
    public static final int CONTINUE = 6;
    int status;
    private int taiChallengeCode = 401;
    String realm = null;
    String userName = null;
    String passWord = null;
    private static final TraceComponent tc = Tr.register(AuthenticationResult.class, null, "com.ibm.ejs.resources.security");
    Subject subject = null;
    WSCredential credentials = null;
    ArrayList cookieList = new ArrayList();
    Cookie refererCookie;
    String reason;
    String redirectURL;

    public AuthenticationResult(int status, Subject _subject) {
        this.status = status;
        this.subject = _subject;
        if (status != 0) {
            try {
                this.credentials = SubjectHelper.getWSCredentialFromSubject(this.subject);
            }
            catch (Exception e) {
                this.credentials = null;
            }
        } else {
            this.credentials = null;
        }
    }

    public AuthenticationResult(int status, String str) {
        this(status, str, null);
    }

    public AuthenticationResult(int status, String str, int taiChallengeCode) {
        this(status, str, null);
        this.taiChallengeCode = taiChallengeCode;
    }

    public AuthenticationResult(int status, String str, Cookie c) {
        this.status = status;
        this.subject = null;
        if (status == 2) {
            this.reason = str;
        } else if (status == 3) {
            this.realm = str;
        } else if (status == 4) {
            this.redirectURL = str;
            this.refererCookie = c;
        }
        this.cookieList.add(c);
    }

    public int getStatus() {
        return this.status;
    }

    public int getTAIChallengeCode() {
        return this.taiChallengeCode;
    }

    public String getReason() {
        return this.reason;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getRealm() {
        if (this.credentials == null && this.realm != null) {
            return this.realm;
        }
        if (this.credentials != null) {
            try {
                return this.credentials.getRealmName();
            }
            catch (GeneralSecurityException e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getRealm", "150", this);
                return null;
            }
        }
        return ContextManagerFactory.getInstance().getDefaultRealm();
    }

    public String getUserName() {
        if (this.credentials == null && this.userName != null) {
            return this.userName;
        }
        try {
            return this.credentials == null ? null : this.credentials.getSecurityName();
        }
        catch (GeneralSecurityException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getRealm", "171", this);
            return null;
        }
    }

    public String getPublicName() {
        try {
            return this.credentials == null ? null : this.credentials.getRealmSecurityName();
        }
        catch (GeneralSecurityException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getRealm", "184", this);
            return null;
        }
    }

    public String getAccessId() {
        try {
            return this.credentials == null ? null : this.credentials.getAccessId();
        }
        catch (GeneralSecurityException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getRealm", "196", this);
            return null;
        }
    }

    public byte[] getCredentialToken() {
        try {
            return this.credentials == null ? null : this.credentials.getCredentialToken();
        }
        catch (GeneralSecurityException e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".getRealm", "203", this);
            return null;
        }
    }

    public void clearCookieList() {
        this.cookieList.clear();
    }

    public void setCookieList(ArrayList list) {
        this.cookieList.addAll(list);
    }

    public void setCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public ArrayList getCookies() {
        return this.cookieList;
    }

    public Cookie getRefererCookie() {
        return this.refererCookie;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }
}

