/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.ws.security.util.ConfigUtils;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class SecurityConfigurationUtilities {
    private static TraceComponent tc = Tr.register(SecurityConfigurationUtilities.class, "Security", "com.ibm.ejs.resources.security");

    public static Properties setLDAPProperties(LDAPUserRegistry reg) {
        String val;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLDAPProperties ");
        }
        LDAPUserRegistry registry = reg;
        Properties props = new Properties();
        props.put("LDAP.server.id", ConfigUtils.variableMapExpand(registry.getServerId()));
        String passwd = registry.getServerPassword();
        if (passwd != null) {
            props.put("LDAP.server.pwd", ConfigUtils.variableMapExpand(passwd));
        } else {
            props.put("LDAP.server.pwd", "");
        }
        String realm = registry.getRealm();
        if (realm != null && realm.length() > 0) {
            props.put("LDAP.server.realm", ConfigUtils.variableMapExpand(realm));
        }
        if ((val = registry.getSearchFilter().getUserFilter()) != null) {
            props.put("user.filter", val);
        }
        if ((val = registry.getSearchFilter().getGroupFilter()) != null) {
            props.put("group.filter", val);
        }
        if ((val = registry.getSearchFilter().getGroupIdMap()) != null) {
            props.put("group.idmap", val);
        }
        if ((val = registry.getSearchFilter().getUserIdMap()) != null) {
            props.put("user.idmap", val);
        }
        if ((val = registry.getSearchFilter().getGroupMemberIdMap()) != null) {
            props.put("groupmember.idmap", val);
        }
        props.put("security.registry.ldap.searchTimeLimit", Long.toString(registry.getSearchTimeout()));
        props.put("security.registry.ldap.reuseConn", new Boolean(registry.isReuseConnection()).toString());
        if (registry.getSearchFilter() != null) {
            switch (registry.getSearchFilter().getCertificateMapMode().getValue()) {
                case 0: {
                    props.put("certificate.map.mode", "exactDNMode");
                    break;
                }
                case 1: {
                    props.put("certificate.map.mode", "filterDescriptorMode");
                    if (registry.getSearchFilter().getCertificateFilter() == null) {
                        Tr.warning(tc, "security.config.missingAttributeCertFilter");
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "No CertificateFilter specified. Mandatory for Certificate Mode CERTIFICATE_FILTER");
                        break;
                    }
                    props.put("certificate.map.filter", registry.getSearchFilter().getCertificateFilter());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LDAP registry search filter info missing");
        }
        EList hosts = registry.getHosts();
        String ldapHost = "";
        String ldapProtocol = "ldap://";
        if (hosts != null && hosts.size() > 0) {
            Iterator iter = hosts.iterator();
            while (iter.hasNext()) {
                StringBuffer ldapurl;
                block57: {
                    String singleLDAP;
                    String hostName = "";
                    String port = "";
                    EndPoint ep = (EndPoint)iter.next();
                    hostName = ConfigUtils.variableMapExpand(ep.getHost());
                    try {
                        if (new Integer(ep.getPort()) > 0) {
                            port = Integer.toString(ep.getPort());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (hostName != null && !hostName.equals("")) {
                        props.put("com.ibm.ssl.remoteHost", hostName);
                    }
                    if (port != null && !port.equals("")) {
                        props.put("com.ibm.ssl.remotePort", port);
                    }
                    ldapurl = new StringBuffer();
                    if (hostName.startsWith(ldapProtocol)) {
                        hostName = hostName.substring(ldapProtocol.length());
                    }
                    if (ConfigUtils.isIPv6Addr(hostName)) {
                        hostName = ConfigUtils.formatIPv6Addr(hostName);
                    }
                    ldapurl.append("ldap://").append(hostName);
                    if (port != null && port.length() > 0) {
                        ldapurl.append(":" + port);
                    }
                    boolean resolveIP = true;
                    Properties ldapRegProps = ConfigUtils.getProperties(registry.getProperties());
                    if (ldapRegProps != null && (singleLDAP = (String)ldapRegProps.get("com.ibm.websphere.security.registry.ldap.singleLDAP")) != null && singleLDAP.equalsIgnoreCase("true")) {
                        Tr.debug(tc, "com.ibm.websphere.security.registry.ldap.singleLDAP property is set to true");
                        resolveIP = false;
                    }
                    if (resolveIP && hostName != null && hostName.length() > 0) {
                        try {
                            InetAddress[] IPs = InetAddress.getAllByName(hostName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, hostName + " has " + IPs.length + " IP addresses");
                            }
                            if (IPs != null && IPs.length > 1) {
                                StringBuffer IPlist = new StringBuffer(hostName);
                                IPlist.append(" has multiple IP addresses of ");
                                for (int i = 0; i < IPs.length; ++i) {
                                    String ip = IPs[i].getHostAddress();
                                    if (ConfigUtils.isIPv6Addr(ip)) {
                                        ip = ConfigUtils.formatIPv6Addr(ip);
                                    }
                                    IPlist.append(" ").append(ip).append(",");
                                    ldapurl.append(" ldap://").append(ip);
                                    if (port == null || port.length() <= 0) continue;
                                    ldapurl.append(":" + port);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, IPlist.toString());
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block57;
                            Tr.debug(tc, "Could not resolve IP address of LDAP host name:" + hostName);
                        }
                    }
                }
                if (ldapurl == null || ldapurl.length() <= 0) continue;
                if (ldapHost == "") {
                    ldapHost = ldapurl.toString();
                    continue;
                }
                String bLdap = ldapurl.toString();
                if (ldapHost.indexOf(bLdap) != -1) continue;
                ldapHost = ldapHost + " " + bLdap;
            }
            props.put("java.naming.provider.url", ldapHost);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new LDAP host is " + ldapHost);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LDAP server host and port info missing");
        }
        String baseDN = registry.getBaseDN();
        if (baseDN != null && baseDN.length() > 0) {
            props.put("ldap.basedn", ConfigUtils.variableMapExpand(baseDN));
        }
        if (registry.getBindDN() != null && registry.getBindDN().length() > 0) {
            props.put("java.naming.security.principal", ConfigUtils.variableMapExpand(registry.getBindDN()));
        }
        if (registry.getBindPassword() != null && registry.getBindPassword().length() > 0) {
            props.put("java.naming.security.credentials", ConfigUtils.variableMapExpand(registry.getBindPassword()));
        }
        if (registry.getType() != null) {
            switch (registry.getType().getValue()) {
                case 0: {
                    props.put("dirType", "ibm_dir_server");
                    break;
                }
                case 2: {
                    props.put("dirType", "iplanet");
                    break;
                }
                case 3: {
                    props.put("dirType", "netscape");
                    break;
                }
                case 4: {
                    props.put("dirType", "domino50");
                    break;
                }
                case 1: {
                    props.put("dirType", "secureway");
                    break;
                }
                case 6: {
                    props.put("dirType", "actived");
                    break;
                }
                case 5: {
                    props.put("dirType", "edirectory");
                    break;
                }
                case 7: {
                    props.put("dirType", "custom");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknow LDAP registry type");
        }
        props.put("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
        if (tc.isEntryEnabled()) {
            Properties props1 = ConfigUtils.maskPasswords(props);
            Tr.exit(tc, "setLDAPProperties " + props1);
        }
        return props;
    }
}

