/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurity.Current;
import com.ibm.IExtendedSecurity._LoginHelper;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.common.util.CORBAUtil;
import java.io.UnsupportedEncodingException;
import org.omg.Security.Attribute;
import org.omg.Security.AttributeType;
import org.omg.Security.CredentialType;
import org.omg.Security.DuplicateAttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.InvalidAttributeType;
import org.omg.Security.InvalidCredentialType;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.InvalidCredential;
import org.omg.SecurityLevel2.LoginFailed;

public class LoginHelper {
    protected static final int PUBLIC = 0;
    static final AttributeType[] secAttrType = new AttributeType[1];
    private Current current = this.getSecurityCurrent();

    public Credentials login(String userid, String password) throws LoginFailed {
        if (userid == null || userid.length() == 0) {
            throw new LoginFailed();
        }
        if (password == null || password.length() == 0) {
            throw new LoginFailed();
        }
        _LoginHelper loginHelper = this.current.login_helper();
        return loginHelper.request_login(userid, "", password, new CredentialsHolder(), new OpaqueHolder());
    }

    public void setInvocationCredentials(Credentials invokedCreds) throws InvalidCredentialType, InvalidCredential {
        this.current.set_credentials(CredentialType.SecInvocationCredentials, invokedCreds);
    }

    public Credentials getInvocationCredentials() throws InvalidCredentialType {
        return this.current.get_credentials(CredentialType.SecInvocationCredentials);
    }

    public String getUserName(Credentials creds) throws DuplicateAttributeType, InvalidAttributeType {
        Attribute[] publicAttrs = creds.get_attributes(secAttrType);
        String uname = "";
        try {
            uname = new String(publicAttrs[0].value, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.util.LoginHelper.getUserName", "157", this);
        }
        return uname;
    }

    private Current getSecurityCurrent() throws IllegalStateException {
        Current current = null;
        try {
            ORB orb = CORBAUtil.getORB();
            if (orb == null) {
                throw new IllegalStateException("SecurityCurrent: null");
            }
            current = (Current)orb.resolve_initial_references("SecurityCurrent");
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.util.LoginHelper.getSecurityCurrent", "182", this);
            throw new IllegalStateException("Error getting SecurityCurrent from the ORB");
        }
        return current;
    }

    static {
        ExtensibleFamily familyOMG = new ExtensibleFamily(0, 1);
        LoginHelper.secAttrType[0] = new AttributeType(familyOMG, 1);
    }
}

