/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.concurrent.ConcurrentHashMap;

public class LRUCache
extends ConcurrentHashMap {
    private static final TraceComponent tc = Tr.register(LRUCache.class, null, "com.ibm.ejs.resources.security");
    private int currentPointer = 0;
    private Object[] lruList;

    public LRUCache(int maxSize) {
        super(maxSize);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Constructor");
        }
        this.currentPointer = 0;
        this.lruList = new Object[maxSize];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Constructor");
        }
    }

    public Object get(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", key);
        }
        if (key == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "get");
            }
            return null;
        }
        Object c = super.get(key);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get");
        }
        return c;
    }

    public Object put(Object key, Object c) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put", key);
        }
        Object returnObj = null;
        Object k = this.lruList[this.currentPointer];
        if (k != null) {
            this.remove(k);
        }
        this.lruList[this.currentPointer] = key;
        ++this.currentPointer;
        if (this.currentPointer >= this.lruList.length) {
            this.currentPointer = 0;
        }
        returnObj = super.put(key, c);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put");
        }
        return returnObj;
    }

    public Object remove(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", key);
        }
        Object c = super.remove(key);
        this.lruList[this.currentPointer] = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
        return c;
    }
}

