/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.securitydomain.SecDomainHelper;
import com.ibm.ws.security.util.ApplicationInfoHelper;

public class DomainContextHelper {
    private static TraceComponent tc = Tr.register(DomainContextHelper.class, "security", "com.ibm.ws.security.util");

    public static boolean switchToAppDomain(String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "switchToAppDomain", new Object[]{appName});
        }
        boolean pushed = false;
        CommandProviderHelper helper = CommandMgr.getCommandMgr().getCommandProviderHelper();
        if (helper == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error: CommandProviderHelper object is null");
            }
            return false;
        }
        ConfigService configService = helper.getConfigService();
        if (configService == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error: ConfigService is null.");
            }
            return false;
        }
        String domainName = null;
        if (appName != null && !appName.equals("")) {
            String resource1 = ApplicationInfoHelper.getAppDeploymentTarget(appName);
            String resource2 = SecDomainHelper.convertResourceNameToCommandForm(resource1);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, " The target resource in cmd form is: " + resource2);
            }
            try {
                domainName = SecDomainHelper.getSecurityDomainForResource(resource2, configService, false);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, " domainName is: " + domainName);
                }
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error: caught unexpected exception trying to get domainName for resource: " + resource2 + " exception msg: " + e.getMessage());
                }
                return false;
            }
            if (domainName == null || domainName.equals("")) {
                domainName = "admin";
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, " retrieved domainName is null, resetting to admin domain");
                }
            }
            pushed = SecurityObjectLocator.pushContext(domainName, "domain");
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "switchToAppDomain: passed in appName is null or empty.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "switchToAppDomain", new Object[]{appName, domainName});
        }
        return pushed;
    }

    public static void unwindAppDomain(String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unwindAppDomain", new Object[]{appName});
        }
        if (appName != null && !appName.equals("")) {
            String domainName = ApplicationInfoHelper.getAppDeploymentTarget(appName);
            SecurityConfigResource res = SecurityObjectLocator.peekContext();
            String resType = res.getType();
            String resName = res.getName();
            if (resType != null && resType.equalsIgnoreCase("domain") && resName != null && resName.equalsIgnoreCase(domainName)) {
                SecurityObjectLocator.popContext();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwindAppDomain: passed in appName is null or empty.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unwindAppDomain", new Object[]{appName});
        }
    }

    public static boolean switchToAppDomainIfDmgr(String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "switchToAppDomainIfDmgr", new Object[]{appName});
        }
        boolean value = false;
        String processType = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error: got a null AdminService object.");
            }
        } else {
            processType = adminService.getProcessType();
            if (processType != null && processType.equalsIgnoreCase("DeploymentManager")) {
                if (SecurityObjectLocator.getSecurityConfigManager().isMultiDomainDefined() && SecurityObjectLocator.getSecurityConfig("security").getPropertyBool("com.ibm.websphere.security.allowMultipleJaccProviders")) {
                    value = DomainContextHelper.switchToAppDomain(appName);
                } else if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Dmgr process detected no multi-domain defined or property com.ibm.websphere.security.allowMultipleJaccProviders is not set to true in security.xml.");
                }
            } else if (tc.isEntryEnabled()) {
                Tr.debug(tc, "not in a dmgr process. This process type is: " + processType);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "switchToAppDomainIfDmgr", new Object[]{value});
        }
        return value;
    }

    public static boolean isDmgrAndMultiDomainAndMultiJacc() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDmgrAndMultiDomainAndMultiJacc");
        }
        boolean value = false;
        String processType = null;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error: got a null AdminService object.");
            }
        } else {
            processType = adminService.getProcessType();
            if (processType != null && processType.equalsIgnoreCase("DeploymentManager")) {
                if (SecurityObjectLocator.getSecurityConfigManager().isMultiDomainDefined() && SecurityObjectLocator.getSecurityConfig("security").getPropertyBool("com.ibm.websphere.security.allowMultipleJaccProviders")) {
                    value = true;
                } else if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Dmgr process detected no multi-domain defined or property com.ibm.websphere.security.allowMultipleJaccProviders is not set to true in security.xml.");
                }
            } else if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error: got a null processType.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDmgrAndMultiDomainAndMultiJacc", value);
        }
        return value;
    }
}

