/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.config.AdminData;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.ConfigurationException;

public class ConfigUtils {
    private static VariableMap variableMap = VariableMapFactory.getVariableMap();

    public static String clean(String inString) {
        String outString = null;
        if (inString == null) {
            return null;
        }
        outString = inString.trim();
        if (outString.startsWith("\"") && outString.endsWith("\"") || outString.startsWith("'") && outString.endsWith("'")) {
            outString = outString.substring(1, outString.length() - 1).trim();
        }
        return outString;
    }

    public static boolean stringToBoolean(String in_name) {
        if (in_name == null) {
            return false;
        }
        return in_name.equalsIgnoreCase("true") || in_name.equalsIgnoreCase("yes");
    }

    public static String mask(String inString) {
        String outString = null;
        if (inString != null) {
            char[] outStringBuffer = new char[inString.length()];
            for (int i = 0; i < inString.length(); ++i) {
                outStringBuffer[i] = 42;
            }
            outString = new String(outStringBuffer);
        }
        return outString;
    }

    public static Properties maskPasswords(Properties props) {
        Properties props1 = new Properties();
        if (props == null) {
            return null;
        }
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            props1.put(key, props.get(key));
        }
        if (props.getProperty("password") != null) {
            props1.put("password", "XXXXXX");
        }
        if (props.getProperty("java.naming.security.credentials") != null) {
            props1.put("java.naming.security.credentials", "XXXXXX");
        }
        if (props.getProperty("serverPassword") != null) {
            props1.put("serverPassword", "XXXXXX");
        }
        if (props.getProperty("LDAP.server.pwd") != null) {
            props1.put("LDAP.server.pwd", "XXXXXX");
        }
        return props1;
    }

    public static String formatIPv6Addr(String host) {
        return "[" + host + "]";
    }

    public static boolean isIPv6Addr(String host) {
        boolean rtn = false;
        if (host != null) {
            if (host.indexOf("[") > 0 || host.indexOf(":") > 0) {
                rtn = true;
            } else {
                StringTokenizer st = new StringTokenizer(host, ".");
                if (st.countTokens() != 8) {
                    rtn = false;
                } else {
                    rtn = true;
                    while (st.hasMoreTokens() && rtn) {
                        String token = st.nextToken();
                        if (token.length() <= 0) continue;
                        try {
                            int i = Integer.parseInt(token, 16);
                            if (i >= 0 && i <= 65535) continue;
                            rtn = false;
                        }
                        catch (Exception e) {
                            rtn = false;
                        }
                    }
                }
            }
        }
        return rtn;
    }

    public static String getHostName() throws ConfigurationException {
        AdminData adminData = SecurityObjectLocator.getAdminData();
        String host = adminData.getString("process.hostName");
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getCanonicalHostName();
                adminData.setString("process.hostName", host.toLowerCase());
            }
            catch (UnknownHostException e) {
                throw new ConfigurationException("Cannot get canonical host name for server.");
            }
        }
        return host;
    }

    public static String expandHost(String serverIDString, String in_host) throws ConfigurationException {
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        return ConfigUtils.expandHost(security2, serverIDString, in_host);
    }

    public static String expandHost(SecurityConfig security2, String serverIDString, String in_host) throws ConfigurationException {
        int len = "${HOST}".length();
        if (serverIDString == null) {
            return null;
        }
        int index = serverIDString.indexOf("${HOST}");
        if (index != -1) {
            String useShortHostName;
            AdminData adminData = SecurityObjectLocator.getAdminData();
            if (adminData.getString("security.unexpandedServerId") == null) {
                adminData.setString("security.unexpandedServerId", serverIDString);
            }
            String canonicalHostName = null;
            canonicalHostName = in_host == null ? ConfigUtils.getHostName() : in_host;
            if (canonicalHostName != null) {
                canonicalHostName = canonicalHostName.toLowerCase();
            }
            if ((useShortHostName = security2.getProperty("security.useShortHostName")) != null && (useShortHostName.equals("true") || useShortHostName.equals("yes"))) {
                int period_index = canonicalHostName.indexOf(46);
                canonicalHostName = canonicalHostName.substring(0, period_index);
            }
            StringBuffer serverIDStringBuffer = new StringBuffer(serverIDString);
            serverIDStringBuffer.replace(index, index + len, canonicalHostName);
            return serverIDStringBuffer.toString();
        }
        return serverIDString;
    }

    public static Properties expandProps(Properties props) {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String value;
                String propsKey = (String)e.nextElement();
                String propsValue = null;
                if (!(props.get(propsKey) instanceof String) || (propsValue = (String)props.get(propsKey)) == null || propsKey.equalsIgnoreCase("certificate.map.filter") || (value = ConfigUtils.variableMapExpand(propsValue)) == null) continue;
                props.put(propsKey, value);
            }
        }
        return props;
    }

    public static String expandString(String propsValue) {
        return ConfigUtils.variableMapExpand(propsValue);
    }

    public static Properties getProperties(List props) {
        Properties oProps = new Properties();
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                Property p = (Property)props.get(i);
                oProps.put(p.getName(), p.getValue());
            }
        }
        return oProps;
    }

    public static String variableMapExpand(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        return variableMap.expand(name);
    }
}

