/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.PrivilegedAction;

public class SingleSignonTokenImpl
extends AbstractTokenImpl
implements SingleSignonToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private String name = "LtpaToken";
    private short version = (short)2;
    private static final TraceComponent tc = Tr.register(SingleSignonTokenImpl.class, null, "com.ibm.ejs.resources.security");
    private static String factoryClass = null;

    public SingleSignonTokenImpl() {
        if (factoryClass == null) {
            factoryClass = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.wsspi.security.token.singleSignonTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "factoryClass:" + factoryClass);
            }
        }
    }

    public void initializeToken(byte[] _ssoToken) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeToken(byte[])", "_ssoToken=" + _ssoToken);
        }
        this.initializeToken(_ssoToken, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(byte[])");
        }
    }

    public void initializeToken(byte[] _ssoToken, boolean refreshIfExpired) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeToken(byte[],boolean)", new Object[]{"_ssoToken=" + _ssoToken, "refreshIfExpired=" + refreshIfExpired});
        }
        try {
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            this.token = null;
            if (factoryClass != null) {
                try {
                    this.token = this.ltpaServer.validateToken(_ssoToken, factoryClass, refreshIfExpired);
                }
                catch (Exception e) {
                    Tr.debug(tc, "Exception validating sso token by using factoryClass.", new Object[]{e});
                }
            }
            if (this.token == null) {
                this.token = this.ltpaServer.validateToken(_ssoToken, refreshIfExpired);
            }
            final Token tokenPriv = this.token;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SingleSignonTokenImpl.this.setToken(tokenPriv);
                    return null;
                }
            });
        }
        catch (WSLoginFailedException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", "104", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", "111", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(byte[],boolean)");
        }
    }

    public void initializeToken(Token _token) throws WSLoginFailedException {
        final Token tokenPriv = this.token = _token;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SingleSignonTokenImpl.this.setToken(tokenPriv);
                return null;
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public short getVersion() {
        return this.version;
    }

    public Object clone() {
        try {
            SingleSignonTokenImpl newToken = new SingleSignonTokenImpl();
            this.token = (Token)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return SingleSignonTokenImpl.this.getToken();
                }
            });
            newToken.initializeToken((Token)this.token.clone());
            return newToken;
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception creating clone of single signon token.", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.token.SingleSignonToken.clone", "178");
            return null;
        }
    }
}

