/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.kerberos.Krb5WSCredentialUtils;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactoryFactory;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.ietf.jgss.GSSCredential;

public class AuthenticationTokenImpl
extends AbstractTokenImpl
implements AuthenticationToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private byte[] tokenBytes = null;
    private String LTPA_OID = "oid:1.3.18.0.2.30.2";
    private GSSCredential gssCred = null;
    private Hashtable kerberosData = new Hashtable();
    private String KERBEROS_OID = "oid:1.2.840.113554.1.2.2";
    private ContextManager contextManager = null;
    private String tokenName;
    private boolean forwardable;
    private boolean isReadOnly = false;
    private Subject subjectReference = null;
    private short version = 1;
    private static final WebSphereRuntimePermission UPDATE_TOKEN = new WebSphereRuntimePermission("updateToken");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(AuthenticationTokenImpl.class, null, "com.ibm.ejs.resources.security");
    private static String factoryClass = null;

    public AuthenticationTokenImpl() {
        if (factoryClass == null) {
            factoryClass = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.wsspi.security.token.authenticationTokenFactory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "factoryClass:" + factoryClass);
            }
        }
    }

    public void initializeToken(String oid, Token _token) throws WSLoginFailedException {
        this.tokenName = oid;
        final Token tokenPriv = _token;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AuthenticationTokenImpl.this.setToken(tokenPriv);
                return null;
            }
        });
        this.token = _token;
    }

    public void initializeToken(String oid, byte[] credToken) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing authentication token.");
            }
            this.tokenName = oid;
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "109", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            if (e instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)e;
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (credToken != null) {
            this.token = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using byte[] to create token for OID: " + this.tokenName);
                }
                if (factoryClass != null) {
                    try {
                        this.token = this.ltpaServer.validateTokenAndRealm(credToken, factoryClass);
                    }
                    catch (Exception e) {
                        Tr.debug(tc, "Exception validating LTPA token by using factoryClass.", new Object[]{e});
                    }
                }
                if (this.token == null) {
                    this.token = this.ltpaServer.validateTokenAndRealm(credToken);
                }
                final Token tokenPriv = this.token;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        AuthenticationTokenImpl.this.setToken(tokenPriv);
                        return null;
                    }
                });
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.AuthenticationTokenImpl.initializeToken", "163", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.token.AuthenticationTokenImpl.initializeToken", "170", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        WSLoginFailedException e = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
        this.contextManager.setRootException(e);
        throw e;
    }

    public void initializeToken(Subject subject, String oid, byte[] credToken) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeToken(Subject,String,byte[])", new Object[]{"oid=" + oid, "credToken=" + credToken});
        }
        this.initializeToken(subject, oid, credToken, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(Subject,String,byte[])");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initializeToken(Subject subject, String oid, byte[] credToken, boolean refreshIfExpired) throws WSLoginFailedException {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeToken(Subject,String,byte[],boolean)", new Object[]{"oid=" + oid, "credToken=" + credToken, "refreshIfExpired=" + refreshIfExpired});
            }
            try {
                this.tokenName = oid;
                this.ltpaServer = LTPAServerObject.getLTPAServer();
                this.contextManager = ContextManagerFactory.getInstance();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "209", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                if (e instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)e;
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            if (credToken == null) {
                WSLoginFailedException e = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
                this.contextManager.setRootException(e);
                throw e;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using byte[] to create token for OID: " + this.tokenName);
                }
                if (this.tokenName.equals(this.KERBEROS_OID)) {
                    boolean isKrbAuthnToken = KRBAuthnTokenFactoryFactory.getFactory().isKRBAuthnToken(credToken);
                    if (isKrbAuthnToken) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "process KRBAuthnToken.");
                        }
                        KRBAuthnToken krbAuthnToken = KRBAuthnTokenFactoryFactory.getFactory().createToken(credToken);
                        this.gssCred = krbAuthnToken.getGSSCredential();
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "process initSecContext token. Really?");
                            Tr.debug(tc, "if this is the case, need to create KRBAuthnToken");
                        }
                        this.gssCred = Krb5WSCredentialUtils.validateToken(credToken);
                    }
                    if (this.gssCred != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding GSSCredential to Subject.");
                        }
                        SubjectHelper.putGSSCredentialInSubject(this.gssCred, subject);
                    }
                    break block17;
                }
                final Token tokenPriv = this.token = this.ltpaServer.validateToken(credToken, refreshIfExpired);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        AuthenticationTokenImpl.this.setToken(tokenPriv);
                        return null;
                    }
                });
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "277", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "284", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeToken(Subject,String,byte[],boolean)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeToken(Subject subject, String oid, GSSCredential gssCredential) throws WSLoginFailedException {
        if (gssCredential != null) {
            try {
                this.gssCred = gssCredential;
                if (this.gssCred == null) return;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding GSSCredential to Subject.");
                }
                SubjectHelper.putGSSCredentialInSubject(this.gssCred, subject);
                return;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "321", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else {
            WSLoginFailedException e = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
            this.contextManager.setRootException(e);
            throw e;
        }
    }

    public void initializeToken(Subject subject, String oid, String uid) throws WSLoginFailedException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Initializing authentication token.");
            }
            this.tokenName = oid;
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "347", this);
            Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
            this.contextManager.setRootException(e);
            if (e instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)e;
            }
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (uid != null) {
            if (this.tokenName.equals(this.KERBEROS_OID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trying to login with just UID when using Kerberos auth mechanism, throwing WSLoginFailedException...");
                }
                throw new WSLoginFailedException("Cannot login with just UserID (no password) when using Kerberos auth mechanism.");
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                sm.checkPermission(MAP_CREDENTIAL);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using uid to create token using factroy: " + factoryClass);
                }
                final Token tokenPriv = this.token = this.ltpaServer.createLTPAToken(uid, factoryClass);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        AuthenticationTokenImpl.this.setToken(tokenPriv);
                        return null;
                    }
                });
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "396", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.wsSAPInboundLoginModule.login", "403", this);
                Tr.debug(tc, "Exception validating LTPA token.", new Object[]{e});
                this.contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else {
            WSLoginFailedException e = new WSLoginFailedException("wsSAPInboundLoginModule: Invalid authentication data");
            this.contextManager.setRootException(e);
            throw e;
        }
    }

    public boolean isValid() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            Date d = new Date();
            Date expD = new Date(this.getExpiration());
            boolean valid = d.before(expD);
            return valid;
        }
        if (this.tokenName.equals(this.KERBEROS_OID)) {
            int life = 0;
            try {
                life = this.gssCred.getRemainingLifetime();
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{e});
            }
            return life > 0;
        }
        return false;
    }

    public long getExpiration() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            return super.getExpiration();
        }
        if (this.tokenName.equals(this.KERBEROS_OID)) {
            int life = -1;
            try {
                life = this.gssCred.getRemainingLifetime();
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception getting expiraion from GSSCredential.", new Object[]{e});
            }
            return (long)(life * 1000) + System.currentTimeMillis();
        }
        return -1L;
    }

    public boolean isForwardable() {
        return this.tokenName.equals(this.LTPA_OID);
    }

    public String getPrincipal() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            String[] accessIDArray = this.getAttributes("u");
            if (accessIDArray != null && accessIDArray.length > 0) {
                return accessIDArray[0];
            }
            return null;
        }
        if (this.tokenName.equals(this.KERBEROS_OID)) {
            String[] accessIDArray = this.getAttributes("u");
            if (accessIDArray != null && accessIDArray.length > 0) {
                return accessIDArray[0];
            }
            if (this.gssCred != null) {
                String princ = null;
                try {
                    princ = Krb5WSCredentialUtils.Krb5ToRegistryDN(((Object)this.gssCred.getName()).toString());
                    this.addAttribute("u", princ);
                }
                catch (Exception e) {
                    Tr.debug(tc, "Exception getting principal name from GSSCredential.", new Object[]{e});
                }
                return princ;
            }
            Tr.debug(tc, "GSSCredential is null, cannot get principal.");
        }
        return null;
    }

    public String getUniqueID() {
        String[] cacheKeyArray = this.getAttributes("com.ibm.wsspi.security.cred.cacheKey");
        if (cacheKeyArray != null && cacheKeyArray[0] != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found cache key in Authz token: " + cacheKeyArray[0]);
            }
            return cacheKeyArray[0];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No unique cache key found in token.");
        }
        return null;
    }

    public byte[] getBytes() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            try {
                return super.getBytes();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred getting bytes[] from token.", new Object[]{e});
                }
                FFDCFilter.processException(e, "com.ibm.ws.security.token.AbstractTokenImpl.getBytes", "580");
                return null;
            }
        }
        return new byte[0];
    }

    public String getName() {
        return this.tokenName;
    }

    public short getVersion() {
        return this.version;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.isReadOnly = true;
    }

    public String[] getAttributes(String key) {
        if (this.tokenName.equals(this.LTPA_OID)) {
            return super.getAttributes(key);
        }
        String data = (String)this.kerberosData.get(key);
        if (data != null) {
            String[] returnedData = new String[]{data};
            return returnedData;
        }
        return null;
    }

    public String[] addAttribute(String key, String value) {
        SecurityManager sm;
        if ((key.startsWith("com.ibm.wsspi.security") || key.startsWith("com.ibm.websphere.security")) && (sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + UPDATE_TOKEN.toString());
            }
            sm.checkPermission(UPDATE_TOKEN);
        }
        if (!this.isReadOnly) {
            if (this.tokenName.equals(this.LTPA_OID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting attribute with key: " + key);
                }
                return super.addAttribute(key, value);
            }
            String oldvalue = this.kerberosData.put(key, value);
            if (oldvalue != null) {
                String[] returnedData = new String[]{oldvalue};
                return returnedData;
            }
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        if (this.tokenName.equals(this.LTPA_OID)) {
            return super.getAttributeNames();
        }
        return this.kerberosData.keys();
    }

    public Object clone() {
        try {
            AuthenticationTokenImpl newToken = new AuthenticationTokenImpl();
            this.token = (Token)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AuthenticationTokenImpl.this.getToken();
                }
            });
            newToken.initializeToken(this.tokenName, (Token)this.token.clone());
            return newToken;
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception creating clone of authentication token.", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPAToken.clone", "737");
            return null;
        }
    }

    private void getGSSCredFromSubject() {
        if (this.subjectReference != null) {
            try {
                final Subject subjectPriv = this.subjectReference;
                this.gssCred = (GSSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        return subjectPriv.getPrivateCredentials(GSSCredential.class).iterator().next();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.token.AuthenticationTokenImpl.getGSSCredFromSubject", "764", this);
            }
        }
    }
}

