/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Util {
    private static final String ME = Util.class.getName();
    private static final Logger log = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char TILDA = '~';
    private static final char DOT = '.';

    public static String showHex(byte[] buffer) {
        int i;
        int nBytes = buffer.length;
        StringBuffer sb = new StringBuffer(nBytes);
        StringBuffer pb = new StringBuffer(nBytes << 1);
        StringBuffer hb = new StringBuffer(nBytes << 1);
        StringBuffer tb = new StringBuffer(nBytes << 1);
        int j = 0;
        int k = 0;
        float f = 0.0f;
        for (i = 0; i < nBytes; ++i) {
            int value = buffer[i] & 0xFF;
            if (value == 13 || value == 10 || value == 9 || value >= 32 && value <= 126) {
                sb.append((char)value);
            } else {
                sb.append('[' + Util.hexPad(Integer.toHexString(value), 2) + ']');
                f += 1.0f;
            }
            if (value >= 32 && value <= 126) {
                tb.append((char)value);
            } else {
                tb.append('.');
            }
            hb.append(Util.hexPad(Integer.toHexString(value), 2));
            if (j == 3 || j == 7 || j == 11) {
                hb.append(' ');
                tb.append(' ');
            }
            if (j == 15) {
                String pad = Util.hexPad(Integer.toHexString(k), 4);
                pb.append(pad).append(":  ").append(hb).append("    ").append(tb).append("\n");
                j = 0;
                k += 16;
                hb.setLength(0);
                tb.setLength(0);
                continue;
            }
            ++j;
        }
        for (i = hb.length(); i < 35; ++i) {
            hb.append(' ');
        }
        String pad = Util.hexPad(Integer.toHexString(k), 4);
        pb.append(pad).append(":  ").append(hb).append("    ").append(tb).append("\n");
        return pb.toString();
    }

    private static String hexPad(String aString, int aPadLength) {
        int stringSize = aString.length();
        StringBuffer buffer = new StringBuffer(stringSize + aPadLength);
        for (int i = stringSize; i < aPadLength; ++i) {
            buffer.append('0');
        }
        buffer.append(aString);
        return buffer.toString();
    }

    public static Map extractPropertiesWithPrefix(String prefix, Map propMap) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "extractPropertiesWithPrefix", "prefix=" + prefix + " Map=" + propMap);
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : propMap.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(prefix)) continue;
            result.put(name, entry.getValue());
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "extractPropertiesWithPrefix", "Map=" + result);
        }
        return result;
    }

    public static int findAvailableSpnId(String prefix, Map spnIdMap) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "findAvailableSpnId", "prefix=" + prefix + " Map=" + spnIdMap);
        }
        int result = spnIdMap.size() + 1;
        if (!spnIdMap.isEmpty()) {
            for (int k = 1; k < spnIdMap.size() + 1; ++k) {
                if (spnIdMap.containsKey(prefix + k)) continue;
                result = k;
                break;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "findAvailableSpnId", "id=" + result);
        }
        return result;
    }

    public static Map getSpnIdMap(String prefix, Map propMap) {
        if (log.isLoggable(Level.FINE)) {
            log.entering(ME, "getSpnIdMap", "prefix=" + prefix + " Map=" + propMap);
        }
        HashMap<String, Map> result = new HashMap<String, Map>();
        for (int k = 1; k < propMap.size() + 1; ++k) {
            Map spnId = Util.extractPropertiesWithPrefix(prefix + k + '.', propMap);
            if (spnId.isEmpty()) continue;
            result.put(prefix + k, spnId);
        }
        if (log.isLoggable(Level.FINE)) {
            log.exiting(ME, "getSpnIdMap", "Map=" + result);
        }
        return result;
    }
}

