/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import com.ibm.wsspi.security.spnego.SpnegoTAIFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class ServerConfig {
    private static final short STR_LENGTH = 200;
    private static final String _SPNEGO_NOT_SUPPORTED_DEFAULT = "<html><head><title>SPNEGO authentication is not supported.</title></head><body>SPNEGO authentication is not supported on this client.</body></html>";
    private static final String _SPNEGO_NOT_SUPPORTED_PAGE_CONTENT = TraceNLS.getFormattedMessage("com.ibm.ws.security.resources.AdminCommandText", "security.spnego.page.content.spnego.not.supported", new Object[0], "<html><head><title>SPNEGO authentication is not supported.</title></head><body>SPNEGO authentication is not supported on this client.</body></html>");
    private static final String _NTLM_TOKEN_RECEIVED_DEFAULT = "<html><head><title>An NTLM Token was received.</title></head><body>Your browser configuration is correct, but you have not logged into a supported Windows Domain.<p>Please login to the application using the normal login page.</html>";
    private static final String _NTLM_TOKEN_RECEIVED_PAGE_CONTENT = TraceNLS.getFormattedMessage("com.ibm.ws.security.resources.AdminCommandText", "security.spnego.page.content.ntlm.token.received", new Object[0], "<html><head><title>An NTLM Token was received.</title></head><body>Your browser configuration is correct, but you have not logged into a supported Windows Domain.<p>Please login to the application using the normal login page.</html>");
    private boolean enableCredDelegate;
    private String filter;
    private SpnegoTAIFilter filterClass;
    private Oid gssNameType;
    private int gssCredType;
    private int gssCredDuration;
    private String hostName;
    private String realm;
    private String serverName;
    private String spnegoNotSupportedPage;
    private String spnegoNotSupportedURL = null;
    private String NTLMTokenReceivedPage;
    private String NTLMTokenReceivedURL = null;
    private static final String ME = ServerConfig.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private boolean trimUserName;
    private static final String defaultContentType = "text/html";
    private String ntlmTokenReceivedPageContentType = "text/html";
    private String spnegoNotSupportedPageContentType = "text/html";

    public ServerConfig() {
        logger.entering(ME, "<constructor>");
        this.enableCredDelegate = false;
        this.trimUserName = true;
        this.gssNameType = GSSName.NT_USER_NAME;
        this.gssCredType = 2;
        this.gssCredDuration = Integer.MAX_VALUE;
        this.spnegoNotSupportedPage = null;
        this.NTLMTokenReceivedPage = null;
        this.ntlmTokenReceivedPageContentType = defaultContentType;
        this.spnegoNotSupportedPageContentType = defaultContentType;
        logger.exiting(ME, "<constructor>");
    }

    public SpnegoTAIFilter getFilterClass() {
        return this.filterClass;
    }

    public int getGssCredDuration() {
        return this.gssCredDuration;
    }

    public int getGssCredType() {
        return this.gssCredType;
    }

    public Oid getGssNameType() {
        return this.gssNameType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getNTLMTokenReceivedPage() {
        if (this.NTLMTokenReceivedPage == null) {
            this.loadNTLMTokenReceivedPage();
        }
        return this.NTLMTokenReceivedPage;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getSpnegoNotSupportedPage() {
        if (this.spnegoNotSupportedPage == null) {
            this.loadSpnegoNotSupportedPage();
        }
        return this.spnegoNotSupportedPage;
    }

    public boolean isEnableCredDelegate() {
        return this.enableCredDelegate;
    }

    public boolean isTrimUserName() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "isTrimUserName", "isTrimUserName = " + this.trimUserName);
        }
        return this.trimUserName;
    }

    public void setEnableCredDelegate(String b) {
        Boolean state = Boolean.valueOf(b);
        this.enableCredDelegate = state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setEnableCredDelegate");
            logger.exiting(ME, "setEnableCredDelegate", state);
        }
    }

    public void setFilter(String filterString, SpnegoTAIFilter filterClass) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setFilter", new Object[]{"filter string='" + filterString + "'", "filter class=" + filterClass});
        }
        if (filterString == null || filterString.length() == 0) {
            logger.logp(Level.FINER, ME, "setFilter", "Since no filter is defined, we force all requests to be processed");
            filterClass.setProcessAll(true);
        } else {
            filterClass.init(filterString);
        }
        this.filter = filterString;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setFilter");
        }
    }

    public void setFilterClass(String filterClassProp) throws TAIConfigurationException {
        ExtClassLoader contextCL;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setFilterClass", filterClassProp);
        }
        if (filterClassProp == null || filterClassProp.length() == 0) {
            filterClassProp = "com.ibm.ws.security.spnego.HTTPHeaderFilter";
        }
        if ((contextCL = ExtClassLoader.getInstance()) == null) {
            throw new TAIConfigurationException("Classloader initialization error");
        }
        try {
            Class<?> myClass = Class.forName(filterClassProp, true, contextCL);
            this.filterClass = (SpnegoTAIFilter)myClass.newInstance();
            if (!(this.filterClass instanceof SpnegoTAIFilter)) {
                throw new TAIConfigurationException("Wrong FilterClass implementation");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new TAIConfigurationException("FilterClass could not be found: " + filterClassProp);
        }
        catch (Exception e) {
            throw new TAIConfigurationException("Error initializing the FilterClass");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setFilterClass", "FilterClass set to " + this.filterClass.getClass());
        }
    }

    public void setGssCredDuration(String string) {
        String state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssCredDuration", string);
        }
        if (string.trim().equalsIgnoreCase("DEFAULT")) {
            this.gssCredDuration = 0;
            state = "GSSCredential.DEFAULT_LIFETIME";
        } else {
            this.gssCredDuration = Integer.MAX_VALUE;
            state = "GSSCredential.INDEFINITE_LIFETIME";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssCredDuration", "Credential duration set to " + state);
        }
    }

    public void setGssCredType(String string) {
        String state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssCredType", string);
        }
        if ((string = string.trim()).equalsIgnoreCase("INITIATE")) {
            this.gssCredType = 1;
            state = "GSSCredential.INITIATE_ONLY";
        } else if (string.equalsIgnoreCase("BOTH")) {
            this.gssCredType = 0;
            state = "GSSCredential.INITIATE_AND_ACCEPT";
        } else {
            this.gssCredType = 2;
            state = "GSSCredential.ACCEPT_ONLY";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssCredType", "Credential type set to " + state);
        }
    }

    public void setGssNameType(String string) {
        String state;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setGssNameType", string);
        }
        if (string.trim().equalsIgnoreCase("NT_HOSTBASED_SERVICE")) {
            this.gssNameType = GSSName.NT_HOSTBASED_SERVICE;
            state = "GSSName.NT_HOSTBASED_SERVICE";
        } else {
            this.gssNameType = GSSName.NT_USER_NAME;
            state = "GSSName.NT_USER_NAME";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setGssNameType", "Credential name type set to " + state);
        }
    }

    public void setNTLMTokenReceivedPage(String purl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setNTLMTokenReceivedPage", purl);
        }
        this.NTLMTokenReceivedURL = purl;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setNTLMTokenReceivedPage");
        }
    }

    public void setRealm(String string) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setRealm", string);
        }
        if (string == null) {
            throw new TAIConfigurationException("Kerberos Realm property is not set");
        }
        this.realm = string.toUpperCase().trim();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setRealm", "Kerberos realm set to " + this.realm);
        }
    }

    public void setServerName(String string) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setServerName", string);
        }
        if (string == null) {
            throw new TAIConfigurationException("Required property HostName is not set");
        }
        this.hostName = string = string.toLowerCase().trim();
        this.serverName = string;
        StringBuffer result = new StringBuffer();
        if (this.gssNameType == GSSName.NT_HOSTBASED_SERVICE) {
            result.append("HTTP@");
            result.append(string);
        } else if (this.gssNameType == GSSName.NT_USER_NAME) {
            result.append("HTTP/");
            result.append(string);
            result.append("@");
            result.append(this.realm);
        }
        this.serverName = result.toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setServerName", "hostName = " + this.hostName + "; serverName = " + this.serverName);
        }
    }

    public void setSpnegoNotSupportedPage(String purl) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setSpnegoNotSupportedPage", purl);
        }
        this.spnegoNotSupportedURL = purl;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setSpnegoNotSupportedPage");
        }
    }

    public void setTrimUserName(String b) {
        this.trimUserName = Boolean.valueOf(b);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setTrimUserName", b);
            logger.exiting(ME, "setTrimUserName");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        String keyName = "com.ibm.ws.security.spnego.SPN";
        sb.append("\t").append("Server configuration:");
        sb.append("\n\tKerberos ServicePrincipalName=").append(this.getServerName());
        sb.append("\n\t").append(keyName + ".filter" + "=").append(this.filter);
        sb.append("\n\t").append(keyName + ".filterClass" + "=").append(this.getFilterClass());
        sb.append("\n\t").append(keyName + ".NTLMTokenReceivedPage" + "=").append(this.NTLMTokenReceivedURL);
        sb.append("\n\t").append(keyName + ".spnegoNotSupportedPage" + "=").append(this.spnegoNotSupportedURL);
        return sb.toString();
    }

    private void loadSpnegoNotSupportedPage() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "loadSpnegoNotSupportedPage", this.spnegoNotSupportedURL);
        }
        URL pageURL = null;
        StringBuffer notSupportedPageBuffer = new StringBuffer();
        if (this.spnegoNotSupportedURL != null) {
            try {
                String line;
                String urlContentType;
                URLConnection pageConnection;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "loadSpnegoNotSupportedPage", "Loading SPNEGO not supported content...");
                }
                if ((pageConnection = (pageURL = new URL(this.spnegoNotSupportedURL)).openConnection()) != null && (urlContentType = pageConnection.getContentType()) != null && urlContentType.length() > 0) {
                    this.spnegoNotSupportedPageContentType = urlContentType;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "loadSpnegoNotSupportedPage", "spnegoNotSupportedPage contentType: " + urlContentType);
                    }
                }
                InputStream in = pageURL.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((line = br.readLine()) != null) {
                    notSupportedPageBuffer.append(line + "\r\n");
                }
                in.close();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "loadSpnegoNotSupportedPage", "... content has been loaded.");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.ServerConfig.loadSpnegoNotSupportedPage", "665", this);
                logger.logp(Level.WARNING, ME, "loadSpnegoNotSupportedPage", "security.spnego.no.content.loaded", new Object[]{this.spnegoNotSupportedURL, e.getLocalizedMessage()});
                notSupportedPageBuffer.append(_SPNEGO_NOT_SUPPORTED_PAGE_CONTENT);
            }
        } else {
            notSupportedPageBuffer.append(_SPNEGO_NOT_SUPPORTED_PAGE_CONTENT);
        }
        this.spnegoNotSupportedPage = notSupportedPageBuffer.toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "loadSpnegoNotSupportedPage");
        }
    }

    private void loadNTLMTokenReceivedPage() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "loadNTLMTokenReceiveddPage", this.NTLMTokenReceivedURL);
        }
        URL pageURL = null;
        StringBuffer NTLMTokenReceivedBuffer = new StringBuffer();
        if (this.NTLMTokenReceivedURL != null) {
            try {
                String line;
                String urlContentType;
                URLConnection pageConnection;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "loadNTLMTokenReceivedPage", "Loading NTLM Token Received content...");
                }
                if ((pageConnection = (pageURL = new URL(this.NTLMTokenReceivedURL)).openConnection()) != null && (urlContentType = pageConnection.getContentType()) != null && urlContentType.length() > 0) {
                    this.ntlmTokenReceivedPageContentType = urlContentType;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "loadNTLMTokenReceivedPage", "ntlmTokenReceivedPage contentType: " + urlContentType);
                    }
                }
                InputStream in = pageURL.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((line = br.readLine()) != null) {
                    NTLMTokenReceivedBuffer.append(line + "\r\n");
                }
                in.close();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "loadNTLMTokenReceivedPage", "... content has been loaded.");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.spnego.ServerConfig.loadNTLMTokenReceivedPage", "718", this);
                logger.logp(Level.WARNING, ME, "loadNTLMTokenReceivedPage", "security.spnego.no.content.loaded", new Object[]{this.NTLMTokenReceivedURL, e.getLocalizedMessage()});
                NTLMTokenReceivedBuffer.append(_NTLM_TOKEN_RECEIVED_PAGE_CONTENT);
            }
        } else {
            NTLMTokenReceivedBuffer.append(_NTLM_TOKEN_RECEIVED_PAGE_CONTENT);
        }
        this.NTLMTokenReceivedPage = NTLMTokenReceivedBuffer.toString();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "loadNTLMTokenReceivedPage");
        }
    }

    public String getNtlmTokenReceivedPageContentType() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getNtlmTokenReceivedPageContentType", "contentType: " + this.ntlmTokenReceivedPageContentType);
        }
        return this.ntlmTokenReceivedPageContentType;
    }

    public String getSpnegoNotSupportedPageContentType() {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "getSpnegoNotSupportedPageContentType", "contentType: " + this.spnegoNotSupportedPageContentType);
        }
        return this.spnegoNotSupportedPageContentType;
    }
}

