/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.security.spnego.FailoverException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.ietf.jgss.GSSCredential;

public class CredentialManager
implements HttpSessionListener {
    private static Hashtable table;
    private static final String ME;
    private static final Logger logger;

    public void sessionCreated(HttpSessionEvent e) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "sessionCreated", e.getSession().getId());
            logger.exiting(ME, "sessionCreated");
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "sessionDestroyed", session);
        }
        String sessionId = CredentialManager.removeDelegatedCredential(session);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "sessionDestroyed", "Session id: " + sessionId);
        }
    }

    public static String addDelegatedCredential(HttpSession session, GSSCredential clientCred) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "addDelegatedCredential");
        }
        Long timestamp = new Long(System.currentTimeMillis());
        String sessionId = session.getId();
        session.setAttribute("com.ibm.ws.security.spnego.TimeOfStoredCredential", timestamp);
        table.put(sessionId, clientCred);
        String TIMESTAMP = "TIMESTAMP" + sessionId;
        table.put(TIMESTAMP, timestamp);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "addDelegatedCredential", "Session id: " + sessionId);
        }
        return sessionId;
    }

    private static String removeDelegatedCredential(HttpSession session) {
        String sessionId = session.getId();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "removeDelegatedCredential", sessionId);
        }
        table.remove(sessionId);
        String TIMESTAMP = "TIMESTAMP" + sessionId;
        table.remove(TIMESTAMP);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "removeDelegatedCredential");
        }
        return sessionId;
    }

    public static GSSCredential getDelegatedCredential(HttpSession session) throws FailoverException {
        String id = session.getId();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getDelegatedCredential", id);
        }
        Long sessionTimestamp = (Long)session.getAttribute("com.ibm.ws.security.spnego.TimeOfStoredCredential");
        GSSCredential delegCred = (GSSCredential)table.get(id);
        if (delegCred == null || sessionTimestamp == null) {
            CredentialManager.removeDelegatedCredential(session);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "getDelegatedCredential", "No delegated credentials were found");
            }
            throw new FailoverException();
        }
        Long tableTimestamp = (Long)table.get("TIMESTAMP" + id);
        if (!tableTimestamp.equals(sessionTimestamp)) {
            CredentialManager.removeDelegatedCredential(session);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "getDelegatedCredential", "Stale credentials were found");
            }
            throw new FailoverException();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "getDelegatedCredential", delegCred);
        }
        return delegCred;
    }

    static {
        ME = CredentialManager.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
        table = new Hashtable();
    }
}

