/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.distSecurityComponentImpl;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class SecurityServerFactory {
    private static final TraceComponent tc = Tr.register(SecurityServerFactory.class, null, "com.ibm.ejs.resources.security");
    public static SecurityServerImpl newSecServerImpl = null;

    public static SecurityServer create() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (newSecServerImpl == null) {
            try {
                PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
                newSecServerImpl = new SecurityServerImpl();
                String serverType = AdminServiceFactory.getAdminService().getServerType();
                String aaNodeName = AdminServiceFactory.getAdminService().getNodeName();
                String aaCellName = AdminServiceFactory.getAdminService().getCellName();
                ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
                Properties tmpProperties = new Properties();
                tmpProperties.setProperty("local.cell", aaCellName);
                managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(tmpProperties);
                String prodName = managedObjectMetadataAccessor.getMetadataProperty(aaNodeName, "com.ibm.websphere.baseProductShortName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prodName: " + prodName);
                }
                if (!prodName.equalsIgnoreCase("nddmz")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server type: " + serverType);
                    }
                    if (!(!distSecurityComponentImpl.isOrbServiceAvailable() || ph.isZOS() && !ph.isControlJvm() || serverType.equals("PROXY_SERVER") || serverType.equals("ONDEMAND_ROUTER"))) {
                        SecurityServerFactory.bind_security_server("SecurityServer");
                        SecurityServerFactory.bind_security_server_to_nonWLM_namespace("SecurityServer");
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.server.SecurityServerFactory.create", "104");
                Tr.error(tc, "security.secvrfactory.createrr", new Object[]{e});
                throw e;
            }
        }
        return newSecServerImpl;
    }

    public static void setConfigurator(RoleBasedConfigurator rbc) {
        if (newSecServerImpl != null) {
            newSecServerImpl.setConfigurator(rbc);
        }
    }

    public static void bind_security_server(String securityServerName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind_security_server", securityServerName);
        }
        InitialContext ic = null;
        try {
            ic = new InitialContext();
        }
        catch (NamingException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server", "138");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to get initial naming context");
            }
            Tr.error(tc, "security.getting.initctx.error", new Object[]{e});
        }
        try {
            ic.rebind(securityServerName, (Object)newSecServerImpl);
        }
        catch (NamingException e1) {
            FFDCFilter.processException(e1, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server", "150");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to bind security server to local name space");
            }
            Tr.error(tc, "security.bind.server.error", new Object[]{e1});
        }
    }

    public static void bind_security_server_to_nonWLM_namespace(String securityServerName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind_security_server_to_nonWLM_namespace", securityServerName);
        }
        InitialContext ic = null;
        try {
            Properties env = new Properties();
            env.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
            ic = new InitialContext(env);
        }
        catch (NamingException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server_to_nonWLM_namespace", "175");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to get initial naming context");
            }
            Tr.error(tc, "security.getting.initctx.error", new Object[]{e});
        }
        try {
            ic.rebind(securityServerName, (Object)newSecServerImpl);
        }
        catch (NamingException e1) {
            FFDCFilter.processException(e1, "com.ibm.ws.security.server.SecurityServerFactory.bind_security_server_to_nonWLM_namespace", "187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to bind security server to local name space");
            }
            Tr.error(tc, "security.bind.server.error", new Object[]{e1});
        }
    }
}

