/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.nt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.nt.GroupEnumeration;
import com.ibm.ws.security.registry.nt.NTException;
import com.ibm.ws.security.registry.nt.UserEnumeration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class NTRegistryImpl {
    private static TraceComponent tc = Tr.register(NTRegistryImpl.class, null, "com.ibm.ejs.resources.security");
    private static final int NERR_BASE = 2100;
    private static final int NERR_UserNotFound = 2221;
    private static final int NERR_GroupNotFound = 2220;
    private int nativeStructure;
    private String serverName = null;
    private String realm = null;
    private String realmWithSep = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private boolean localRegistry = true;
    private boolean isLocalOrDomain = false;
    int maxUidSize = -1;
    int maxPWSize = -1;

    public NTRegistryImpl() {
        this.localRegistry = true;
    }

    public NTRegistryImpl(boolean local) {
        this.localRegistry = local;
    }

    int getNativeStructure() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNativeStructure");
        }
        int i = this.nativeStructure;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNativeStructure");
        }
        return i;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public String checkPassword(String userId, String password) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword", userId);
        }
        if (userId.length() > this.getMaxUidSize() || password.length() > this.getMaxPWSize()) {
            Tr.error(tc, "security.registry.checkpass.failed", new Object[]{userId});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword failed due to userid length (" + userId.length() + ") and/or password length " + password.length() + ") too large.");
        }
        boolean check = false;
        try {
            check = this.p_checkPassword(userId, password);
        }
        catch (NTException ne) {
            this.logErrorCode(ne);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword");
            }
            throw new PasswordCheckFailedException("Authentication failed for user " + userId + " with the following error message " + ne.getMessage(), ne);
        }
        if (check) {
            if (this.isLocalOrDomain) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword ", userId);
                }
                return userId;
            }
            String userName = this.realm + "\\" + userId;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword ", userName);
            }
            return userName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword ");
        }
        throw new PasswordCheckFailedException("Authentication failed for user " + userId);
    }

    public String getGroupDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName");
        }
        return NONE;
    }

    public String getUniqueGroupId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", securityName);
        }
        String name = this.getPrivilegeAttributeId(securityName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", name);
        }
        return name;
    }

    public Enumeration getGroups(String pattern) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", pattern);
        }
        GroupEnumeration e = new GroupEnumeration(this, pattern, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups");
        }
        return e;
    }

    public String[] getGroupsForUser(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", securityName);
        }
        String[] groups = null;
        try {
            groups = this.p_getGroupsForUser(securityName);
        }
        catch (NTException nre) {
            this.logErrorCode(nre);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", nre);
            }
            if (nre.getErrorCode() == 2221) {
                throw new EntryNotFoundException(securityName, nre);
            }
            throw new CustomRegistryException(nre.getMessage(), nre);
        }
        if (groups == null || groups.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups for user: " + securityName);
            }
            groups = new String[]{};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser");
        }
        return groups;
    }

    public String[] getGroupIDsForUser(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupIDsForUser", securityName);
        }
        String[] groups = new String[]{};
        try {
            groups = this.p_getGroupIDsForUser(securityName);
        }
        catch (NTException nre) {
            this.logErrorCode(nre);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupIDsForUser", nre);
            }
            if (nre.getErrorCode() == 2221) {
                Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName, nre});
                throw new EntryNotFoundException(securityName, nre);
            }
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName, nre});
            throw new CustomRegistryException(nre.getMessage(), nre);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupIDsForUser");
        }
        return groups;
    }

    public String getGroupSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", privilegeAttributeId);
        }
        String s = this.getSecurityName0(privilegeAttributeId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName");
        }
        return s;
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", securityName);
        }
        try {
            String name = this.p_getUserName(securityName);
            if (name.length() != 0) {
                name = this.realm + "\\" + name;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserDisplayName");
            }
            return name;
        }
        catch (NTException nre) {
            this.logErrorCode(nre);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserDisplayName", nre);
            }
            if (nre.getErrorCode() == 2221) {
                throw new EntryNotFoundException(securityName, nre);
            }
            throw new CustomRegistryException(nre.getMessage(), nre);
        }
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", securityName);
        }
        String name = null;
        if (securityName != null && securityName.equalsIgnoreCase(this.realm)) {
            securityName = new StringBuffer(this.realm).append("\\").append(securityName).toString();
        }
        name = this.getPrivilegeAttributeId(securityName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", name);
        }
        return name;
    }

    public ArrayList getOneUser(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneUser", pattern);
        }
        String userName = null;
        try {
            userName = this.p_getOneUser(pattern);
        }
        catch (NTException ne) {
            this.logErrorCode(ne);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOneUser", ne);
            }
            throw new CustomRegistryException(ne.getMessage(), ne);
        }
        ArrayList<String> oneUser = new ArrayList<String>(1);
        oneUser.add(userName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneUser");
        }
        return oneUser;
    }

    public Enumeration getUsers(String pattern) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", pattern);
        }
        UserEnumeration e = new UserEnumeration(this, pattern, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return e;
    }

    public Enumeration getUsers() throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers");
        }
        UserEnumeration e = new UserEnumeration(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return e;
    }

    public String getUserSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", privilegeAttributeId);
        }
        String s = null;
        s = this.getSecurityName0(privilegeAttributeId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName");
        }
        return s;
    }

    public void initialize(Properties props) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        String useLocalOrDomain = null;
        if (props != null) {
            useLocalOrDomain = props.getProperty("com.ibm.websphere.registry.UseRegistry");
        }
        if (useLocalOrDomain != null && (useLocalOrDomain.equalsIgnoreCase("Domain") || useLocalOrDomain.equalsIgnoreCase("Local"))) {
            this.isLocalOrDomain = true;
            try {
                if (useLocalOrDomain.equalsIgnoreCase("Domain")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting the Domain Name");
                    }
                    this.realm = this.p_getDomainName();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting the Computer Name");
                    }
                    this.realm = this.p_getMachineName();
                }
                this.p_initNativeStructure();
            }
            catch (NTException nte) {
                FFDCFilter.processException((Throwable)nte, "com.ibm.ws.security.registry.nt.NTRegistryImpl.initialize", "350", this);
                this.logErrorCode(nte);
                Tr.error(tc, "security.registry.initerror", new Object[]{nte});
                throw new CustomRegistryException(nte.getMessage(), nte);
            }
        }
        try {
            this.realm = this.p_getDomainName();
            if (this.realm == null && !this.localRegistry) {
                throw new CustomRegistryException("Unable to contact domain controller");
            }
            if (this.realm != null) {
                this.serverName = this.p_getDCName();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting the machine name");
                }
                this.realm = this.p_getMachineName();
            }
            this.p_initNativeStructure();
        }
        catch (NTException nte) {
            this.logErrorCode(nte);
            throw new CustomRegistryException(nte.getMessage(), nte);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public boolean isValidGroup(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup", securityName);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup");
            }
            return this.p_isValidGroup(securityName);
        }
        catch (NTException ne) {
            this.logErrorCode(ne);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup", ne);
            }
            throw new CustomRegistryException(ne.getMessage(), ne);
        }
    }

    public boolean isValidUser(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", securityName);
        }
        try {
            return this.p_isValidUser(securityName);
        }
        catch (NTException ne) {
            this.logErrorCode(ne);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", ne);
            }
            throw new CustomRegistryException(ne.getMessage(), ne);
        }
    }

    private String getPrivilegeAttributeId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrivilegeAttributeId", securityName);
        }
        try {
            String attrId = this.p_lookupAccountName(securityName);
            if (attrId == null) {
                EntryNotFoundException ex = new EntryNotFoundException("Cannot obtain the uniqueID for " + securityName);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPrivilegeAttributeId", ex);
                }
                throw ex;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrivilegeAttributeId", attrId);
            }
            return attrId;
        }
        catch (NTException nte) {
            this.logErrorCode(nte);
            throw new CustomRegistryException("Cannot find uniqueID for the user " + securityName, nte);
        }
    }

    private String getSecurityName0(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName0", privilegeAttributeId);
        }
        try {
            String secName = this.p_lookupAccountSID(privilegeAttributeId);
            if (secName == null) {
                EntryNotFoundException ex = new EntryNotFoundException("cannot find entry " + privilegeAttributeId);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSecurityName0", ex);
                }
                throw ex;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityName0", secName);
            }
            return secName;
        }
        catch (NTException nte) {
            this.logErrorCode(nte);
            throw new CustomRegistryException("no security name configured for privilege id: " + privilegeAttributeId, nte);
        }
    }

    private int getMaxUidSize() {
        if (this.maxUidSize == -1) {
            String maxUidString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.registry.maxUseridSize");
            this.maxUidSize = maxUidString != null ? Integer.parseInt(maxUidString) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxUidSize: " + this.maxUidSize);
            }
        }
        return this.maxUidSize;
    }

    private int getMaxPWSize() {
        if (this.maxPWSize == -1) {
            String maxPWString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.registry.maxPasswordSize");
            this.maxPWSize = maxPWString != null ? Integer.parseInt(maxPWString) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxPWSize: " + this.maxPWSize);
            }
        }
        return this.maxPWSize;
    }

    private void logErrorCode(NTException nte) {
        StringBuffer sb = new StringBuffer("Native error code = ");
        sb.append(nte.getErrorCode());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sb.toString());
        }
    }

    public static void nativeDebugTr(int line, String message) {
        if (tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Native line ");
            sb.append(line);
            sb.append(": ");
            sb.append(message);
            Tr.debug(tc, sb.toString());
        }
    }

    public static void nativeTr(String msgID, char msgType, Object[] o) {
        if (msgID != null) {
            switch (msgType) {
                case 'A': 
                case 'a': {
                    Tr.audit(tc, msgID, o);
                    break;
                }
                case 'E': 
                case 'e': {
                    Tr.error(tc, msgID, o);
                    break;
                }
                case 'W': 
                case 'w': {
                    Tr.warning(tc, msgID, o);
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Invalid msg ID: " + msgID, o);
                }
            }
        }
    }

    private native void p_initNativeStructure() throws NTException;

    public native String p_getDomainName() throws NTException;

    public native String p_getDCName() throws NTException;

    public native String p_getMachineName() throws NTException;

    private native String[] p_getGroupsForUser(String var1) throws NTException;

    private native String p_getUserName(String var1) throws NTException;

    private native boolean p_isValidGroup(String var1) throws NTException;

    private native boolean p_isValidUser(String var1) throws NTException;

    private native String p_getOneUser(String var1) throws NTException;

    private native boolean p_checkPassword(String var1, String var2) throws NTException;

    private native String p_lookupAccountName(String var1) throws NTException;

    private native String p_lookupAccountSID(String var1) throws NTException;

    private native String[] p_getGroupIDsForUser(String var1) throws NTException;

    static {
        System.loadLibrary("NTRegistry");
    }
}

