/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.nt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.nt.NTRegistryImpl;
import com.ibm.ws.security.util.RegExp;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class ArrayEnumeration
implements Enumeration {
    private static TraceComponent tc = Tr.register(ArrayEnumeration.class, null, "com.ibm.ejs.resources.security");
    protected NTRegistryImpl ntRegistry;
    protected RegExp filter;
    protected String[] array;
    protected int arrayLen = 0;
    protected int index = 0;
    protected int resumeHandle = 0;
    protected boolean done = false;

    public ArrayEnumeration(NTRegistryImpl ntReg) throws RegistryErrorException {
        this(ntReg, 0, null, false);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArrayEnumeration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArrayEnumeration");
        }
    }

    public ArrayEnumeration(NTRegistryImpl ntReg, int initialCapacity, String pattern) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArrayEnumeration");
        }
        this.ntRegistry = ntReg;
        if (initialCapacity > 0) {
            this.array = new String[initialCapacity];
        }
        if (pattern != null) {
            this.filter = new RegExp(pattern);
        }
        this.getMoreData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArrayEnumeration");
        }
    }

    public ArrayEnumeration(NTRegistryImpl ntReg, int initialCapacity, String pattern, boolean caseInsensitive) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArrayEnumeration");
        }
        this.ntRegistry = ntReg;
        if (initialCapacity > 0) {
            this.array = new String[initialCapacity];
        }
        if (pattern != null) {
            this.filter = new RegExp(pattern, caseInsensitive);
        }
        this.getMoreData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArrayEnumeration");
        }
    }

    public boolean hasMoreElements() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasMoreElements");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasMoreElements");
        }
        return this.index < this.arrayLen;
    }

    public Object nextElement() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nextElement");
        }
        if (this.index > this.arrayLen) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "index > arrayLen");
            }
            throw new NoSuchElementException();
        }
        String o = this.array[this.index++];
        while (this.index != this.arrayLen && this.array[this.index] == null) {
            ++this.index;
        }
        if (!this.done && this.index == this.arrayLen) {
            try {
                this.getMoreData();
            }
            catch (RegistryErrorException exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.registry.nt.ArrayEnumeration.nextElement", "80", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "nextElement", exc);
                }
                this.arrayLen = 0;
                this.index = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nextElement");
        }
        return o;
    }

    protected void getMoreData() throws RegistryErrorException {
        int count;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMoreData");
        }
        boolean foundMatch = false;
        do {
            this.obtainData();
            count = this.arrayLen;
            if (this.filter == null) continue;
            this.index = this.arrayLen;
            for (int i = 0; i < this.arrayLen; ++i) {
                if (!this.filter.match(this.array[i])) {
                    this.array[i] = null;
                    --count;
                    continue;
                }
                if (foundMatch) continue;
                this.index = i;
                foundMatch = true;
            }
        } while (!this.done && count == 0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMoreData");
        }
    }

    protected abstract void obtainData() throws RegistryErrorException;
}

