/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.AuthenticationNotSupportedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.util.ConfigUtils;
import com.tivoli.mts.PDPrincipal;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;

public class TAMLdapRegistryImpl
extends LdapRegistryImpl {
    private static URL propURL = null;
    private static TraceComponent tc = Tr.register(TAMLdapRegistryImpl.class, null, "com.ibm.ejs.resources.security");

    public void initialize(Properties props) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        super.initialize(props);
        String pURL = null;
        if (props != null) {
            pURL = (String)props.get("com.ibm.websphere.security.registry.TAMPropURL");
        }
        try {
            if (pURL != null && pURL.length() > 0) {
                if (pURL.startsWith("$")) {
                    pURL = ConfigUtils.expandString(pURL);
                }
                propURL = new File(pURL).toURL();
                if (tc.isDebugEnabled() && propURL != null) {
                    Tr.debug(tc, "URL is: " + propURL);
                }
            }
        }
        catch (MalformedURLException exc) {
            FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", "55", this);
            Tr.error(tc, "security.registry.ldap.initerror", new Object[]{exc});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
            throw new CustomRegistryException(exc.toString(), exc);
        }
        Tr.audit(tc, "security.registry.TAM.initialize");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    protected String authenticate(String dn, String pwd) throws AuthenticationFailedException, AuthenticationNotSupportedException, RegistryErrorException, CustomRegistryException {
        long startTime = 0L;
        String newdn = LdapRegistryImpl.escapeChar(dn, '*');
        try {
            startTime = System.currentTimeMillis();
            PDPrincipal theRes = new PDPrincipal(dn, pwd.toCharArray(), propURL);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authenticated the user: " + dn + " using AM");
                StringBuffer sb = new StringBuffer("Time elapsed to open/close DirContext: ");
                sb = sb.append(System.currentTimeMillis() - startTime);
                Tr.debug(tc, sb.toString());
            }
            return dn;
        }
        catch (NullPointerException npe) {
            FFDCFilter.processException((Throwable)npe, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", "111", this);
            Tr.error(tc, "security.authn.error", new Object[]{dn, npe});
            throw new AuthenticationFailedException(npe.getMessage(), npe);
        }
        catch (IllegalArgumentException iae) {
            FFDCFilter.processException((Throwable)iae, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", "117", this);
            Tr.error(tc, "security.authn.error", new Object[]{dn, iae});
            throw new AuthenticationFailedException(iae.getMessage(), iae);
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", "122", this);
            Tr.error(tc, "security.authn.error", new Object[]{dn, ise});
            throw new AuthenticationFailedException(ise.getMessage(), ise);
        }
    }

    public boolean isValidUser(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", securityName);
        }
        try {
            PDPrincipal theRes = new PDPrincipal(securityName, propURL);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Verified the user: " + securityName + " using AM");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", securityName);
            }
            return true;
        }
        catch (NullPointerException npe) {
            FFDCFilter.processException((Throwable)npe, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", "141", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName, npe});
            throw new CustomRegistryException(npe.getMessage(), npe);
        }
        catch (IllegalArgumentException iae) {
            FFDCFilter.processException((Throwable)iae, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", "146", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName, iae});
            throw new CustomRegistryException(iae.getMessage(), iae);
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", "151", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName, ise});
            throw new CustomRegistryException(ise.getMessage(), ise);
        }
    }
}

